/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.base.Documentation;
import org.eclipse.etrice.core.common.documentation.DocumentationMarkup;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubProtocol;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.AbstractGeneratorOptionsHelper;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.doc.Main;
import org.eclipse.etrice.generator.fsm.base.CodegenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class AsciiDocGen {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CodegenHelpers _codegenHelpers;
    @Inject
    @Extension
    protected AbstractGeneratorOptionsHelper _abstractGeneratorOptionsHelper;
    @Inject
    private IEObjectDocumentationProvider eObjDocuProvider;

    public void doGenerate(Root root, IGeneratorFileIO fileIO, boolean includeImages) {
        Functions.Function1 _function = it -> it.getName();
        Functions.Function1 _function_1 = it -> {
            String _key = (String)it.getKey();
            List _value = (List)it.getValue();
            return new RoomPackage(_key, _value);
        };
        Functions.Function1 _function_2 = it -> it.name;
        List packages = IterableExtensions.sortBy((Iterable)IterableExtensions.map(IterableExtensions.groupBy((Iterable)root.getModels(), (Functions.Function1)_function).entrySet(), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        fileIO.generateFile("doc.adoc", this.generateSingleDoc(packages, includeImages));
    }

    public CharSequence generateSingleDoc(Iterable<RoomPackage> packages, boolean includeImages) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("= Model Documentation");
        _builder.newLine();
        _builder.append("generated by eTrice");
        _builder.newLine();
        _builder.append("{docdatetime}");
        _builder.newLine();
        _builder.append(":toc: left");
        _builder.newLine();
        _builder.append(":toclevels: 2");
        _builder.newLine();
        _builder.append(":table-caption!:");
        _builder.newLine();
        boolean _isEmpty = IterableExtensions.isEmpty(packages);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.newLine();
            _builder.append(".Room Packages");
            _builder.newLine();
            for (RoomPackage pkg : packages) {
                _builder.append("* ");
                CharSequence _crossReference = AsciiDocGen.crossReference(pkg.name);
                _builder.append((Object)_crossReference);
                _builder.newLineIfNotEmpty();
            }
        }
        for (RoomPackage pkg_1 : packages) {
            _builder.newLine();
            CharSequence _generatePackageDoc = this.generatePackageDoc(pkg_1);
            _builder.append((Object)_generatePackageDoc);
            _builder.newLineIfNotEmpty();
            for (EnumerationType en : pkg_1.enumerationTypes) {
                _builder.newLine();
                CharSequence _generateEnumerationDoc = this.generateEnumerationDoc(en);
                _builder.append((Object)_generateEnumerationDoc);
                _builder.newLineIfNotEmpty();
            }
            for (DataClass dc : pkg_1.dataClasses) {
                _builder.newLine();
                CharSequence _generateDataDoc = this.generateDataDoc(dc);
                _builder.append((Object)_generateDataDoc);
                _builder.newLineIfNotEmpty();
            }
            for (GeneralProtocolClass pc : pkg_1.protocolClasses) {
                _builder.newLine();
                CharSequence _generateProtocolDoc = this.generateProtocolDoc(pc);
                _builder.append((Object)_generateProtocolDoc);
                _builder.newLineIfNotEmpty();
            }
            for (LogicalSystem sys : pkg_1.systems) {
                _builder.newLine();
                CharSequence _generateLogicalSystemDoc = this.generateLogicalSystemDoc(sys, includeImages);
                _builder.append((Object)_generateLogicalSystemDoc);
                _builder.newLineIfNotEmpty();
            }
            for (SubSystemClass subSys : pkg_1.subSystemClasses) {
                _builder.newLine();
                CharSequence _generateSubSystemDoc = this.generateSubSystemDoc(subSys, includeImages);
                _builder.append((Object)_generateSubSystemDoc);
                _builder.newLineIfNotEmpty();
            }
            for (ActorClass ac : pkg_1.actorClasses) {
                _builder.newLine();
                CharSequence _generateActorDoc = this.generateActorDoc(ac, includeImages);
                _builder.append((Object)_generateActorDoc);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generatePackageDoc(RoomPackage pkg) {
        boolean _isEmpty_5;
        boolean _not_5;
        boolean _isEmpty_4;
        boolean _not_4;
        boolean _isEmpty_3;
        boolean _not_3;
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _defineAnchor = AsciiDocGen.defineAnchor(pkg.name);
        _builder.append((Object)_defineAnchor);
        _builder.newLineIfNotEmpty();
        _builder.append("== ");
        _builder.append(pkg.name);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = IterableExtensions.isEmpty(pkg.systems);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.newLine();
            _builder.append(".Logical System Classes");
            _builder.newLine();
            _builder.append("|===");
            _builder.newLine();
            _builder.append("| Name | Description");
            _builder.newLine();
            for (LogicalSystem s : pkg.systems) {
                _builder.newLine();
                _builder.append("| ");
                CharSequence _crossReference = AsciiDocGen.crossReference((RoomClass)s);
                _builder.append((Object)_crossReference);
                _builder.newLineIfNotEmpty();
                _builder.append("| ");
                CharSequence _shortDocText = this.getShortDocText((EObject)s);
                _builder.append((Object)_shortDocText);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("|===");
            _builder.newLine();
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = IterableExtensions.isEmpty(pkg.subSystemClasses));
        if (_not_1) {
            _builder.newLine();
            _builder.append(".Subsystem Classes");
            _builder.newLine();
            _builder.append("|===");
            _builder.newLine();
            _builder.append("| Name | Description");
            _builder.newLine();
            for (SubSystemClass s_1 : pkg.subSystemClasses) {
                _builder.newLine();
                _builder.append("| ");
                CharSequence _crossReference_1 = AsciiDocGen.crossReference((RoomClass)s_1);
                _builder.append((Object)_crossReference_1);
                _builder.newLineIfNotEmpty();
                _builder.append("| ");
                CharSequence _shortDocText_1 = this.getShortDocText((EObject)s_1);
                _builder.append((Object)_shortDocText_1);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("|===");
            _builder.newLine();
        }
        boolean bl3 = _not_2 = !(_isEmpty_2 = IterableExtensions.isEmpty(pkg.protocolClasses));
        if (_not_2) {
            _builder.newLine();
            _builder.append(".ProtocolClasses");
            _builder.newLine();
            _builder.append("|===");
            _builder.newLine();
            _builder.append("| Name | Description");
            _builder.newLine();
            for (GeneralProtocolClass c : pkg.protocolClasses) {
                _builder.newLine();
                _builder.append("| ");
                CharSequence _crossReference_2 = AsciiDocGen.crossReference((RoomClass)c);
                _builder.append((Object)_crossReference_2);
                _builder.newLineIfNotEmpty();
                _builder.append("| ");
                CharSequence _shortDocText_2 = this.getShortDocText((EObject)c);
                _builder.append((Object)_shortDocText_2);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("|===");
            _builder.newLine();
        }
        boolean bl4 = _not_3 = !(_isEmpty_3 = IterableExtensions.isEmpty(pkg.enumerationTypes));
        if (_not_3) {
            _builder.newLine();
            _builder.append(".Enumeration Types");
            _builder.newLine();
            _builder.append("|===");
            _builder.newLine();
            _builder.append("| Name | Description");
            _builder.newLine();
            for (EnumerationType e : pkg.enumerationTypes) {
                _builder.newLine();
                _builder.append("| ");
                CharSequence _crossReference_3 = AsciiDocGen.crossReference((RoomClass)e);
                _builder.append((Object)_crossReference_3);
                _builder.newLineIfNotEmpty();
                _builder.append("| ");
                CharSequence _shortDocText_3 = this.getShortDocText((EObject)e);
                _builder.append((Object)_shortDocText_3);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("|===");
            _builder.newLine();
        }
        boolean bl5 = _not_4 = !(_isEmpty_4 = IterableExtensions.isEmpty(pkg.dataClasses));
        if (_not_4) {
            _builder.newLine();
            _builder.append(".Data Classes");
            _builder.newLine();
            _builder.append("|===");
            _builder.newLine();
            _builder.append("| Name | Description");
            _builder.newLine();
            for (DataClass c_1 : pkg.dataClasses) {
                _builder.newLine();
                _builder.append("| ");
                CharSequence _crossReference_4 = AsciiDocGen.crossReference((RoomClass)c_1);
                _builder.append((Object)_crossReference_4);
                _builder.newLineIfNotEmpty();
                _builder.append("| ");
                CharSequence _shortDocText_4 = this.getShortDocText((EObject)c_1);
                _builder.append((Object)_shortDocText_4);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("|===");
            _builder.newLine();
        }
        boolean bl6 = _not_5 = !(_isEmpty_5 = IterableExtensions.isEmpty(pkg.actorClasses));
        if (_not_5) {
            _builder.newLine();
            _builder.append(".Actor Classes");
            _builder.newLine();
            _builder.append("|===");
            _builder.newLine();
            _builder.append("| Name | Description");
            _builder.newLine();
            for (ActorClass c_2 : pkg.actorClasses) {
                _builder.newLine();
                _builder.append("| ");
                CharSequence _crossReference_5 = AsciiDocGen.crossReference((RoomClass)c_2);
                _builder.append((Object)_crossReference_5);
                _builder.newLineIfNotEmpty();
                _builder.append("| ");
                CharSequence _shortDocText_5 = this.getShortDocText((EObject)c_2);
                _builder.append((Object)_shortDocText_5);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("|===");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence generateLogicalSystemDoc(LogicalSystem system, boolean includeImages) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _defineAnchor = AsciiDocGen.defineAnchor((RoomClass)system);
        _builder.append((Object)_defineAnchor);
        _builder.newLineIfNotEmpty();
        _builder.append("=== ");
        String _name = system.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        CharSequence _tagStart = AsciiDocGen.tagStart((RoomClass)system);
        _builder.append((Object)_tagStart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _docText = this.getDocText((EObject)system);
        _builder.append(_docText);
        _builder.newLineIfNotEmpty();
        if (includeImages) {
            _builder.newLine();
            String _name_1 = system.getName();
            String _plus = _name_1 + "_instanceTree.jpg";
            CharSequence _includeImage = this.includeImage(_plus);
            _builder.append((Object)_includeImage);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _tagEnd = AsciiDocGen.tagEnd((RoomClass)system);
        _builder.append((Object)_tagEnd);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateSubSystemDoc(SubSystemClass ssc, boolean includeImages) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _defineAnchor = AsciiDocGen.defineAnchor((RoomClass)ssc);
        _builder.append((Object)_defineAnchor);
        _builder.newLineIfNotEmpty();
        _builder.append("=== ");
        String _name = ssc.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        CharSequence _tagStart = AsciiDocGen.tagStart((RoomClass)ssc);
        _builder.append((Object)_tagStart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _docText = this.getDocText((EObject)ssc);
        _builder.append(_docText);
        _builder.newLineIfNotEmpty();
        if (includeImages) {
            _builder.newLine();
            String _name_1 = ssc.getName();
            String _plus = _name_1 + "_structure.jpg";
            CharSequence _includeImage = this.includeImage(_plus);
            _builder.append((Object)_includeImage);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _tagEnd = AsciiDocGen.tagEnd((RoomClass)ssc);
        _builder.append((Object)_tagEnd);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateEnumerationDoc(EnumerationType en) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _defineAnchor = AsciiDocGen.defineAnchor((RoomClass)en);
        _builder.append((Object)_defineAnchor);
        _builder.newLineIfNotEmpty();
        _builder.append("=== ");
        String _name = en.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        CharSequence _tagStart = AsciiDocGen.tagStart((RoomClass)en);
        _builder.append((Object)_tagStart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _docText = this.getDocText((EObject)en);
        _builder.append(_docText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        PrimitiveType _primitiveType = en.getPrimitiveType();
        boolean bl = _tripleNotEquals = _primitiveType != null;
        if (_tripleNotEquals) {
            _builder.append("The literals of this enumeration are based on PrimitiveType ");
            String _name_1 = en.getPrimitiveType().getName();
            _builder.append(_name_1);
            _builder.append(".");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("The literals of this enumeration are of type int.");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append(".Literals");
        _builder.newLine();
        _builder.append("|===");
        _builder.newLine();
        _builder.append("| Name | Value | Hex Value | Binary Value");
        _builder.newLine();
        EList _literals = en.getLiterals();
        for (EnumLiteral lit : _literals) {
            _builder.newLine();
            _builder.append("| ");
            String _name_2 = lit.getName();
            _builder.append(_name_2);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            long _literalValue = lit.getLiteralValue();
            _builder.append((Object)_literalValue);
            _builder.newLineIfNotEmpty();
            _builder.append("| 0x");
            String _hexString = Long.toHexString(lit.getLiteralValue());
            _builder.append(_hexString);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            String _binaryString = Long.toBinaryString(lit.getLiteralValue());
            _builder.append(_binaryString);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("|===");
        _builder.newLine();
        CharSequence _tagEnd = AsciiDocGen.tagEnd((RoomClass)en);
        _builder.append((Object)_tagEnd);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateDataDoc(DataClass dc) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _defineAnchor = AsciiDocGen.defineAnchor((RoomClass)dc);
        _builder.append((Object)_defineAnchor);
        _builder.newLineIfNotEmpty();
        _builder.append("=== ");
        String _name = dc.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        CharSequence _tagStart = AsciiDocGen.tagStart((RoomClass)dc);
        _builder.append((Object)_tagStart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _docText = this.getDocText((EObject)dc);
        _builder.append(_docText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateAttributesDoc = this.generateAttributesDoc((List<Attribute>)dc.getAttributes());
        _builder.append((Object)_generateAttributesDoc);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = dc.getOperations().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.newLine();
            CharSequence _generateOperationsDoc = this.generateOperationsDoc((List<? extends Operation>)dc.getOperations());
            _builder.append((Object)_generateOperationsDoc);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _tagEnd = AsciiDocGen.tagEnd((RoomClass)dc);
        _builder.append((Object)_tagEnd);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _generateProtocolDoc(ProtocolClass pc) {
        boolean _not_3;
        boolean _not_2;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _defineAnchor = AsciiDocGen.defineAnchor((RoomClass)pc);
        _builder.append((Object)_defineAnchor);
        _builder.newLineIfNotEmpty();
        _builder.append("=== ");
        String _name = pc.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        CharSequence _tagStart = AsciiDocGen.tagStart((RoomClass)pc);
        _builder.append((Object)_tagStart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _docText = this.getDocText((EObject)pc);
        _builder.append(_docText);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = this._roomHelpers.getAllIncomingMessages(pc).isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.newLine();
            _builder.append(".Incoming Messages");
            _builder.newLine();
            _builder.append("|===");
            _builder.newLine();
            _builder.append("| Message | Type | Description");
            _builder.newLine();
            List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message ims : _allIncomingMessages) {
                boolean _tripleNotEquals;
                _builder.newLine();
                _builder.append("| ");
                String _name_1 = ims.getName();
                _builder.append(_name_1);
                _builder.newLineIfNotEmpty();
                _builder.append("| ");
                MessageData _data = ims.getData();
                boolean bl2 = _tripleNotEquals = _data != null;
                if (_tripleNotEquals) {
                    String _name_2 = ims.getData().getRefType().getType().getName();
                    _builder.append(_name_2);
                } else {
                    _builder.append("void");
                }
                _builder.newLineIfNotEmpty();
                _builder.append("a| ");
                String _docText_1 = this.getDocText((EObject)ims);
                _builder.append(_docText_1);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("|===");
            _builder.newLine();
            _builder.newLine();
        }
        boolean bl3 = _not_1 = !(_isEmpty_1 = this._roomHelpers.getAllOutgoingMessages(pc).isEmpty());
        if (_not_1) {
            _builder.newLine();
            _builder.append(".Outgoing Messages");
            _builder.newLine();
            _builder.append("|===");
            _builder.newLine();
            _builder.append("| Message | Type | Description");
            _builder.newLine();
            List _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message oms : _allOutgoingMessages) {
                boolean _tripleNotEquals_1;
                _builder.newLine();
                _builder.append("| ");
                String _name_3 = oms.getName();
                _builder.append(_name_3);
                _builder.newLineIfNotEmpty();
                _builder.append("| ");
                MessageData _data_1 = oms.getData();
                boolean bl4 = _tripleNotEquals_1 = _data_1 != null;
                if (_tripleNotEquals_1) {
                    String _name_4 = oms.getData().getRefType().getType().getName();
                    _builder.append(_name_4);
                } else {
                    _builder.append("void");
                }
                _builder.newLineIfNotEmpty();
                _builder.append("a| ");
                String _docText_2 = this.getDocText((EObject)oms);
                _builder.append(_docText_2);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("|===");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isEmpty_2 = this._roomHelpers.getAllOperations(pc, true).isEmpty();
        boolean bl5 = _not_2 = !_isEmpty_2;
        if (_not_2) {
            _builder.append("[discrete]");
            _builder.newLine();
            _builder.append("==== Regular PortClass");
            _builder.newLine();
            CharSequence _generateOperationsDoc = this.generateOperationsDoc(this._roomHelpers.getAllOperations(pc, true));
            _builder.append((Object)_generateOperationsDoc);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _isEmpty_3 = this._roomHelpers.getAllOperations(pc, false).isEmpty();
        boolean bl6 = _not_3 = !_isEmpty_3;
        if (_not_3) {
            _builder.append("[discrete]");
            _builder.newLine();
            _builder.append("==== Conjugated PortClass");
            _builder.newLine();
            CharSequence _generateOperationsDoc_1 = this.generateOperationsDoc(this._roomHelpers.getAllOperations(pc, false));
            _builder.append((Object)_generateOperationsDoc_1);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _tagEnd = AsciiDocGen.tagEnd((RoomClass)pc);
        _builder.append((Object)_tagEnd);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _generateProtocolDoc(CompoundProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _defineAnchor = AsciiDocGen.defineAnchor((RoomClass)pc);
        _builder.append((Object)_defineAnchor);
        _builder.newLineIfNotEmpty();
        _builder.append("=== ");
        String _name = pc.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        CharSequence _tagStart = AsciiDocGen.tagStart((RoomClass)pc);
        _builder.append((Object)_tagStart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _docText = this.getDocText((EObject)pc);
        _builder.append(_docText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append(".Sub Protocols");
        _builder.newLine();
        _builder.append("|===");
        _builder.newLine();
        _builder.append("| Name | Protocol");
        _builder.newLine();
        EList _subProtocols = pc.getSubProtocols();
        for (SubProtocol sub : _subProtocols) {
            _builder.newLine();
            _builder.append("| ");
            String _name_1 = sub.getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            String _name_2 = sub.getProtocol().getName();
            _builder.append(_name_2);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("|===");
        _builder.newLine();
        CharSequence _tagEnd = AsciiDocGen.tagEnd((RoomClass)pc);
        _builder.append((Object)_tagEnd);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateActorDoc(ActorClass ac, boolean includeImages) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _defineAnchor = AsciiDocGen.defineAnchor((RoomClass)ac);
        _builder.append((Object)_defineAnchor);
        _builder.newLineIfNotEmpty();
        _builder.append("=== ");
        String _name = ac.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        CharSequence _tagStart = AsciiDocGen.tagStart((RoomClass)ac);
        _builder.append((Object)_tagStart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _docText = this.getDocText((EObject)ac);
        _builder.append(_docText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("[discrete]");
        _builder.newLine();
        boolean _isGenerateAsLibrary = this._abstractGeneratorOptionsHelper.isGenerateAsLibrary(Main.getSettings());
        if (_isGenerateAsLibrary) {
            boolean _not;
            _builder.append("==== Interface");
            _builder.newLine();
            boolean _isEmpty = this._roomHelpers.getAllInterfacePorts((ActorContainerClass)ac).isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.newLine();
                String _generatePortInterfaceDoc = this.generatePortInterfaceDoc(ac);
                _builder.append(_generatePortInterfaceDoc);
                _builder.newLineIfNotEmpty();
            }
        } else {
            boolean _isEmpty_2;
            boolean _not_2;
            boolean _isEmpty_1;
            boolean _not_1;
            _builder.append("==== Structure");
            _builder.newLine();
            if (includeImages) {
                _builder.newLine();
                String _name_1 = ac.getName();
                String _plus = _name_1 + "_structure.jpg";
                CharSequence _includeImage = this.includeImage(_plus);
                _builder.append((Object)_includeImage);
                _builder.newLineIfNotEmpty();
            }
            boolean bl = _not_1 = !(_isEmpty_1 = this._roomHelpers.getAllPorts(ac).isEmpty());
            if (_not_1) {
                _builder.newLine();
                String _generatePortDoc = this.generatePortDoc(ac);
                _builder.append(_generatePortDoc);
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _not_2 = !(_isEmpty_2 = ac.getAttributes().isEmpty());
            if (_not_2) {
                _builder.newLine();
                CharSequence _generateAttributesDoc = this.generateAttributesDoc((List<Attribute>)ac.getAttributes());
                _builder.append((Object)_generateAttributesDoc);
                _builder.newLineIfNotEmpty();
            }
            if (this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac) || !ac.getOperations().isEmpty() || this._roomHelpers.isBehaviorAnnotationPresent(ac, "BehaviorManual")) {
                boolean _isBehaviorAnnotationPresent;
                boolean _not_3;
                _builder.newLine();
                _builder.append("[discrete]");
                _builder.newLine();
                _builder.append("==== Behavior");
                _builder.newLine();
                boolean _isEmpty_3 = ac.getOperations().isEmpty();
                boolean bl3 = _not_3 = !_isEmpty_3;
                if (_not_3) {
                    _builder.newLine();
                    CharSequence _generateOperationsDoc = this.generateOperationsDoc((List<? extends Operation>)ac.getOperations());
                    _builder.append((Object)_generateOperationsDoc);
                    _builder.newLineIfNotEmpty();
                }
                if (_isBehaviorAnnotationPresent = this._roomHelpers.isBehaviorAnnotationPresent(ac, "BehaviorManual")) {
                    _builder.newLine();
                    _builder.append("The behavior for ActorClass ");
                    String _name_2 = ac.getName();
                    _builder.append(_name_2);
                    _builder.append(" is implemented manually.");
                    _builder.newLineIfNotEmpty();
                } else {
                    boolean _hasNonEmptyStateMachine = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
                    if (_hasNonEmptyStateMachine) {
                        _builder.newLine();
                        CharSequence _generateFsmDoc = this.generateFsmDoc(ac, includeImages);
                        _builder.append((Object)_generateFsmDoc);
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
        }
        CharSequence _tagEnd = AsciiDocGen.tagEnd((RoomClass)ac);
        _builder.append((Object)_tagEnd);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateFsmDoc(ActorClass ac, boolean includeImages) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".State Machine");
        _builder.newLine();
        _builder.append("Top Level State::");
        _builder.newLine();
        CharSequence _generateStateGraphDoc = this.generateStateGraphDoc(ac, ac.getStateMachine(), includeImages, 1);
        _builder.append((Object)_generateStateGraphDoc);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateStateGraphDoc(ActorClass ac, StateGraph stateGraph, boolean includeImages, int depth) {
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        EObject _eContainer = stateGraph.eContainer();
        if (_eContainer instanceof State) {
            EObject _eContainer_1 = stateGraph.eContainer();
            String _genStatePathName = this._codegenHelpers.getGenStatePathName((State)_eContainer_1);
            _xifexpression = "_" + _genStatePathName;
        } else {
            _xifexpression = "";
        }
        String statePath = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        if (includeImages) {
            String _name = ac.getName();
            String _plus = _name + statePath;
            String _plus_1 = _plus + "_behavior.jpg";
            CharSequence _includeImage = this.includeImage(_plus_1);
            _builder.append((Object)_includeImage);
            _builder.newLineIfNotEmpty();
        }
        EList _states = stateGraph.getStates();
        for (State state : _states) {
            String _name_1 = state.getName();
            _builder.append(_name_1);
            _builder.append("::");
            String _fill = AsciiDocGen.fill(':', depth);
            _builder.append(_fill);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _docText = this.getDocText((EObject)state);
            _builder.append(_docText, "\t");
            _builder.newLineIfNotEmpty();
            boolean _isLeaf = this._roomHelpers.isLeaf(state);
            boolean _not = !_isLeaf;
            if (!_not) continue;
            _builder.append("\t");
            CharSequence _generateStateGraphDoc = this.generateStateGraphDoc(ac, state.getSubgraph(), includeImages, depth + 1);
            _builder.append((Object)_generateStateGraphDoc, "\t");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String generatePortInterfaceDoc(ActorClass ac) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".Ports");
        _builder.newLine();
        _builder.append("|===");
        _builder.newLine();
        _builder.append("| Name | Protocol | Type | Multiplicity | Description");
        _builder.newLine();
        List _allInterfacePorts = this._roomHelpers.getAllInterfacePorts((ActorContainerClass)ac);
        for (Port at : _allInterfacePorts) {
            _builder.newLine();
            _builder.append("| ");
            String _name = at.getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            String _name_1 = at.getProtocol().getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            String _type = this.getType(at);
            _builder.append(_type);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            String _multAsText = this.getMultAsText(at);
            _builder.append(_multAsText);
            _builder.newLineIfNotEmpty();
            _builder.append("a| ");
            String _docText = this.getDocText((EObject)at);
            _builder.append(_docText);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("|===");
        _builder.newLine();
        return _builder.toString();
    }

    private String generatePortDoc(ActorClass ac) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".Ports");
        _builder.newLine();
        _builder.append("|===");
        _builder.newLine();
        _builder.append("| Name | Protocol | Type | Kind | Multiplicity | Description");
        _builder.newLine();
        List _allPorts = this._roomHelpers.getAllPorts(ac);
        for (Port at : _allPorts) {
            _builder.newLine();
            _builder.append("| ");
            String _name = at.getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            String _name_1 = at.getProtocol().getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            String _type = this.getType(at);
            _builder.append(_type);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            String _kind = this.getKind(at);
            _builder.append(_kind);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            String _multAsText = this.getMultAsText(at);
            _builder.append(_multAsText);
            _builder.newLineIfNotEmpty();
            _builder.append("a| ");
            String _docText = this.getDocText((EObject)at);
            _builder.append(_docText);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("|===");
        _builder.newLine();
        return _builder.toString();
    }

    private CharSequence generateAttributesDoc(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".Attributes");
        _builder.newLine();
        _builder.append("|===");
        _builder.newLine();
        _builder.append("| Name | Type | Description");
        _builder.newLine();
        for (Attribute at : attributes) {
            _builder.newLine();
            _builder.append("| ");
            String _name = at.getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            String _name_1 = at.getType().getType().getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
            _builder.append("a| ");
            String _docText = this.getDocText((EObject)at);
            _builder.append(_docText);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("|===");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateOperationsDoc(List<? extends Operation> operations) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".Operations");
        _builder.newLine();
        _builder.append("|===");
        _builder.newLine();
        _builder.append("| Name | Return type | Arguments | Description");
        _builder.newLine();
        boolean _hasElements = false;
        for (Operation operation : operations) {
            boolean _tripleNotEquals;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            _builder.newLine();
            _builder.append("|");
            String _name = operation.getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            RefableType _returnType = operation.getReturnType();
            boolean bl = _tripleNotEquals = _returnType != null;
            if (_tripleNotEquals) {
                String _name_1 = operation.getReturnType().getType().getName();
                _builder.append(_name_1);
            } else {
                _builder.append("void");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("| ");
            EList _arguments = operation.getArguments();
            boolean _hasElements_1 = false;
            for (VarDecl pa : _arguments) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _name_2 = pa.getName();
                _builder.append(_name_2);
                _builder.append(": ");
                String _name_3 = pa.getRefType().getType().getName();
                _builder.append(_name_3);
            }
            _builder.newLineIfNotEmpty();
            _builder.append("a| ");
            String _docText = this.getDocText((EObject)operation);
            _builder.append(_docText);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("|===");
        _builder.newLine();
        return _builder;
    }

    private String getType(Port p) {
        String _xifexpression = null;
        boolean _isConjugated = p.isConjugated();
        _xifexpression = _isConjugated ? "conjugated" : "regular";
        return _xifexpression;
    }

    private String getKind(Port p) {
        String _xifexpression = null;
        boolean _isInternal = this._roomHelpers.isInternal(p);
        if (_isInternal) {
            _xifexpression = "internal";
        } else {
            String _xifexpression_1 = null;
            boolean _isExternal = this._roomHelpers.isExternal(p);
            if (_isExternal) {
                _xifexpression_1 = "external";
            } else {
                String _xifexpression_2 = null;
                boolean _isRelay = this._roomHelpers.isRelay(p);
                _xifexpression_2 = _isRelay ? "relay" : "?";
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private String getMultAsText(Port p) {
        String _xifexpression = null;
        int _multiplicity = p.getMultiplicity();
        boolean _equals = _multiplicity == -1;
        _xifexpression = _equals ? "*" : Integer.valueOf(p.getMultiplicity()).toString();
        return _xifexpression;
    }

    private String getDocText(EObject object) {
        Object _eGet;
        Documentation docu;
        String _xblockexpression = null;
        EClass eClass = object.eClass();
        EStructuralFeature feature = eClass.getEStructuralFeature("docu");
        if (feature != null && (docu = (Documentation)(_eGet = object.eGet(feature))) != null) {
            return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)docu.getLines());
        }
        String docu_1 = this.documentation(object);
        String _xifexpression = null;
        _xifexpression = docu_1 != null ? docu_1 : "";
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private CharSequence getShortDocText(EObject object) {
        String _xblockexpression = null;
        String docText = this.getDocText(object);
        int index = docText.indexOf("\n");
        CharSequence _xifexpression = null;
        _xifexpression = index != -1 ? docText.subSequence(0, index) : docText;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private CharSequence includeImage(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("image:");
        _builder.append(filename);
        _builder.append("[]");
        return _builder;
    }

    private static CharSequence crossReference(RoomClass rc) {
        return AsciiDocGen.crossReference(AsciiDocGen.getFQN(rc));
    }

    private static CharSequence crossReference(CharSequence anchor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<<");
        _builder.append((Object)anchor);
        _builder.append(">>");
        return _builder;
    }

    private static CharSequence defineAnchor(RoomClass rc) {
        return AsciiDocGen.defineAnchor(AsciiDocGen.getFQN(rc));
    }

    private static CharSequence defineAnchor(CharSequence anchor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[[");
        _builder.append((Object)anchor);
        _builder.append("]]");
        return _builder;
    }

    private static CharSequence getFQN(RoomClass rc) {
        StringConcatenation _builder = new StringConcatenation();
        EObject _eContainer = rc.eContainer();
        String _name = ((RoomModel)_eContainer).getName();
        _builder.append(_name);
        _builder.append(".");
        String _name_1 = rc.getName();
        _builder.append(_name_1);
        return _builder;
    }

    private static CharSequence tagStart(RoomClass rc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("tag::");
        CharSequence _fQN = AsciiDocGen.getFQN(rc);
        _builder.append((Object)_fQN);
        _builder.append("[]");
        return _builder;
    }

    private static CharSequence tagEnd(RoomClass rc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("end::");
        CharSequence _fQN = AsciiDocGen.getFQN(rc);
        _builder.append((Object)_fQN);
        _builder.append("[]");
        return _builder;
    }

    private static String fill(char c, int length) {
        String _xblockexpression = null;
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(c);
        }
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }

    private String documentation(EObject obj) {
        String _markupType;
        String _xblockexpression = null;
        String raw = this.eObjDocuProvider.getDocumentation(obj);
        if (raw == null) {
            return null;
        }
        String _switchResult = null;
        String type = _markupType = DocumentationMarkup.getMarkupType((String)raw);
        boolean _matched = false;
        if (Objects.equal((Object)type, (Object)"html") && raw.contains("<")) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("++++");
            _builder.newLine();
            _builder.append("<div class=\"paragraph\"><p>");
            String _trimMarkupTag = DocumentationMarkup.trimMarkupTag((String)raw);
            _builder.append(_trimMarkupTag);
            _builder.append("</p></div>");
            _builder.newLineIfNotEmpty();
            _builder.append("++++");
            _builder.newLine();
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            _switchResult = DocumentationMarkup.trimMarkupTag((String)raw);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private CharSequence generateProtocolDoc(GeneralProtocolClass pc) {
        if (pc instanceof CompoundProtocolClass) {
            return this._generateProtocolDoc((CompoundProtocolClass)pc);
        }
        if (pc instanceof ProtocolClass) {
            return this._generateProtocolDoc((ProtocolClass)pc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pc).toString());
    }

    private static class RoomPackage {
        public final String name;
        public final Iterable<LogicalSystem> systems;
        public final Iterable<SubSystemClass> subSystemClasses;
        public final Iterable<GeneralProtocolClass> protocolClasses;
        public final Iterable<EnumerationType> enumerationTypes;
        public final Iterable<DataClass> dataClasses;
        public final Iterable<ActorClass> actorClasses;

        private RoomPackage(String name, Iterable<RoomModel> models) {
            this.name = name;
            Functions.Function1 _function = it -> it.getSystems();
            Functions.Function1 _function_1 = it -> name;
            this.systems = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)IterableExtensions.map(models, (Functions.Function1)_function)), (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = it -> it.getSubSystemClasses();
            Functions.Function1 _function_3 = it -> name;
            this.subSystemClasses = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)IterableExtensions.map(models, (Functions.Function1)_function_2)), (Functions.Function1)_function_3);
            Functions.Function1 _function_4 = it -> it.getProtocolClasses();
            Functions.Function1 _function_5 = it -> name;
            this.protocolClasses = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)IterableExtensions.map(models, (Functions.Function1)_function_4)), (Functions.Function1)_function_5);
            Functions.Function1 _function_6 = it -> it.getEnumerationTypes();
            Functions.Function1 _function_7 = it -> name;
            this.enumerationTypes = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)IterableExtensions.map(models, (Functions.Function1)_function_6)), (Functions.Function1)_function_7);
            Functions.Function1 _function_8 = it -> it.getDataClasses();
            Functions.Function1 _function_9 = it -> name;
            this.dataClasses = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)IterableExtensions.map(models, (Functions.Function1)_function_8)), (Functions.Function1)_function_9);
            Functions.Function1 _function_10 = it -> it.getActorClasses();
            Functions.Function1 _function_11 = it -> name;
            this.actorClasses = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)IterableExtensions.map(models, (Functions.Function1)_function_10)), (Functions.Function1)_function_11);
        }
    }
}

