/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInterfaceInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class InstanceDiagramGen {
    @Inject
    @Extension
    private RoomExtensions roomExt;

    public void doGenerate(Root root, IGeneratorFileIO fileIO) {
        String path = "images/";
        EList _systemInstances = root.getSystemInstances();
        for (SystemInstance sys : _systemInstances) {
            String _name = sys.getName();
            String file = _name + "_instanceTree.dot";
            fileIO.generateFile("generating instance tree diagram", path + file, this.generate(root, sys));
        }
    }

    private CharSequence generate(Root root, SystemInstance sys) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("digraph ");
        String _name = sys.getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("rankdir=LR;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("node [shape=box];");
        _builder.newLine();
        _builder.append("\t");
        String _pathName = this.roomExt.getPathName(sys.getPath());
        _builder.append(_pathName, "\t");
        _builder.append(" [label=\"");
        String _name_1 = sys.getName();
        _builder.append(_name_1, "\t");
        _builder.append("\\n(");
        String _name_2 = sys.getName();
        _builder.append(_name_2, "\t");
        _builder.append(")\" style=filled color=red];");
        _builder.newLineIfNotEmpty();
        EList _instances = sys.getInstances();
        for (SubSystemInstance ssi : _instances) {
            _builder.append("\t");
            String _pathName_1 = this.roomExt.getPathName(ssi.getPath());
            _builder.append(_pathName_1, "\t");
            _builder.append(" [label=\"");
            String _name_3 = ssi.getName();
            _builder.append(_name_3, "\t");
            _builder.append("\\n(");
            String _name_4 = ssi.getSubSystemClass().getName();
            _builder.append(_name_4, "\t");
            _builder.append(")\" style=filled color=yellow];");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _pathName_2 = this.roomExt.getPathName(sys.getPath());
            _builder.append(_pathName_2, "\t");
            _builder.append(" -> ");
            String _pathName_3 = this.roomExt.getPathName(ssi.getPath());
            _builder.append(_pathName_3, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            EList _instances_1 = ssi.getInstances();
            for (AbstractInstance ai : _instances_1) {
                _builder.append("\t");
                String _instance = this.instance(ai);
                _builder.append(_instance, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private String instance(AbstractInstance ai) {
        boolean _not;
        String _xblockexpression = null;
        EObject _eContainer = ai.eContainer();
        StructureInstance parent = (StructureInstance)_eContainer;
        ETMapUtil.MappedThread pthread = ETMapUtil.getMappedThread((AbstractInstance)ai);
        String _xifexpression = null;
        _xifexpression = pthread == null ? "?" : pthread.getThread().getName();
        String tname = _xifexpression;
        NodeRef node = ETMapUtil.getNodeRef((AbstractInstance)ai);
        String _xifexpression_1 = null;
        _xifexpression_1 = node == null ? "?" : node.getName();
        String nname = _xifexpression_1;
        String _xifexpression_2 = null;
        _xifexpression_2 = ai instanceof ActorInterfaceInstance ? "optional " : "";
        String optional = _xifexpression_2;
        String _xifexpression_3 = null;
        if (ai instanceof ActorInstance) {
            _xifexpression_3 = ((ActorInstance)ai).getActorClass().getName();
        } else {
            String _xifexpression_4 = null;
            _xifexpression_4 = ai instanceof ActorInterfaceInstance ? ((ActorInterfaceInstance)ai).getActorClass().getName() : "?";
            _xifexpression_3 = _xifexpression_4;
        }
        String clsname = _xifexpression_3;
        StringConcatenation _builder = new StringConcatenation();
        String _pathName = this.roomExt.getPathName(ai.getPath());
        _builder.append(_pathName);
        _builder.append(" [label=\"");
        _builder.append(optional);
        String _name = ai.getName();
        _builder.append(_name);
        _builder.append("\\n(");
        _builder.append(clsname);
        _builder.append(")\\n@");
        _builder.append(nname);
        _builder.append(":");
        _builder.append(tname);
        _builder.append("\"");
        boolean _isEmpty = optional.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append(" color=blue style=dashed");
        }
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        String _pathName_1 = this.roomExt.getPathName(parent.getPath());
        _builder.append(_pathName_1);
        _builder.append(" -> ");
        String _pathName_2 = this.roomExt.getPathName(ai.getPath());
        _builder.append(_pathName_2);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        if (ai instanceof StructureInstance) {
            EList _instances = ((StructureInstance)ai).getInstances();
            for (AbstractInstance sub_ai : _instances) {
                String _instance = this.instance(sub_ai);
                _builder.append(_instance);
                _builder.newLineIfNotEmpty();
            }
        }
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }
}

