/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.etmap.validation;

import com.google.inject.Inject;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.etmap.eTMap.ETMapPackage;
import org.eclipse.etrice.core.etmap.eTMap.Mapping;
import org.eclipse.etrice.core.etmap.eTMap.SubSystemMapping;
import org.eclipse.etrice.core.etmap.eTMap.ThreadMapping;
import org.eclipse.etrice.core.etmap.validation.AbstractETMapJavaValidator;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalModel;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.room.LogicalThread;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.validation.Check;

public class ETMapJavaValidator
extends AbstractETMapJavaValidator {
    public static final String DUPLICATE_SUBSYS_MAPPING = "ETMapJavaValidator.DulicateSubSysMapping";
    public static final String UNMAPPED_SUBSYS_REFS = "ETMapJavaValidator.UnmappedSubSysRefs";
    public static final String DUPLICATE_THREAD_MAPPING = "ETMapJavaValidator.DulicateThreadMapping";
    public static final String UNMAPPED_THREAD_REFS = "ETMapJavaValidator.UnmappedThreadRefs";
    public static final String WRONG_NAMESPACE = "ETMapJavaValidator.WrongNamespace";
    public static final String NOT_EMPTY = "empty";
    public static final String EMPTY = "not-empty";
    @Inject
    ImportUriResolver importUriResolver;

    @Check
    public void checkMapping(Mapping mp) {
        HashSet<SubSystemRef> mapped = new HashSet<SubSystemRef>();
        for (SubSystemMapping ssm : mp.getSubsysMappings()) {
            if (mapped.add(ssm.getLogicalSubSys())) continue;
            int idx = mp.getSubsysMappings().indexOf((Object)ssm);
            this.error("duplicate mapping", (EStructuralFeature)ETMapPackage.Literals.MAPPING__SUBSYS_MAPPINGS, idx, DUPLICATE_SUBSYS_MAPPING, new String[0]);
        }
        StringBuilder msg = new StringBuilder();
        StringBuilder fix = new StringBuilder();
        for (SubSystemRef ssr : mp.getLogicalSys().getSubSystems()) {
            if (mapped.contains(ssr)) continue;
            msg.append("unmapped sub system reference '" + ssr.getName() + "'\n");
            String nodeRef = mp.getPhysicalSys().getNodeRefs().isEmpty() ? "no_node_ref_defined" : ((NodeRef)mp.getPhysicalSys().getNodeRefs().get(0)).getName();
            fix.append("\t\tSubSystemMapping " + ssr.getName() + " -> " + nodeRef + " {}\n");
        }
        if (msg.length() > 0) {
            this.error(msg.substring(0, msg.length() - 2), (EStructuralFeature)ETMapPackage.Literals.MAPPING__SUBSYS_MAPPINGS, UNMAPPED_SUBSYS_REFS, new String[]{fix.toString(), mapped.isEmpty() ? EMPTY : NOT_EMPTY});
        }
    }

    @Check
    public void checkSubSystemMapping(SubSystemMapping ssm) {
        HashSet<LogicalThread> mapped = new HashSet<LogicalThread>();
        for (ThreadMapping tm : ssm.getThreadMappings()) {
            if (mapped.add(tm.getLogicalThread())) continue;
            int idx = ssm.getThreadMappings().indexOf((Object)tm);
            this.error("duplicate mapping", (EStructuralFeature)ETMapPackage.Literals.SUB_SYSTEM_MAPPING__THREAD_MAPPINGS, idx, DUPLICATE_THREAD_MAPPING, new String[0]);
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder fix = new StringBuilder();
        for (LogicalThread lt : ssm.getLogicalSubSys().getType().getThreads()) {
            if (mapped.contains(lt)) continue;
            sb.append("unmapped logical thread '" + lt.getName() + "'\n");
            String pthread = ssm.getNode().getType().getThreads().isEmpty() ? "no_physical_thread_defined" : ((PhysicalThread)ssm.getNode().getType().getThreads().get(0)).getName();
            fix.append("\t\t\tThreadMapping " + lt.getName() + " -> " + pthread + "\n");
        }
        if (sb.length() > 0) {
            this.error(sb.substring(0, sb.length() - 2), (EStructuralFeature)ETMapPackage.Literals.SUB_SYSTEM_MAPPING__THREAD_MAPPINGS, UNMAPPED_THREAD_REFS, new String[]{fix.toString(), mapped.isEmpty() ? EMPTY : NOT_EMPTY});
        }
    }

    @Check
    public void checkImportedNamespace(Import imp) {
        if (imp.getImportedNamespace() == null) {
            return;
        }
        if (imp.getImportURI() == null) {
            return;
        }
        String uriString = this.importUriResolver.resolve((EObject)imp);
        URI uri = URI.createURI((String)uriString);
        ResourceSetImpl rs = new ResourceSetImpl();
        try {
            Resource res = rs.getResource(uri, true);
            if (res == null) {
                return;
            }
            if (res.getContents().isEmpty()) {
                this.error("referenced model is empty", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
                return;
            }
            if (uri.lastSegment().endsWith(".room")) {
                if (!(res.getContents().get(0) instanceof RoomModel)) {
                    this.error("referenced model is no ROOM model (but has .room extension)", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
                    return;
                }
                RoomModel model = (RoomModel)res.getContents().get(0);
                if (!imp.getImportedNamespace().equals(model.getName() + ".*")) {
                    this.error("the imported namespace should be '" + model.getName() + ".*'", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORTED_NAMESPACE, WRONG_NAMESPACE, new String[]{model.getName() + ".*"});
                }
            } else if (uri.lastSegment().endsWith(".etphys")) {
                if (!(res.getContents().get(0) instanceof PhysicalModel)) {
                    this.error("referenced model is no eTrice physical model (but has .etphys extension)", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
                    return;
                }
                PhysicalModel model = (PhysicalModel)res.getContents().get(0);
                if (!imp.getImportedNamespace().equals(model.getName() + ".*")) {
                    this.error("the imported namespace should be '" + model.getName() + ".*'", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORTED_NAMESPACE, WRONG_NAMESPACE, new String[]{model.getName() + ".*"});
                }
            } else {
                this.error("referenced model has unexpected file extension", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
            }
        }
        catch (RuntimeException re) {
            this.warning("could not load referenced model", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
            return;
        }
    }
}

