/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.abstractexec.behavior.ReachabilityCheck;
import org.eclipse.etrice.core.common.validation.ICustomValidator;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.ExtendedFsmGenBuilder;
import org.eclipse.etrice.core.genmodel.fsm.ExtendedFsmGenBuilderFactory;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenChecker;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.NullDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphItem;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.base.logging.NullLogger;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class ReachabilityValidator
implements ICustomValidator {
    public static final String DIAG_CODE_UNREACHABLE = "etrice.unreachable";
    private static final Set<EClass> classesToCheck = new HashSet<EClass>();
    @Inject
    private FSMHelpers fsmHelpers;
    @Inject
    private ExtendedFsmGenBuilderFactory fsmGenBuilderFactory;

    public ReachabilityValidator() {
        classesToCheck.add(FSMPackage.Literals.MODEL_COMPONENT);
    }

    public void validate(EObject object, ValidationMessageAcceptor messageAcceptor, ICustomValidator.ValidationContext context) {
        GraphContainer gc;
        if (!(object instanceof ModelComponent)) {
            return;
        }
        if (context.isGeneration()) {
            return;
        }
        ModelComponent mc = (ModelComponent)object;
        if (mc.isAbstract()) {
            return;
        }
        if (this.fsmHelpers.isCircularClassHierarchy(mc)) {
            return;
        }
        NullDiagnostician diagnostician = new NullDiagnostician();
        ExtendedFsmGenBuilder builder = this.fsmGenBuilderFactory.create((IDiagnostician)diagnostician);
        try {
            gc = builder.createTransformedModel(mc);
            NullLogger logger = new NullLogger();
            FsmGenChecker.check((GraphContainer)gc, (ILogger)logger);
            if (logger.hasErrors()) {
                return;
            }
            builder.withTriggersInStates(gc);
        }
        catch (Throwable t) {
            return;
        }
        if (gc != null && gc.getGraph() != null && !diagnostician.isFailed()) {
            ReachabilityCheck checker = new ReachabilityCheck(gc);
            checker.computeReachability();
            TreeIterator it = gc.eAllContents();
            while (it.hasNext()) {
                GraphItem toCheck;
                EObject item = (EObject)it.next();
                if (!(item instanceof GraphItem) || checker.isReachable(toCheck = (GraphItem)item)) continue;
                String name = FsmGenExtensions.getName((GraphItem)toCheck);
                if (name == null) {
                    name = "<no name>";
                }
                StateGraphNode stateGraphItem = toCheck instanceof Node ? ((Node)toCheck).getStateGraphNode() : ((Link)toCheck).getTransition();
                EObject container = stateGraphItem.eContainer();
                int idx = ((List)container.eGet(stateGraphItem.eContainingFeature())).indexOf(stateGraphItem);
                messageAcceptor.acceptWarning("Unreachable state/point of graph", stateGraphItem.eContainer(), stateGraphItem.eContainingFeature(), idx, DIAG_CODE_UNREACHABLE, new String[]{name});
            }
        }
    }

    public String getName() {
        return "State Reachability Validator";
    }

    public String getDescription() {
        return "This validator checks the reachability of state graph items.";
    }

    public Set<EClass> getClassesToCheck() {
        return classesToCheck;
    }
}

