/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.args;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.etrice.generator.base.args.IOptionModule;
import org.eclipse.etrice.generator.base.args.Option;

public class Options
implements IOptionModule,
Iterable<Option<?>> {
    private final LinkedHashMap<String, Option<?>> name2Option;

    public Options(IOptionModule ... modules) {
        this(Arrays.asList(modules));
    }

    public Options(Iterable<IOptionModule> modules) {
        LinkedList options = new LinkedList();
        for (IOptionModule module : modules) {
            module.configure(options);
        }
        this.name2Option = new LinkedHashMap();
        options.forEach(opt -> this.name2Option.put(opt.getName(), (Option<?>)opt));
    }

    public final Option<?> get(String name) throws IllegalArgumentException {
        Option<?> opt = this.name2Option.get(name);
        if (opt == null) {
            throw new IllegalArgumentException("Option " + name + " not recognized");
        }
        return opt;
    }

    @Override
    public final Iterator<Option<?>> iterator() {
        return Collections.unmodifiableCollection(this.name2Option.values()).iterator();
    }

    @Override
    public final void configure(List<Option<?>> options) {
        for (Option<?> opt : this) {
            options.add(opt);
        }
    }

    public String toString() {
        return this.name2Option.values().toString();
    }
}

