/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.scoping;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.InSemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.OutSemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.SemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InMessageHandler;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.OutMessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RoomScopeProviderDelegate {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;

    public IScope getScope(EObject context, EReference reference) {
        IScope _xtrycatchfinallyexpression = null;
        try {
            IScope _scopeFor;
            _xtrycatchfinallyexpression = _scopeFor = this.scopeFor(context, reference);
        }
        catch (Throwable _t) {
            if (_t instanceof NullPointerException || _t instanceof IllegalArgumentException) {
                _xtrycatchfinallyexpression = null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    protected IScope _scopeFor(EObject obj, EReference ref) {
        return null;
    }

    protected IScope _scopeFor(Trigger trigger, EReference ref) {
        IScope _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)ref, (Object)FSMPackage.Literals.MESSAGE_FROM_IF__MESSAGE)) {
            _matched = true;
            _switchResult = this.scopeTriggerMessages(this._roomHelpers.getAllInterfaceItems(this._roomHelpers.getActorClass((EObject)trigger)));
        }
        if (!_matched) {
            _switchResult = this.emptyScope();
        }
        return _switchResult;
    }

    protected IScope _scopeFor(MessageFromIf mfi, EReference ref) {
        IScope _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)ref, (Object)FSMPackage.Literals.MESSAGE_FROM_IF__MESSAGE)) {
            _matched = true;
            IScope _xblockexpression = null;
            AbstractInterfaceItem _from = mfi.getFrom();
            InterfaceItem item = (InterfaceItem)_from;
            IScope _xifexpression = null;
            _xifexpression = item != null ? this.scopeTriggerMessages(Collections.singletonList(item)) : this.scopeTriggerMessages(this._roomHelpers.getAllInterfaceItems(this._roomHelpers.getActorClass((EObject)mfi)));
            _switchResult = _xblockexpression = _xifexpression;
        }
        if (!_matched && Objects.equal((Object)ref, (Object)FSMPackage.Literals.MESSAGE_FROM_IF__FROM)) {
            _matched = true;
            _switchResult = this.simpleScope(this._roomHelpers.getAllInterfaceItems(this._roomHelpers.getActorClass((EObject)mfi)));
        }
        if (!_matched) {
            _switchResult = this.emptyScope();
        }
        return _switchResult;
    }

    private IScope scopeTriggerMessages(List<InterfaceItem> ifitems) {
        Functions.Function1 _function = it -> {
            GeneralProtocolClass _generalProtocol;
            List<Message> _switchResult = null;
            boolean _matched = false;
            if (it instanceof Port && (_generalProtocol = ((Port)it).getGeneralProtocol()) instanceof ProtocolClass) {
                _matched = true;
                GeneralProtocolClass _generalProtocol_1 = ((Port)it).getGeneralProtocol();
                boolean _isConjugated = ((Port)it).isConjugated();
                boolean _not = !_isConjugated;
                _switchResult = this._roomHelpers.getAllMessages((ProtocolClass)_generalProtocol_1, _not);
            }
            if (!_matched && it instanceof SAP) {
                _matched = true;
                _switchResult = this._roomHelpers.getAllMessages(((SAP)it).getProtocol(), false);
            }
            if (!_matched && it instanceof SPP) {
                _matched = true;
                _switchResult = this._roomHelpers.getAllMessages(((SPP)it).getProtocol(), true);
            }
            if (!_matched) {
                _switchResult = CollectionLiterals.emptyList();
            }
            return _switchResult;
        };
        return this.simpleScope(IterableExtensions.flatMap(ifitems, (Functions.Function1)_function));
    }

    protected IScope _scopeFor(Binding binding, EReference ref) {
        IScope _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)ref, (Object)RoomPackage.Literals.BINDING_END_POINT__ACTOR_REF)) {
            _matched = true;
            _switchResult = this.scopeBindingActorRef(this._roomHelpers.getStructureClass(binding));
        }
        if (!_matched && Objects.equal((Object)ref, (Object)RoomPackage.Literals.BINDING_END_POINT__PORT)) {
            _matched = true;
            _switchResult = this.scopeBindingPort(this._roomHelpers.getStructureClass(binding), null);
        }
        if (!_matched) {
            _switchResult = this.emptyScope();
        }
        return _switchResult;
    }

    protected IScope _scopeFor(BindingEndPoint ep, EReference ref) {
        IScope _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)ref, (Object)RoomPackage.Literals.BINDING_END_POINT__ACTOR_REF)) {
            _matched = true;
            _switchResult = this.scopeBindingActorRef(this._roomHelpers.getStructureClass(ep));
        }
        if (!_matched && Objects.equal((Object)ref, (Object)RoomPackage.Literals.BINDING_END_POINT__PORT)) {
            _matched = true;
            _switchResult = this.scopeBindingPort(this._roomHelpers.getStructureClass(ep), ep.getActorRef());
        }
        if (!_matched && Objects.equal((Object)ref, (Object)RoomPackage.Literals.BINDING_END_POINT__SUB)) {
            _matched = true;
            _switchResult = this.scopeBindingSub(ep.getPort());
        }
        if (!_matched) {
            _switchResult = this.emptyScope();
        }
        return _switchResult;
    }

    private IScope scopeBindingActorRef(StructureClass sc) {
        boolean _matched = false;
        if (sc instanceof ActorClass) {
            _matched = true;
            Functions.Function1 _function = it -> it.getActorRefs();
            return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy((ActorClass)sc), (Functions.Function1)_function));
        }
        if (!_matched && sc instanceof SubSystemClass) {
            _matched = true;
            return this.simpleScope((Iterable<? extends EObject>)((SubSystemClass)sc).getActorRefs());
        }
        if (!_matched && sc instanceof LogicalSystem) {
            _matched = true;
            return this.simpleScope((Iterable<? extends EObject>)((LogicalSystem)sc).getSubSystems());
        }
        return null;
    }

    private IScope scopeBindingPort(StructureClass sc, ActorContainerRef actorRef) {
        if (actorRef == null) {
            if (sc instanceof ActorClass) {
                Functions.Function1 _function = it -> {
                    EList<Port> _internalPorts = it.getInternalPorts();
                    EList<Port> _relayPorts = it.getRelayPorts();
                    return Iterables.concat(_internalPorts, _relayPorts);
                };
                return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy((ActorClass)sc), (Functions.Function1)_function));
            }
            if (sc instanceof SubSystemClass) {
                return this.simpleScope((Iterable<? extends EObject>)((SubSystemClass)sc).getRelayPorts());
            }
        } else {
            ActorContainerRef epref = actorRef;
            boolean _matched = false;
            if (epref instanceof ActorRef) {
                _matched = true;
                Functions.Function1 _function_1 = it -> it.getInterfacePorts();
                return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy(((ActorRef)epref).getType()), (Functions.Function1)_function_1));
            }
            if (!_matched && epref instanceof SubSystemRef) {
                _matched = true;
                return this.simpleScope((Iterable<? extends EObject>)((SubSystemRef)epref).getType().getRelayPorts());
            }
        }
        return null;
    }

    private IScope scopeBindingSub(Port port) {
        GeneralProtocolClass _protocol;
        if (port != null && (_protocol = port.getProtocol()) instanceof CompoundProtocolClass) {
            GeneralProtocolClass _protocol_1 = port.getProtocol();
            CompoundProtocolClass pc = (CompoundProtocolClass)_protocol_1;
            return this.simpleScope((Iterable<? extends EObject>)pc.getSubProtocols());
        }
        return null;
    }

    protected IScope _scopeFor(SemanticsRule sr, EReference ref) {
        ProtocolClass pc = this._roomHelpers.getProtocolClass((EObject)sr);
        if (sr instanceof InSemanticsRule) {
            Functions.Function1 _function = it -> it.getIncomingMessages();
            return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy(pc), (Functions.Function1)_function));
        }
        if (sr instanceof OutSemanticsRule) {
            Functions.Function1 _function_1 = it -> it.getOutgoingMessages();
            return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy(pc), (Functions.Function1)_function_1));
        }
        return this.emptyScope();
    }

    protected IScope _scopeFor(RefSAPoint pt, EReference ref) {
        ActorContainerClass acc = this._roomHelpers.getActorContainerClass(pt);
        if (acc instanceof ActorClass) {
            Functions.Function1 _function = it -> it.getActorRefs();
            return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy((ActorClass)acc), (Functions.Function1)_function));
        }
        return this.simpleScope((Iterable<? extends EObject>)acc.getActorRefs());
    }

    protected IScope _scopeFor(RelaySAPoint pt, EReference ref) {
        boolean _equals = Objects.equal((Object)ref, (Object)RoomPackage.Literals.RELAY_SA_POINT__RELAY);
        if (_equals) {
            Functions.Function1 _function = it -> it.getServiceProvisionPoints();
            return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy(this._roomHelpers.getActorClass(pt)), (Functions.Function1)_function));
        }
        return this.emptyScope();
    }

    protected IScope _scopeFor(SPPoint pt, EReference ref) {
        boolean _matched = false;
        if (Objects.equal((Object)ref, (Object)RoomPackage.Literals.SP_POINT__REF)) {
            _matched = true;
            ActorContainerClass acc = this._roomHelpers.getActorContainerClass(pt);
            if (acc instanceof ActorClass) {
                Functions.Function1 _function = it -> it.getActorRefs();
                return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy((ActorClass)acc), (Functions.Function1)_function));
            }
            return this.simpleScope((Iterable<? extends EObject>)acc.getActorRefs());
        }
        if (!_matched && Objects.equal((Object)ref, (Object)RoomPackage.Literals.SP_POINT__SERVICE)) {
            _matched = true;
            ActorContainerRef sppref = pt.getRef();
            if (sppref instanceof ActorRef) {
                Functions.Function1 _function_1 = it -> it.getServiceProvisionPoints();
                return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy(((ActorRef)sppref).getType()), (Functions.Function1)_function_1));
            }
            if (sppref instanceof SubSystemRef) {
                return this.simpleScope((Iterable<? extends EObject>)((SubSystemRef)sppref).getType().getServiceProvisionPoints());
            }
        }
        return this.emptyScope();
    }

    protected IScope _scopeFor(MessageHandler handler, EReference ref) {
        ProtocolClass pc;
        boolean _equals = Objects.equal((Object)ref, (Object)RoomPackage.Literals.MESSAGE_HANDLER__MSG);
        if (_equals && (pc = this._roomHelpers.getProtocolClass(handler)) != null) {
            if (handler instanceof InMessageHandler) {
                return this.simpleScope((Iterable<? extends EObject>)pc.getIncomingMessages());
            }
            if (handler instanceof OutMessageHandler) {
                return this.simpleScope((Iterable<? extends EObject>)pc.getOutgoingMessages());
            }
        }
        return this.emptyScope();
    }

    protected IScope _scopeFor(PortOperation op, EReference ref) {
        EObject _eContainer = op.eContainer();
        PortClass pcls = (PortClass)_eContainer;
        ProtocolClass pc = this._roomHelpers.getProtocolClass(op);
        if (pc != null) {
            boolean _tripleEquals;
            PortClass _conjugated = pc.getConjugated();
            boolean bl = _tripleEquals = pcls == _conjugated;
            if (_tripleEquals) {
                return this.simpleScope((Iterable<? extends EObject>)pc.getIncomingMessages());
            }
            return this.simpleScope((Iterable<? extends EObject>)pc.getOutgoingMessages());
        }
        return this.emptyScope();
    }

    protected IScope _scopeFor(ExternalPort ep, EReference ref) {
        return this.simpleScope((Iterable<? extends EObject>)this._roomHelpers.getActorClass(ep).getInterfacePorts());
    }

    protected IScope emptyScope() {
        return IScope.NULLSCOPE;
    }

    protected IScope simpleScope(Iterable<? extends EObject> elements) {
        return Scopes.scopeFor((Iterable)ImmutableList.copyOf(elements));
    }

    protected IScope scopeFor(EObject op, EReference ref) {
        if (op instanceof PortOperation) {
            return this._scopeFor((PortOperation)op, ref);
        }
        if (op instanceof RefSAPoint) {
            return this._scopeFor((RefSAPoint)op, ref);
        }
        if (op instanceof RelaySAPoint) {
            return this._scopeFor((RelaySAPoint)op, ref);
        }
        if (op instanceof Binding) {
            return this._scopeFor((Binding)op, ref);
        }
        if (op instanceof BindingEndPoint) {
            return this._scopeFor((BindingEndPoint)op, ref);
        }
        if (op instanceof ExternalPort) {
            return this._scopeFor((ExternalPort)op, ref);
        }
        if (op instanceof MessageHandler) {
            return this._scopeFor((MessageHandler)op, ref);
        }
        if (op instanceof SPPoint) {
            return this._scopeFor((SPPoint)op, ref);
        }
        if (op instanceof MessageFromIf) {
            return this._scopeFor((MessageFromIf)op, ref);
        }
        if (op instanceof SemanticsRule) {
            return this._scopeFor((SemanticsRule)op, ref);
        }
        if (op instanceof Trigger) {
            return this._scopeFor((Trigger)op, ref);
        }
        if (op != null) {
            return this._scopeFor(op, ref);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(op, ref).toString());
    }
}

