/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.fsm;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.BasicFsmGenBuilder;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.ICommonDataCalculator;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.NullDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.TriggerExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.CommonTrigger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.FsmGenFactory;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ExtendedFsmGenBuilder
extends BasicFsmGenBuilder {
    @Extension
    protected ICommonDataCalculator commonDataCalculator;
    @Extension
    protected TriggerExtensions triggerExtensions;
    protected IDiagnostician validator;
    private final FsmGenFactory factory = FsmGenFactory.eINSTANCE;

    public ExtendedFsmGenBuilder(FSMHelpers fsmHelpers, ICommonDataCalculator commonDataCalculator, TriggerExtensions triggerExtensions, IDiagnostician validator) {
        super(fsmHelpers);
        this.commonDataCalculator = commonDataCalculator;
        this.triggerExtensions = triggerExtensions;
        IDiagnostician _xifexpression = null;
        _xifexpression = validator == null ? new NullDiagnostician() : validator;
        this.validator = _xifexpression;
    }

    @Override
    public GraphContainer createTransformedModel(ModelComponent mc) {
        return this.check(super.createTransformedModel(mc), mc);
    }

    public GraphContainer withTriggersInStates(GraphContainer gc) {
        boolean _not;
        boolean _isInitializedTriggersInStates = gc.isInitializedTriggersInStates();
        boolean bl = _not = !_isInitializedTriggersInStates;
        if (_not) {
            boolean _tripleNotEquals;
            Graph _graph = gc.getGraph();
            boolean bl2 = _tripleNotEquals = _graph != null;
            if (_tripleNotEquals) {
                Functions.Function1 _function = it -> {
                    Graph _subgraph = it.getSubgraph();
                    return _subgraph == null;
                };
                Procedures.Procedure1 _function_1 = it -> this.computeTriggers((Node)it);
                IteratorExtensions.forEach((Iterator)IteratorExtensions.filter(FsmGenExtensions.getAllStateNodes(gc.getGraph()), (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
            }
            gc.setInitializedTriggersInStates(true);
        }
        return gc;
    }

    public GraphContainer withChainHeads(GraphContainer gc) {
        boolean _not;
        boolean _isInitializedChainHeads = gc.isInitializedChainHeads();
        boolean bl = _not = !_isInitializedChainHeads;
        if (_not) {
            boolean _tripleNotEquals;
            Graph _graph = gc.getGraph();
            boolean bl2 = _tripleNotEquals = _graph != null;
            if (_tripleNotEquals) {
                Procedures.Procedure1 _function = it -> this.followChain((Link)it, (Link)it);
                IteratorExtensions.forEach(FsmGenExtensions.getAllChainHeads(gc.getGraph()), (Procedures.Procedure1)_function);
            }
            gc.setInitializedChainHeads(true);
        }
        return gc;
    }

    public GraphContainer withCommonData(GraphContainer gc) {
        boolean _isInitializedCommonData;
        boolean _not_1;
        boolean _not;
        boolean _isInitializedChainHeads = gc.isInitializedChainHeads();
        boolean bl = _not = !_isInitializedChainHeads;
        if (_not) {
            this.withChainHeads(gc);
        }
        boolean bl2 = _not_1 = !(_isInitializedCommonData = gc.isInitializedCommonData());
        if (_not_1) {
            boolean _tripleNotEquals;
            Graph _graph = gc.getGraph();
            boolean bl3 = _tripleNotEquals = _graph != null;
            if (_tripleNotEquals) {
                Procedures.Procedure1 _function = it -> it.setCommonData(this.commonDataCalculator.calculateCommonData((Link)it));
                IteratorExtensions.forEach(FsmGenExtensions.getAllLinks(gc.getGraph()), (Procedures.Procedure1)_function);
            }
            gc.setInitializedCommonData(true);
        }
        return gc;
    }

    private void followChain(Link l, Link head) {
        boolean _not;
        TransitionBase _transition = head.getTransition();
        boolean bl = _not = !(_transition instanceof TriggeredTransition);
        if (_not) {
            l.setIfitemTriggered(false);
        }
        l.getChainHeads().add((Object)head);
        StateGraphNode target = l.getTarget().getStateGraphNode();
        if (target instanceof State || target instanceof TransitionPoint) {
            return;
        }
        EList<Link> _outgoing = l.getTarget().getOutgoing();
        for (Link next : _outgoing) {
            this.followChain(next, head);
        }
    }

    private void computeTriggers(Node s) {
        LinkedHashMap caughtTriggers = CollectionLiterals.newLinkedHashMap();
        this.computeTriggersRecursive(s, caughtTriggers);
        s.getCaughtTriggers().clear();
        s.getCaughtTriggers().addAll(caughtTriggers.values());
    }

    private void computeTriggersRecursive(Node s, HashMap<String, CommonTrigger> caughtTriggers) {
        boolean _not;
        this.computeTriggers(IterableExtensions.toList(FsmGenExtensions.getOutgoingTriggeredTransitionLinks(s)), caughtTriggers);
        Functions.Function1 _function = it -> FsmGenExtensions.getOutgoingTriggeredTransitionLinks(it);
        List trPointTransitions = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map(FsmGenExtensions.getTransitionPointNodes(s.getGraph()), (Functions.Function1)_function)));
        this.computeTriggers(trPointTransitions, caughtTriggers);
        boolean _isTopLevel = FsmGenExtensions.isTopLevel(s.getGraph());
        boolean bl = _not = !_isTopLevel;
        if (_not) {
            this.computeTriggersRecursive(FsmGenExtensions.getParentState(s), caughtTriggers);
        }
    }

    private void computeTriggers(List<Link> sameLevelLinks, HashMap<String, CommonTrigger> caughtTriggers) {
        HashMap trans2link = CollectionLiterals.newHashMap();
        Consumer<Link> _function = it -> trans2link.put(it.getTransition(), it);
        sameLevelLinks.forEach(_function);
        for (Link l : sameLevelLinks) {
            TransitionBase _transition = l.getTransition();
            EList _triggers = ((TriggeredTransition)_transition).getTriggers();
            for (Trigger tr : _triggers) {
                boolean triggerHasGuard = this.fsmHelpers.hasGuard(tr);
                EList _msgFromIfPairs = tr.getMsgFromIfPairs();
                for (MessageFromIf mif : _msgFromIfPairs) {
                    TriggeredTransition unguarded;
                    String tag = this.triggerExtensions.getTriggerTag(mif);
                    CommonTrigger ct = caughtTriggers.get(tag);
                    if (ct == null) {
                        ct = this.createCommonTrigger(l, mif, tag);
                        ct.setHasGuard(triggerHasGuard);
                        caughtTriggers.put(tag, ct);
                        continue;
                    }
                    Functions.Function1 _function_1 = it -> {
                        TransitionBase _transition_1 = it.getTransition();
                        return ((TriggeredTransition)_transition_1).getTriggers();
                    };
                    Functions.Function1 _function_2 = it -> this.hasMatchingTrigger((Trigger)it, tag) && !this.fsmHelpers.hasGuard(it);
                    Trigger _head = (Trigger)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map(ct.getLinks(), (Functions.Function1)_function_1)), (Functions.Function1)_function_2));
                    EObject _eContainer = null;
                    if (_head != null) {
                        _eContainer = _head.eContainer();
                    }
                    if ((unguarded = (TriggeredTransition)_eContainer) != null) {
                        Link unguardedLink = (Link)trans2link.get(unguarded);
                        boolean _contains = sameLevelLinks.contains(unguardedLink);
                        if (!_contains) continue;
                        if (triggerHasGuard) {
                            int idx = ct.getLinks().indexOf((Object)unguardedLink);
                            ct.setHasGuard(triggerHasGuard);
                            ct.getLinks().add(idx, (Object)l);
                            continue;
                        }
                        this.validationError("Transitions with same trigger on same level have to be guarded!", (EObject)l.getTransition(), (EStructuralFeature)FSMPackage.eINSTANCE.getTriggeredTransition_Triggers());
                        continue;
                    }
                    ct.getLinks().add((Object)l);
                }
            }
        }
    }

    private boolean hasMatchingTrigger(Trigger trig, String tag) {
        EList _msgFromIfPairs = trig.getMsgFromIfPairs();
        for (MessageFromIf mifp2 : _msgFromIfPairs) {
            String tr2 = this.triggerExtensions.getTriggerTag(mifp2);
            boolean _equals = tr2.equals(tag);
            if (!_equals) continue;
            return true;
        }
        return false;
    }

    private CommonTrigger createCommonTrigger(Link l, MessageFromIf mif, String tag) {
        CommonTrigger it = this.factory.createCommonTrigger();
        it.setTrigger(tag);
        it.setIfitem(mif.getFrom());
        it.setMsg(mif.getMessage());
        it.getLinks().add((Object)l);
        return it;
    }

    protected GraphContainer check(GraphContainer gc, ModelComponent mc) {
        boolean _not;
        boolean _isAbstract = mc.isAbstract();
        boolean bl = _not = !_isAbstract;
        if (_not) {
            Consumer<Graph> _function = it -> this.checkInitialTransition((Graph)it, mc);
            Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)gc.eAllContents()), Graph.class).forEach(_function);
        }
        return gc;
    }

    protected void checkInitialTransition(Graph graph, ModelComponent mc) {
        boolean _tripleNotEquals;
        InitialTransition _initialTransition = FsmGenExtensions.getInitialTransition(graph);
        boolean bl = _tripleNotEquals = _initialTransition != null;
        if (_tripleNotEquals) {
            return;
        }
        EObject _eContainer = graph.eContainer();
        if (_eContainer instanceof GraphContainer) {
            this.validationError("Top level state graph must have an initial transition", (EObject)mc, (EStructuralFeature)FSMPackage.Literals.MODEL_COMPONENT__STATE_MACHINE);
            return;
        }
        EObject _eContainer_1 = graph.eContainer();
        Node parentState = (Node)_eContainer_1;
        EObject _eContainer_2 = parentState.eContainer();
        Graph parentGraph = (Graph)_eContainer_2;
        Functions.Function1 _function = it -> {
            Node _target = it.getTarget();
            return Objects.equal((Object)_target, (Object)parentState);
        };
        Functions.Function1 _function_1 = it -> {
            Node _source = it.getSource();
            return !Objects.equal((Object)_source, (Object)parentState);
        };
        boolean parentHasHistoryTransitions = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(parentGraph.getLinks(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        if (!parentHasHistoryTransitions) {
            this.validationError("The state graph has transitions to history in its parent graph (which are no self transitions), thus it must have an initial transition", (EObject)parentState.getStateGraphNode(), (EStructuralFeature)FSMPackage.Literals.STATE__SUBGRAPH);
        }
    }

    protected void validationError(String msg, EObject obj, EStructuralFeature feature) {
        this.validationError(msg, obj, feature, -1);
    }

    protected void validationError(String msg, EObject obj, EStructuralFeature feature, int idx) {
        this.validator.error(msg, obj, feature, idx);
    }
}

