/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.base;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LiteralType implements Enumerator
{
    BOOL(0, "BOOL", "ptBoolean"),
    INT(1, "INT", "ptInteger"),
    REAL(2, "REAL", "ptReal"),
    CHAR(3, "CHAR", "ptCharacter");

    public static final int BOOL_VALUE = 0;
    public static final int INT_VALUE = 1;
    public static final int REAL_VALUE = 2;
    public static final int CHAR_VALUE = 3;
    private static final LiteralType[] VALUES_ARRAY;
    public static final List<LiteralType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static LiteralType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LiteralType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static LiteralType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LiteralType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static LiteralType get(int value) {
        switch (value) {
            case 0: {
                return BOOL;
            }
            case 1: {
                return INT;
            }
            case 2: {
                return REAL;
            }
            case 3: {
                return CHAR;
            }
        }
        return null;
    }

    private LiteralType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new LiteralType[]{BOOL, INT, REAL, CHAR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

