@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      http://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  org.eclipse.etrice.generator.doc startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and ORG_ECLIPSE_ETRICE_GENERATOR_DOC_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\org.eclipse.etrice.generator.doc-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.generator-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.core.etmap-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.core.genmodel-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.core.config-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.core.room-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.abstractexec.behavior-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.generator.fsm-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.core.genmodel.fsm-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.core.etphys-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.core.fsm-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.core.common-3.0.0.jar;%APP_HOME%\lib\org.eclipse.etrice.generator.base-3.0.0.jar;%APP_HOME%\lib\org.eclipse.xtext-2.15.0.jar;%APP_HOME%\lib\org.eclipse.xtext.util-2.15.0.jar;%APP_HOME%\lib\org.eclipse.xtend.lib-2.15.0.jar;%APP_HOME%\lib\org.eclipse.core.resources-3.12.0.jar;%APP_HOME%\lib\org.eclipse.core.expressions-3.6.500.jar;%APP_HOME%\lib\org.eclipse.core.runtime-3.12.0.jar;%APP_HOME%\lib\org.eclipse.xtend.lib.macro-2.15.0.jar;%APP_HOME%\lib\org.eclipse.xtext.xbase.lib-2.15.0.jar;%APP_HOME%\lib\guava-21.0.jar;%APP_HOME%\lib\log4j-1.2.16.jar;%APP_HOME%\lib\org.eclipse.core.jobs-3.10.500.jar;%APP_HOME%\lib\org.eclipse.core.contenttype-3.7.400.jar;%APP_HOME%\lib\org.eclipse.equinox.app-1.4.300.jar;%APP_HOME%\lib\org.eclipse.core.filesystem-1.7.500.jar;%APP_HOME%\lib\org.eclipse.equinox.registry-3.8.500.jar;%APP_HOME%\lib\org.eclipse.equinox.preferences-3.7.500.jar;%APP_HOME%\lib\org.eclipse.equinox.common-3.9.0.jar;%APP_HOME%\lib\org.eclipse.osgi-3.12.100.jar;%APP_HOME%\lib\org.eclipse.emf.common-2.12.0.jar;%APP_HOME%\lib\org.eclipse.emf.ecore.xmi-2.12.0.jar;%APP_HOME%\lib\guice-3.0.jar;%APP_HOME%\lib\antlr-runtime-3.2.jar;%APP_HOME%\lib\commons-io-2.5.jar;%APP_HOME%\lib\org.eclipse.emf.ecore-2.12.0.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\aopalliance-1.0.jar

@rem Execute org.eclipse.etrice.generator.doc
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %ORG_ECLIPSE_ETRICE_GENERATOR_DOC_OPTS%  -classpath "%CLASSPATH%" org.eclipse.etrice.generator.doc.Main %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable ORG_ECLIPSE_ETRICE_GENERATOR_DOC_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%ORG_ECLIPSE_ETRICE_GENERATOR_DOC_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
