/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ClassStructor;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class ProcedureHelpers {
    protected final String NEWLINE = System.getProperty("line.separator");
    @Inject
    @Extension
    protected RoomHelpers _roomHelpers;
    @Inject
    @Extension
    protected TypeHelpers _typeHelpers;
    @Inject
    @Extension
    protected IDetailCodeTranslator _iDetailCodeTranslator;
    @Inject
    protected ILanguageExtension languageExt;
    @Inject
    protected ILogger logger;

    public CharSequence userCode(DataClass dc, int id) {
        CharSequence _switchResult = null;
        switch (id) {
            case 1: {
                _switchResult = this.userCode(this._roomHelpers.getDeepUserCode1(dc));
                break;
            }
            case 2: {
                _switchResult = this.userCode(this._roomHelpers.getDeepUserCode2(dc));
                break;
            }
            case 3: {
                _switchResult = this.userCode(this._roomHelpers.getDeepUserCode3(dc));
            }
        }
        return _switchResult;
    }

    public CharSequence userCode(ProtocolClass pc, int id) {
        CharSequence _switchResult = null;
        switch (id) {
            case 1: {
                _switchResult = this.userCode(this._roomHelpers.getDeepUserCode1(pc));
                break;
            }
            case 2: {
                _switchResult = this.userCode(this._roomHelpers.getDeepUserCode2(pc));
                break;
            }
            case 3: {
                _switchResult = this.userCode(this._roomHelpers.getDeepUserCode3(pc));
            }
        }
        return _switchResult;
    }

    public CharSequence userCode(ActorContainerClass ac, int id, boolean includeInherited) {
        CharSequence _xifexpression = null;
        if (includeInherited) {
            CharSequence _switchResult = null;
            switch (id) {
                case 1: {
                    _switchResult = this.userCode(this._roomHelpers.getDeepUserCode1(ac));
                    break;
                }
                case 2: {
                    _switchResult = this.userCode(this._roomHelpers.getDeepUserCode2(ac));
                    break;
                }
                case 3: {
                    _switchResult = this.userCode(this._roomHelpers.getDeepUserCode3(ac));
                }
            }
            _xifexpression = _switchResult;
        } else {
            CharSequence _switchResult_1 = null;
            switch (id) {
                case 1: {
                    _switchResult_1 = this.userCode(ac.getUserCode1());
                    break;
                }
                case 2: {
                    _switchResult_1 = this.userCode(ac.getUserCode2());
                    break;
                }
                case 3: {
                    _switchResult_1 = this.userCode(ac.getUserCode3());
                }
            }
            _xifexpression = _switchResult_1;
        }
        return _xifexpression;
    }

    public CharSequence userCode(DetailCode dc) {
        return this.userCode(this._roomHelpers.getDetailCode(dc));
    }

    private CharSequence userCode(String code) {
        StringConcatenation _builder = new StringConcatenation();
        if (code != null && !code.isEmpty()) {
            _builder.append("/*--------------------- begin user code ---------------------*/");
            _builder.newLine();
            _builder.append(code);
            _builder.newLineIfNotEmpty();
            _builder.append("/*--------------------- end user code ---------------------*/");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence attributes(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*--------------------- attributes ---------------------*/");
        _builder.newLine();
        for (Attribute it : attributes) {
            CharSequence _attributeDeclaration = this.attributeDeclaration(it);
            _builder.append((Object)_attributeDeclaration);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence attributeDeclaration(Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append(_accessLevelPublic);
        _builder.append(" ");
        String _declarationString = this.declarationString(attribute);
        _builder.append(_declarationString);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String arrayInitializer(Attribute att) {
        String _xifexpression = null;
        String _defaultValueLiteral = att.getDefaultValueLiteral();
        boolean _tripleNotEquals = _defaultValueLiteral != null;
        _xifexpression = _tripleNotEquals ? att.getDefaultValueLiteral() : this.languageExt.defaultValue(att.getType().getType());
        String dflt = _xifexpression;
        boolean _startsWith = dflt.startsWith("{");
        if (_startsWith) {
            int _size_1;
            boolean _notEquals;
            int _size = ((List)Conversions.doWrapArray((Object)dflt.split(","))).size();
            boolean bl = _notEquals = _size != (_size_1 = att.getSize());
            if (_notEquals) {
                String _name = att.getName();
                String _plus = "WARNING: array size determined by initializer differs from attribute size (" + _name;
                String _plus_1 = _plus + "[";
                int _size_2 = att.getSize();
                String _plus_2 = _plus_1 + Integer.valueOf(_size_2);
                String _plus_3 = _plus_2 + "] <-> ";
                String _plus_4 = _plus_3 + dflt;
                String _plus_5 = _plus_4 + ")";
                this.logger.logInfo(_plus_5);
            }
            return dflt;
        }
        String result = "{";
        int i = 0;
        while (i < att.getSize()) {
            boolean _lessThan;
            result = result + dflt;
            int _size_3 = att.getSize();
            if (!(_lessThan = ++i < _size_3)) continue;
            result = result + ", ";
        }
        return result + "}";
    }

    public CharSequence attributeSettersGettersDeclaration(List<Attribute> attributes, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/* --------------------- attribute setters and getters */");
        _builder.newLine();
        for (Attribute attribute : attributes) {
            CharSequence _setterHeader = this.setterHeader(attribute, classname);
            _builder.append((Object)_setterHeader);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            CharSequence _terHeader = this.getterHeader(attribute, classname);
            _builder.append((Object)_terHeader);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence attributeSettersGettersImplementation(List<Attribute> attributes, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/* --------------------- attribute setters and getters */");
        _builder.newLine();
        for (Attribute attribute : attributes) {
            CharSequence _setterHeader = this.setterHeader(attribute, classname);
            _builder.append((Object)_setterHeader);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t ");
            String _memberAccess = this.languageExt.memberAccess();
            _builder.append(_memberAccess, "\t ");
            String _name = attribute.getName();
            _builder.append(_name, "\t ");
            _builder.append(" = ");
            String _name_1 = attribute.getName();
            _builder.append(_name_1, "\t ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            CharSequence _terHeader = this.getterHeader(attribute, classname);
            _builder.append((Object)_terHeader);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return ");
            String _memberAccess_1 = this.languageExt.memberAccess();
            _builder.append(_memberAccess_1, "\t");
            String _name_2 = attribute.getName();
            _builder.append(_name_2, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence setterHeader(Attribute attribute, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append(_accessLevelPublic);
        _builder.append("void set");
        String _firstUpper = StringExtensions.toFirstUpper((String)attribute.getName());
        _builder.append(_firstUpper);
        _builder.append("(");
        String _selfPointer = this.languageExt.selfPointer(classname, true);
        _builder.append(_selfPointer);
        String _argList = this.argList(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Attribute[]{attribute})));
        _builder.append(_argList);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence getterHeader(Attribute attribute, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append(_accessLevelPublic);
        String _signatureString = this.signatureString(attribute);
        _builder.append(_signatureString);
        _builder.append(" get");
        String _firstUpper = StringExtensions.toFirstUpper((String)attribute.getName());
        _builder.append(_firstUpper);
        _builder.append("(");
        String _selfPointer = this.languageExt.selfPointer(classname, false);
        _builder.append(_selfPointer);
        _builder.append(")");
        return _builder;
    }

    public String argList(Iterable<Attribute> attributes) {
        Functions.Function1 _function = it -> {
            String _signatureString = this.signatureString((Attribute)it);
            String _plus = _signatureString + " ";
            String _name = it.getName();
            return _plus + _name;
        };
        return IterableExtensions.join((Iterable)IterableExtensions.map(attributes, (Functions.Function1)_function), (CharSequence)", ");
    }

    public CharSequence invokeGetters(Iterable<Attribute> path, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : path) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)".", "");
            }
            CharSequence _invokeGetter = this.invokeGetter(a.getName(), classname);
            _builder.append((Object)_invokeGetter);
        }
        return _builder;
    }

    public CharSequence getterImplementation(String typeName, String name, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append(_accessLevelPublic);
        _builder.append(typeName);
        _builder.append(" get");
        String _firstUpper = StringExtensions.toFirstUpper((String)name);
        _builder.append(_firstUpper);
        _builder.append(" (");
        String _selfPointer = this.languageExt.selfPointer(classname, false);
        _builder.append(_selfPointer);
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        String _memberAccess = this.languageExt.memberAccess();
        _builder.append(_memberAccess, "\t");
        _builder.append(name, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence invokeGetter(String name, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("get");
        String _firstUpper = StringExtensions.toFirstUpper((String)name);
        _builder.append(_firstUpper);
        _builder.append("(");
        String _selfPointer = this.languageExt.selfPointer(classname, true);
        _builder.append(_selfPointer);
        _builder.append(")");
        return _builder;
    }

    public CharSequence invokeSetter(String name, String classname, String value) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("set");
        String _firstUpper = StringExtensions.toFirstUpper((String)name);
        _builder.append(_firstUpper);
        _builder.append("(");
        String _selfPointer = this.languageExt.selfPointer(classname, true);
        _builder.append(_selfPointer);
        _builder.append(value);
        _builder.append(")");
        return _builder;
    }

    public CharSequence operationsDeclaration(List<? extends Operation> operations, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*--------------------- operations ---------------------*/");
        _builder.newLine();
        for (Operation operation : operations) {
            CharSequence _operationSignature = this.operationSignature(operation, classname, true);
            _builder.append((Object)_operationSignature);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence operationsImplementation(List<? extends Operation> operations, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*--------------------- operations ---------------------*/");
        _builder.newLine();
        for (Operation operation : operations) {
            CharSequence _operationSignature = this.operationSignature(operation, classname, false);
            _builder.append((Object)_operationSignature);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _translatedCode = this._iDetailCodeTranslator.getTranslatedCode(operation.getDetailCode());
            _builder.append(_translatedCode, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence asBlock(CharSequence str) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append((Object)str, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String invokeUserStructor(RoomClass cls, String args, boolean ctor) {
        boolean _usesInheritance = this.languageExt.usesInheritance();
        boolean _not = !_usesInheritance;
        Functions.Function1 _function = it -> {
            boolean _isConstructor = it.isConstructor();
            return _isConstructor == ctor;
        };
        boolean _exists = IterableExtensions.exists(this.getStructors(cls, _not), (Functions.Function1)_function);
        if (_exists) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = cls.getName();
            String _xifexpression = null;
            _xifexpression = ctor ? "ctor" : "dtor";
            String _memberInDeclaration = this.languageExt.memberInDeclaration(_name, _xifexpression);
            _builder.append(_memberInDeclaration);
            _builder.append("(");
            _builder.append(args);
            _builder.append(");");
            return _builder.toString();
        }
        return "";
    }

    public String userStructorsDeclaration(RoomClass cls) {
        boolean _usesInheritance_1;
        String _xblockexpression = null;
        String namePrefix = this.languageExt.operationScope(cls.getName(), true);
        ArrayList declBlock = CollectionLiterals.newArrayList();
        declBlock.add("/*--------------------- user constructor/destructor ---------------------*/");
        boolean _usesInheritance = this.languageExt.usesInheritance();
        boolean _not = !_usesInheritance;
        Functions.Function1 _function = it -> it.isConstructor();
        boolean _exists = IterableExtensions.exists(this.getStructors(cls, _not), (Functions.Function1)_function);
        if (_exists) {
            CharSequence _functionSignature = this.functionSignature(cls.getName(), namePrefix + "ctor", "void", "");
            String _plus = _functionSignature + ";";
            declBlock.add(_plus);
        }
        boolean _not_1 = !(_usesInheritance_1 = this.languageExt.usesInheritance());
        Functions.Function1 _function_1 = it -> {
            boolean _isConstructor = it.isConstructor();
            return !_isConstructor;
        };
        boolean _exists_1 = IterableExtensions.exists(this.getStructors(cls, _not_1), (Functions.Function1)_function_1);
        if (_exists_1) {
            CharSequence _functionSignature_1 = this.functionSignature(cls.getName(), namePrefix + "dtor", "void", "");
            String _plus_1 = _functionSignature_1 + ";";
            declBlock.add(_plus_1);
        }
        _xblockexpression = IterableExtensions.join((Iterable)declBlock, (CharSequence)this.NEWLINE);
        return _xblockexpression;
    }

    public String userStructorsImplementation(RoomClass cls) {
        String _xblockexpression = null;
        ArrayList declBlock = CollectionLiterals.newArrayList();
        declBlock.add("/*--------------------- user constructor/destructor ---------------------*/");
        String _userStuctorImplementation = this.userStuctorImplementation(cls, true);
        declBlock.add(_userStuctorImplementation);
        String _userStuctorImplementation_1 = this.userStuctorImplementation(cls, false);
        declBlock.add(_userStuctorImplementation_1);
        _xblockexpression = IterableExtensions.join((Iterable)IterableExtensions.filterNull((Iterable)declBlock), (CharSequence)this.NEWLINE);
        return _xblockexpression;
    }

    protected String userStuctorImplementation(RoomClass cls, boolean ctor) {
        boolean _not_1;
        String _xblockexpression = null;
        String namePrefix = this.languageExt.operationScope(cls.getName(), false);
        boolean _usesInheritance = this.languageExt.usesInheritance();
        boolean _not = !_usesInheritance;
        Functions.Function1 _function = it -> {
            boolean _isConstructor = it.isConstructor();
            return _isConstructor == ctor;
        };
        boolean _exists = IterableExtensions.exists(this.getStructors(cls, _not), (Functions.Function1)_function);
        boolean bl = _not_1 = !_exists;
        if (_not_1) {
            return null;
        }
        StringConcatenation _builder = new StringConcatenation();
        String _name = cls.getName();
        String _xifexpression = null;
        _xifexpression = ctor ? "ctor" : "dtor";
        String _plus = namePrefix + _xifexpression;
        CharSequence _functionSignature = this.functionSignature(_name, _plus, "void", "");
        _builder.append((Object)_functionSignature);
        _builder.append("{");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _userStructorBody = this.userStructorBody(cls, ctor);
        _builder.append(_userStructorBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String userStructorBody(RoomClass cls, boolean ctor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/* user defined ");
        if (ctor) {
            _builder.append("con");
        } else {
            _builder.append("de");
        }
        _builder.append("structor body */");
        String comment = _builder.toString();
        boolean _usesInheritance = this.languageExt.usesInheritance();
        boolean _not = !_usesInheritance;
        Functions.Function1 _function = it -> {
            boolean _isConstructor = it.isConstructor();
            return _isConstructor == ctor;
        };
        Iterable implementedStructors = IterableExtensions.filter(this.getStructors(cls, _not), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getDetailCode();
        Functions.Function1 _function_2 = it -> this._iDetailCodeTranslator.getTranslatedCode(it);
        Iterable translatedCodes = IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)implementedStructors, (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = it -> {
            CharSequence _xifexpression = null;
            int _size = IterableExtensions.size((Iterable)translatedCodes);
            boolean _greaterThan = _size > 1;
            _xifexpression = _greaterThan ? this.asBlock((CharSequence)it) : it;
            return _xifexpression;
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)translatedCodes, (Functions.Function1)_function_3));
        return comment + this.NEWLINE + _join;
    }

    protected List<ClassStructor> getStructors(RoomClass cls, boolean inherited) {
        Object _switchResult = null;
        RoomClass it = cls;
        boolean _matched = false;
        if (it instanceof ActorClass && !inherited) {
            _matched = true;
            _switchResult = ((ActorClass)it).getStructors();
        }
        if (!_matched && it instanceof DataClass && !inherited) {
            _matched = true;
            _switchResult = ((DataClass)it).getStructors();
        }
        if (!_matched && it instanceof ActorClass && inherited) {
            _matched = true;
            _switchResult = this._roomHelpers.getAllStructors((ActorClass)it);
        }
        if (!_matched && it instanceof DataClass && inherited) {
            _matched = true;
            _switchResult = this._roomHelpers.getAllStructors((DataClass)it);
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptyList();
        }
        return _switchResult;
    }

    protected CharSequence operationSignature(Operation operation, String classname, boolean isDeclaration) {
        CharSequence _xblockexpression = null;
        Functions.Function1 _function = arg -> this.languageExt.toParameterDecl((VarDecl)arg);
        String arguments = IterableExtensions.join((Iterable)ListExtensions.map((List)operation.getArguments(), (Functions.Function1)_function), (CharSequence)", ");
        String returnType = this.languageExt.getTypeSignature(operation.getReturnType());
        String _operationScope = this.languageExt.operationScope(classname, isDeclaration);
        String _name = operation.getName();
        String _plus = _operationScope + _name;
        _xblockexpression = this.functionSignature(classname, _plus, returnType, arguments);
        return _xblockexpression;
    }

    public String signatureString(Attribute attribute) {
        boolean _greaterThan;
        String _switchResult = null;
        Attribute it = attribute;
        boolean _matched = false;
        int _size = it.getSize();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _matched = true;
            _switchResult = this.languageExt.arrayType(this._typeHelpers.typeName(it.getType().getType()), it.getSize(), it.getType().isRef());
        }
        if (!_matched) {
            _switchResult = this.languageExt.getTypeSignature(it.getType());
        }
        return _switchResult;
    }

    public String declarationString(Attribute attribute) {
        boolean _greaterThan;
        String _switchResult = null;
        Attribute it = attribute;
        boolean _matched = false;
        int _size = it.getSize();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _matched = true;
            _switchResult = this.languageExt.arrayDeclaration(this._typeHelpers.typeName(it.getType().getType()), it.getSize(), it.getType().isRef(), it.getName());
        }
        if (!_matched) {
            String _typeSignature = this.languageExt.getTypeSignature(it.getType());
            String _plus = _typeSignature + " ";
            String _name = it.getName();
            _switchResult = _plus + _name;
        }
        return _switchResult;
    }

    protected CharSequence functionSignature(String className, String fullFctName, String returnType, String arguments) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append(_accessLevelPublic);
        _builder.append(" ");
        _builder.append(returnType);
        _builder.append(" ");
        _builder.append(fullFctName);
        _builder.append("(");
        boolean _isEmpty = arguments.isEmpty();
        boolean _not = !_isEmpty;
        String _selfPointer = this.languageExt.selfPointer(className, _not);
        _builder.append(_selfPointer);
        _builder.append(arguments);
        _builder.append(")");
        return _builder;
    }
}

