/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.GenDir;
import org.eclipse.etrice.generator.fsm.base.GenFile;
import org.eclipse.etrice.generator.fsm.base.GenItem;
import org.eclipse.etrice.generator.fsm.base.IFileFilter;

public class GenFileTreeBuilder {
    private GenDir genFileTree;
    private IFileFilter filter;

    public GenFileTreeBuilder(String uri, Collection<String> files, IFileFilter filter) {
        this(GenFileTreeBuilder.getURI(uri), files, filter);
    }

    public GenFileTreeBuilder(URI base, Collection<String> files, IFileFilter filter) {
        this.filter = filter;
        ArrayList<String> relPaths = this.computeFilesAsRelativePaths(base, files);
        this.genFileTree = this.computeGenTree(relPaths);
    }

    public GenDir getGenFileTree() {
        return this.genFileTree;
    }

    private ArrayList<String> computeFilesAsRelativePaths(URI base, Collection<String> files) {
        ArrayList<String> relFiles = new ArrayList<String>(files.size());
        for (String file : files) {
            String relPath = FileSystemHelpers.getRelativePath((URI)base, (URI)URI.createFileURI((String)file.replace("\\\\", "\\")));
            if (relPath == null || this.filter != null && !this.filter.accept(relPath)) continue;
            relFiles.add(relPath);
        }
        Collections.sort(relFiles);
        return relFiles;
    }

    private GenDir computeGenTree(ArrayList<String> relPaths) {
        GenDir root = new GenDir(null, "root");
        for (String path : relPaths) {
            String[] segments = path.split("/");
            GenDir dir = this.makeDir(root, segments);
            new GenFile(dir, segments[segments.length - 1]);
        }
        return root;
    }

    private GenDir makeDir(GenDir current, String[] segments) {
        for (int i = 0; i < segments.length - 1; ++i) {
            GenDir next = null;
            for (GenItem item : current.getContents()) {
                if (!(item instanceof GenDir) || !item.getName().equals(segments[i])) continue;
                next = (GenDir)item;
                break;
            }
            if (next == null) {
                next = new GenDir(current, segments[i]);
            }
            current = next;
        }
        return current;
    }

    private static URI getURI(String uri) {
        URI base = URI.createFileURI((String)uri);
        if (base.hasTrailingPathSeparator()) {
            base = base.trimSegments(1);
        }
        return base;
    }
}

