/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.generic;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.Guard;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FSMExtensions {
    @Inject
    @Extension
    protected FSMHelpers _fSMHelpers;

    public <T> List<T> union(Iterable<T> l, T e) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterables.addAll(ret, l);
        ret.add(e);
        return ret;
    }

    public <T> List<T> union(Iterable<T> l1, Iterable<T> l2) {
        ArrayList ret = new ArrayList();
        Iterables.addAll(ret, l1);
        Iterables.addAll(ret, l2);
        return ret;
    }

    public <T> List<T> minus(List<T> l1, List<T> l2) {
        ArrayList<T> ret = new ArrayList<T>(l1);
        ret.removeAll(l2);
        return ret;
    }

    public Iterable<State> getLeafStatesLast(List<State> states) {
        Iterable _xblockexpression = null;
        Functions.Function1 _function = s -> this._fSMHelpers.isLeaf(s);
        Iterable leaf = IterableExtensions.filter(states, (Functions.Function1)_function);
        Functions.Function1 _function_1 = s -> {
            boolean _isLeaf = this._fSMHelpers.isLeaf(s);
            return !_isLeaf;
        };
        Iterable nonLeaf = IterableExtensions.filter(states, (Functions.Function1)_function_1);
        _xblockexpression = Iterables.concat((Iterable)nonLeaf, (Iterable)leaf);
        return _xblockexpression;
    }

    public List<State> getAllLeafStates(ModelComponent mc) {
        return this._fSMHelpers.getLeafStateList(mc.getStateMachine());
    }

    public List<State> getAllBaseStatesLeavesLast(ModelComponent mc) {
        return IterableExtensions.toList(this.getLeafStatesLast(this._fSMHelpers.getAllBaseStates(mc)));
    }

    public int getNumberOfInheritedStates(ModelComponent mc) {
        boolean _tripleEquals;
        ModelComponent _base = mc.getBase();
        boolean bl = _tripleEquals = _base == null;
        if (_tripleEquals) {
            return 0;
        }
        int _size = this._fSMHelpers.getStateList(mc.getBase().getStateMachine()).size();
        int _numberOfInheritedStates = this.getNumberOfInheritedStates(mc.getBase());
        return _size + _numberOfInheritedStates;
    }

    public int getNumberOfInheritedBaseStates(ModelComponent ac) {
        boolean _tripleEquals;
        ModelComponent _base = ac.getBase();
        boolean bl = _tripleEquals = _base == null;
        if (_tripleEquals) {
            return 0;
        }
        int _size = this._fSMHelpers.getBaseStateList(ac.getBase().getStateMachine()).size();
        int _numberOfInheritedBaseStates = this.getNumberOfInheritedBaseStates(ac.getBase());
        return _size + _numberOfInheritedBaseStates;
    }

    public boolean isConditionOrGuard(DetailCode dc) {
        boolean _xblockexpression = false;
        EObject parent = dc.eContainer();
        boolean _switchResult = false;
        boolean _matched = false;
        if (parent instanceof Guard) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && parent instanceof CPBranchTransition) {
            _matched = true;
            DetailCode _condition = ((CPBranchTransition)parent).getCondition();
            _switchResult = Objects.equal((Object)_condition, (Object)dc);
        }
        if (!_matched) {
            _switchResult = false;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }
}

