/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.xtext.naming.QualifiedName;

public class FileSystemModelPath
implements IModelPath {
    private List<Path> paths;
    private HashMap<QualifiedName, List<IModelPath.ModelFile>> packages;

    public FileSystemModelPath(List<Path> paths) {
        this.paths = paths;
        this.packages = new HashMap();
    }

    @Override
    public Stream<IModelPath.ModelFile> getFiles(QualifiedName name) {
        QualifiedName pkgName = name.skipLast(1);
        String fileName = name.getLastSegment();
        return this.packages.computeIfAbsent(pkgName, n -> this.createPackage((QualifiedName)n)).stream().filter(mf -> mf.name.getLastSegment().equals(fileName));
    }

    @Override
    public Stream<IModelPath.ModelFile> getAllFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<QualifiedName> getQualifiedName(URI uri) {
        if (uri.isFile()) {
            Path path = Paths.get(uri.toFileString(), new String[0]);
            return this.paths.stream().filter(p -> path.startsWith((Path)p)).map(p -> p.relativize(path)).map(p -> this.createQualifiedName((Path)p)).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public String toString() {
        return this.paths.toString();
    }

    private List<IModelPath.ModelFile> createPackage(QualifiedName name) {
        return this.paths.stream().map(path -> this.createPackagePath((Path)path, name)).filter(path -> Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)).flatMap(dir -> this.listFiles((Path)dir, name)).collect(Collectors.toList());
    }

    private Stream<IModelPath.ModelFile> listFiles(Path dir, QualifiedName name) {
        try {
            return Files.list(dir).filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(file -> this.createModelFile((Path)file, name));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private IModelPath.ModelFile createModelFile(Path file, QualifiedName pkg) {
        URI uri = URI.createURI((String)file.toUri().toString());
        String fileName = file.getFileName().toString();
        return IModelPath.ModelFile.create(uri, pkg, fileName);
    }

    private Path createPackagePath(Path dir, QualifiedName name) {
        if (!name.isEmpty()) {
            String firstSegment = name.getFirstSegment();
            String[] segments = new String[name.getSegmentCount() - 1];
            for (int i = 0; i < segments.length; ++i) {
                segments[i] = name.getSegment(i + 1);
            }
            Path relativePackagePath = dir.getFileSystem().getPath(firstSegment, segments);
            Path packagePath = dir.resolve(relativePackagePath);
            return packagePath;
        }
        return dir;
    }

    private QualifiedName createQualifiedName(Path path) {
        String[] segments = (String[])StreamSupport.stream(path.spliterator(), false).map(p -> p.toString()).toArray(String[]::new);
        if (segments.length > 0) {
            int lastIndex = segments.length - 1;
            segments[lastIndex] = this.trimFileExtension(segments[lastIndex]);
        }
        return QualifiedName.create((String[])segments);
    }

    private String trimFileExtension(String fileName) {
        int periodIndex = fileName.lastIndexOf(46);
        if (periodIndex != -1) {
            return fileName.substring(0, periodIndex);
        }
        return fileName;
    }
}

