/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.converter;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class TimeConverter
extends AbstractValueConverter<Long> {
    public static final String SEC = "s";
    public static final String MILLI_SEC = "ms";
    public static final String MICRO_SEC = "us";
    public static final String NANO_SEC = "ns";

    public Long toValue(String string, INode node) throws ValueConverterException {
        int power;
        String value;
        if (Strings.isEmpty((String)string)) {
            if (node != null && !Strings.isEmpty((String)node.getText())) {
                throw new ValueConverterException("No valid time value.", node, null);
            }
            throw new ValueConverterException("Couldn't convert empty string to time.", node, null);
        }
        int pos = string.indexOf(NANO_SEC);
        if (pos > 0) {
            value = string.substring(0, pos);
            power = 1;
        } else {
            pos = string.indexOf(MICRO_SEC);
            if (pos > 0) {
                value = string.substring(0, pos);
                power = 1000;
            } else {
                pos = string.indexOf(MILLI_SEC);
                if (pos > 0) {
                    value = string.substring(0, pos);
                    power = 1000000;
                } else {
                    pos = string.indexOf(SEC);
                    if (pos > 0) {
                        value = string.substring(0, pos);
                        power = 1000000000;
                    } else {
                        throw new ValueConverterException("No unit specified with time (s, ms, us or ns).", node, null);
                    }
                }
            }
        }
        try {
            long val = Long.parseLong(value.trim());
            return val * (long)power;
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Could not parse time value.", node, (Exception)e);
        }
    }

    public String toString(Long value) throws ValueConverterException {
        if (value % 1000L == 0L) {
            if (value % 1000000L == 0L) {
                if (value % 1000000000L == 0L) {
                    return value / 1000000000L + SEC;
                }
                return value / 1000000L + MILLI_SEC;
            }
            return value / 1000L + MICRO_SEC;
        }
        return value + NANO_SEC;
    }

    public static long split(long nanoSeconds, String unit, boolean isNewUnit) {
        if (unit.equals(SEC)) {
            return isNewUnit ? nanoSeconds / 1000000000L : nanoSeconds;
        }
        if (unit.equals(MILLI_SEC)) {
            return isNewUnit ? nanoSeconds / 1000000L : nanoSeconds - TimeConverter.split(nanoSeconds, SEC, true) * 1000000000L;
        }
        if (unit.equals(MICRO_SEC)) {
            return isNewUnit ? nanoSeconds / 1000L : nanoSeconds - TimeConverter.split(nanoSeconds, MILLI_SEC, true) * 1000000L;
        }
        if (unit.equals(NANO_SEC)) {
            return isNewUnit ? nanoSeconds : nanoSeconds - TimeConverter.split(nanoSeconds, MICRO_SEC, true) * 1000L;
        }
        throw new UnsupportedOperationException("Invalid time unit");
    }
}

