/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.validation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.validation.ICustomValidator;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class CustomValidatorManager
extends AbstractDeclarativeValidator {
    public static final String VAL_CONTEXT_SETUP_KEY = CustomValidatorManager.class.getName() + ".contextSetup";
    public static final String VAL_CONTEXT_SETUP_ECLIPSE = "eclipse";
    public static final String VAL_CONTEXT_SETUP_STANDALONE = "standalone";
    public static final String VAL_CONTEXT_TARGET_KEY = CustomValidatorManager.class.getName() + ".contextTarget";
    public static final String VAL_CONTEXT_TARGET_RESOURCE = "resource";
    public static final String VAL_CONTEXT_TARGET_GENERATION = "generation";
    @Inject
    @Named(value="languageName")
    protected String languageName;

    @Inject
    public void registerStandaloneValidators(StandaloneValidatorExtension extension, Injector injector) {
        for (String className : extension) {
            this.instanceAndRegisterValidator(injector, className);
        }
    }

    private void instanceAndRegisterValidator(Injector injector, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            ICustomValidator instance = (ICustomValidator)injector.getInstance(clazz);
            ICustomValidator.Registry.INSTANCE.add(this.languageName, instance);
        }
        catch (Throwable e) {
            System.out.println("Failed to load custom validator " + className);
        }
    }

    @Check
    public void checkObjectsStandalone(EObject object) {
        ValidationContextImpl context = new ValidationContextImpl(this.isStandalone(), this.isGeneration(), this.getCheckMode());
        HashSet<EClass> checkTypes = new HashSet<EClass>((Collection<EClass>)object.eClass().getEAllSuperTypes());
        checkTypes.add(object.eClass());
        for (ICustomValidator val : this.getCustomValidators()) {
            this.executeValidator(val, object, checkTypes, (ValidationMessageAcceptor)this, context);
        }
    }

    protected void executeValidator(final ICustomValidator validator, final EObject object, final Set<EClass> checkTypes, final ValidationMessageAcceptor messageAcceptor, final ICustomValidator.ValidationContext context) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable exception) {
                System.out.println("Exception in ICustomValidator " + validator.getName());
                exception.printStackTrace();
            }

            public void run() throws Exception {
                if (checkTypes == null || !Sets.intersection((Set)checkTypes, validator.getClassesToCheck()).isEmpty()) {
                    validator.validate(object, messageAcceptor, context);
                }
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }

    protected boolean isStandalone() {
        String contextSetup = (String)this.getContext().get(VAL_CONTEXT_SETUP_KEY);
        return VAL_CONTEXT_SETUP_STANDALONE.equals(contextSetup);
    }

    protected boolean isGeneration() {
        String target = (String)this.getContext().get(VAL_CONTEXT_TARGET_KEY);
        return VAL_CONTEXT_TARGET_GENERATION.equals(target);
    }

    protected List<ICustomValidator> getCustomValidators() {
        return ICustomValidator.Registry.INSTANCE.get(this.languageName);
    }

    public void register(EValidatorRegistrar registrar) {
    }

    protected List<EPackage> getEPackages() {
        return super.getEPackages();
    }

    protected boolean acceptResource(EObject source) {
        return source == null || this.getCurrentObject() == null || source.eResource() == this.getCurrentObject().eResource();
    }

    public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        if (this.acceptResource(object)) {
            super.acceptError(message, object, feature, index, code, issueData);
        }
    }

    public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        if (this.acceptResource(object)) {
            super.acceptInfo(message, object, feature, index, code, issueData);
        }
    }

    public void acceptError(String message, EObject object, int offset, int length, String code, String ... issueData) {
        if (this.acceptResource(object)) {
            super.acceptError(message, object, offset, length, code, issueData);
        }
    }

    public void acceptInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
        if (this.acceptResource(object)) {
            super.acceptInfo(message, object, offset, length, code, issueData);
        }
    }

    public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        if (this.acceptResource(object)) {
            super.acceptWarning(message, object, feature, index, code, issueData);
        }
    }

    public void acceptWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
        if (this.acceptResource(object)) {
            super.acceptWarning(message, object, offset, length, code, issueData);
        }
    }

    public static class StandaloneValidatorExtension
    extends ArrayList<String> {
    }

    public static class ValidationContextImpl
    implements ICustomValidator.ValidationContext {
        private boolean isStandalone;
        private boolean isGeneration;
        private CheckMode mode;

        public ValidationContextImpl(boolean isStandalone, boolean isGeneration, CheckMode mode) {
            this.isStandalone = isStandalone;
            this.isGeneration = isGeneration;
            this.mode = mode;
        }

        @Override
        public boolean isStandalone() {
            return this.isStandalone;
        }

        @Override
        public boolean isGeneration() {
            return this.isGeneration;
        }

        @Override
        public CheckMode getCheckMode() {
            return this.mode;
        }
    }

    public static class RegistryImpl
    implements ICustomValidator.Registry {
        private Map<String, List<ICustomValidator>> map = Maps.newHashMap();

        @Override
        public void add(String language, ICustomValidator validator) {
            if (!this.map.containsKey(language)) {
                this.map.put(language, new ArrayList());
            }
            List<ICustomValidator> registered = this.map.get(language);
            boolean alreadyRegistered = false;
            for (ICustomValidator v : registered) {
                alreadyRegistered |= v.getClass().equals(validator.getClass());
            }
            if (!alreadyRegistered) {
                registered.add(validator);
            }
        }

        @Override
        public List<ICustomValidator> get(String language) {
            if (this.map.containsKey(language)) {
                return this.map.get(language);
            }
            return new ArrayList<ICustomValidator>();
        }
    }
}

