/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.validation;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.Property;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class ValidationHelpers {
    public static Iterable<NamedObject> removeUniques(List<NamedObject> items) {
        Iterable _xblockexpression = null;
        HashSet allOfName = CollectionLiterals.newHashSet();
        HashSet duplicateNames = CollectionLiterals.newHashSet();
        for (NamedObject i : items) {
            boolean _contains = allOfName.contains(i.getName());
            if (_contains) {
                duplicateNames.add(i.getName());
                continue;
            }
            allOfName.add(i.getName());
        }
        Functions.Function1 _function = i_1 -> duplicateNames.contains(i_1.getName());
        _xblockexpression = IterableExtensions.filter(items, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public static Iterable<NamedObject> inSameResource(Iterable<NamedObject> items, Resource resource) {
        Functions.Function1 _function = i -> {
            Resource _eResource = i.getObj().eResource();
            return Objects.equal((Object)_eResource, (Object)resource);
        };
        return IterableExtensions.filter(items, (Functions.Function1)_function);
    }

    public static <E extends EObject> void saveRecursiveVisitor(E start, Function<E, E> function) {
        HashSet visited = CollectionLiterals.newHashSet();
        Object next = start;
        while (next != null && !next.eIsProxy() && visited.add(next)) {
            next = (EObject)function.apply(next);
        }
    }

    public static class NamedObjectList
    extends ArrayList<NamedObject> {
        public void addAll(List<? extends EObject> items, EStructuralFeature feature) {
            Consumer<EObject> _function = it -> {
                Object _eGet = it.eGet(feature);
                NamedObject _namedObject = new NamedObject((String)_eGet, (EObject)it, feature);
                this.add(_namedObject);
            };
            items.forEach(_function);
        }
    }

    public static class NamedObject {
        @Property
        private String _name;
        @Property
        private EObject _obj;
        @Property
        private EStructuralFeature _feature;

        public NamedObject(String name, EObject obj, EStructuralFeature feature) {
            this.setName(name);
            this.setObj(obj);
            this.setFeature(feature);
        }

        @Pure
        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        @Pure
        public EObject getObj() {
            return this._obj;
        }

        public void setObj(EObject obj) {
            this._obj = obj;
        }

        @Pure
        public EStructuralFeature getFeature() {
            return this._feature;
        }

        public void setFeature(EStructuralFeature feature) {
            this._feature = feature;
        }
    }
}

