/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.etricegen.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DelegatingEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ETriceGenPackage;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.OptionalActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.WiredStructureClass;
import org.eclipse.etrice.core.genmodel.util.RoomCrossReferencer;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;

public class RootImpl
extends EObjectImpl
implements Root {
    private HashMap<ActorClass, BasicEList<ActorClass>> subClasses = new HashMap();
    protected static final boolean LIBRARY_EDEFAULT = false;
    protected boolean library = false;
    protected EList<SystemInstance> systemInstances;
    protected EList<SubSystemInstance> ownSubSystemInstances;
    protected EList<RoomModel> models;
    protected EList<RoomModel> importedModels;
    protected EList<ExpandedActorClass> xpActorClasses;
    protected EList<OptionalActorInstance> optionalInstances;
    protected EList<ActorClass> optionalActorClasses;
    protected EList<WiredStructureClass> wiredInstances;
    private BasicEList<SubSystemClass> subSystemClasses = null;
    private RoomCrossReferencer crossReferencer = new RoomCrossReferencer();
    private BasicEList<DataClass> dataClasses = null;
    private BasicEList<EnumerationType> enumClasses = null;
    private BasicEList<ProtocolClass> protocolClasses = null;
    private BasicEList<ActorClass> actorClasses = null;

    protected RootImpl() {
    }

    protected EClass eStaticClass() {
        return ETriceGenPackage.Literals.ROOT;
    }

    @Override
    public EList<SubSystemInstance> getSubSystemInstances() {
        if (this.getOwnSubSystemInstances().isEmpty()) {
            ArrayList<SubSystemInstance> result = new ArrayList<SubSystemInstance>();
            for (SystemInstance si : this.getSystemInstances()) {
                result.addAll((Collection<SubSystemInstance>)si.getInstances());
            }
            return new DelegatingEList.UnmodifiableEList(result);
        }
        return new DelegatingEList.UnmodifiableEList(this.getOwnSubSystemInstances());
    }

    @Override
    public EList<RoomModel> getModels() {
        if (this.models == null) {
            this.models = new EObjectResolvingEList(RoomModel.class, (InternalEObject)this, 4);
        }
        return this.models;
    }

    @Override
    public EList<RoomModel> getImportedModels() {
        if (this.importedModels == null) {
            this.importedModels = new EObjectResolvingEList(RoomModel.class, (InternalEObject)this, 5);
        }
        return this.importedModels;
    }

    @Override
    public EList<ExpandedActorClass> getXpActorClasses() {
        if (this.xpActorClasses == null) {
            this.xpActorClasses = new EObjectContainmentEList(ExpandedActorClass.class, (InternalEObject)this, 6);
        }
        return this.xpActorClasses;
    }

    @Override
    public EList<DataClass> getDataClasses() {
        if (this.dataClasses == null) {
            this.computeUsedClasses();
        }
        return this.dataClasses;
    }

    @Override
    public EList<EnumerationType> getEnumClasses() {
        if (this.enumClasses == null) {
            this.computeUsedClasses();
        }
        return this.enumClasses;
    }

    @Override
    public EList<ProtocolClass> getProtocolClasses() {
        if (this.protocolClasses == null) {
            this.computeUsedClasses();
        }
        return this.protocolClasses;
    }

    @Override
    public EList<ActorClass> getActorClasses() {
        if (this.actorClasses == null) {
            this.computeUsedClasses();
        }
        return this.actorClasses;
    }

    @Override
    public EList<SubSystemClass> getSubSystemClasses() {
        if (this.subSystemClasses == null) {
            this.collectSubSystems();
        }
        return this.subSystemClasses;
    }

    @Override
    public EList<OptionalActorInstance> getOptionalInstances() {
        if (this.optionalInstances == null) {
            this.optionalInstances = new EObjectContainmentEList(OptionalActorInstance.class, (InternalEObject)this, 12);
        }
        return this.optionalInstances;
    }

    @Override
    public EList<ActorClass> getOptionalActorClasses() {
        if (this.optionalActorClasses == null) {
            this.optionalActorClasses = new EObjectResolvingEList(ActorClass.class, (InternalEObject)this, 13);
        }
        return this.optionalActorClasses;
    }

    @Override
    public EList<WiredStructureClass> getWiredInstances() {
        if (this.wiredInstances == null) {
            this.wiredInstances = new EObjectContainmentEList(WiredStructureClass.class, (InternalEObject)this, 14);
        }
        return this.wiredInstances;
    }

    private void collectSubSystems() {
        this.subSystemClasses = new BasicEList();
        if (!this.getModels().isEmpty()) {
            for (RoomModel mdl : this.getModels()) {
                this.subSystemClasses.addAll((Collection)mdl.getSubSystemClasses());
            }
        }
    }

    @Override
    public boolean isLibrary() {
        return this.library;
    }

    @Override
    public void setLibrary(boolean newLibrary) {
        boolean oldLibrary = this.library;
        this.library = newLibrary;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldLibrary, this.library));
        }
    }

    @Override
    public EList<SystemInstance> getSystemInstances() {
        if (this.systemInstances == null) {
            this.systemInstances = new EObjectContainmentEList(SystemInstance.class, (InternalEObject)this, 1);
        }
        return this.systemInstances;
    }

    @Override
    public EList<SubSystemInstance> getOwnSubSystemInstances() {
        if (this.ownSubSystemInstances == null) {
            this.ownSubSystemInstances = new EObjectContainmentEList(SubSystemInstance.class, (InternalEObject)this, 2);
        }
        return this.ownSubSystemInstances;
    }

    @Override
    public EList<RoomModel> getReferencedModels(RoomClass cls) {
        Set<RoomModel> models = this.crossReferencer.getReferencedModels(cls);
        BasicEList result = new BasicEList(models);
        RoomModelComparator comp = new RoomModelComparator();
        Collections.sort(result, comp);
        return result;
    }

    @Override
    public EList<ProtocolClass> getReferencedProtocolClasses(RoomClass rc) {
        Set<ProtocolClass> protocolClasses = this.crossReferencer.getReferencedProtocolClasses(rc);
        BasicEList result = new BasicEList(protocolClasses);
        RoomClassComparator comp = new RoomClassComparator();
        Collections.sort(result, comp);
        return result;
    }

    @Override
    public EList<DataClass> getReferencedDataClasses(RoomClass rc) {
        return new BasicEList(this.crossReferencer.getReferencedDataClasses(rc));
    }

    @Override
    public EList<EnumerationType> getReferencedEnumClasses(RoomClass rc) {
        return new BasicEList(this.crossReferencer.getReferencedEnumClasses(rc));
    }

    @Override
    public EList<ActorClass> getReferencedActorClasses(RoomClass rc) {
        return new BasicEList(this.crossReferencer.getReferencedActorClasses(rc));
    }

    @Override
    public ExpandedActorClass getExpandedActorClass(ActorInstance ai) {
        for (ExpandedActorClass xpac : this.getXpActorClasses()) {
            if (xpac.getActorClass() != ai.getActorClass()) continue;
            return xpac;
        }
        return null;
    }

    @Override
    public ExpandedActorClass getExpandedActorClass(ActorClass ac) {
        for (ExpandedActorClass xpac : this.getXpActorClasses()) {
            if (xpac.getActorClass() != ac) continue;
            return xpac;
        }
        return null;
    }

    @Override
    public StructureInstance getInstance(String path) {
        if (!path.startsWith(Character.toString('/'))) {
            return null;
        }
        String[] segments = (path = path.substring(1)).split(Character.toString('/'));
        if (segments.length <= 1) {
            return null;
        }
        String seg = segments[0];
        for (SystemInstance si : this.getSystemInstances()) {
            if (!si.getName().equals(seg)) continue;
            seg = segments[1];
            for (SubSystemInstance ssi : si.getInstances()) {
                if (!ssi.getName().equals(seg)) continue;
                StructureInstance inst = ssi;
                int i = 2;
                while (i < segments.length && inst != null) {
                    boolean found = false;
                    for (AbstractInstance ai : inst.getInstances()) {
                        if (!ai.getName().equals(segments[i])) continue;
                        if (!(ai instanceof StructureInstance)) {
                            return null;
                        }
                        inst = (StructureInstance)ai;
                        ++i;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return null;
                }
                return inst;
            }
        }
        return null;
    }

    @Override
    public EList<ActorClass> getSubClasses(ActorClass ac) {
        BasicEList subCls = this.subClasses.get(ac);
        if (subCls == null) {
            subCls = new BasicEList();
        }
        return subCls;
    }

    @Override
    public void computeSubClasses() {
        for (RoomModel mdl : this.getModels()) {
            for (ActorClass ac : mdl.getActorClasses()) {
                for (ActorClass base = ac.getActorBase(); base != null; base = base.getActorBase()) {
                    BasicEList subs = this.subClasses.get(base);
                    if (subs == null) {
                        subs = new BasicEList();
                        this.subClasses.put(base, (BasicEList<ActorClass>)subs);
                    }
                    subs.add((Object)ac);
                }
            }
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getSystemInstances()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOwnSubSystemInstances()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getXpActorClasses()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getOptionalInstances()).basicRemove((Object)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getWiredInstances()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isLibrary();
            }
            case 1: {
                return this.getSystemInstances();
            }
            case 2: {
                return this.getOwnSubSystemInstances();
            }
            case 3: {
                return this.getSubSystemInstances();
            }
            case 4: {
                return this.getModels();
            }
            case 5: {
                return this.getImportedModels();
            }
            case 6: {
                return this.getXpActorClasses();
            }
            case 7: {
                return this.getDataClasses();
            }
            case 8: {
                return this.getProtocolClasses();
            }
            case 9: {
                return this.getActorClasses();
            }
            case 10: {
                return this.getEnumClasses();
            }
            case 11: {
                return this.getSubSystemClasses();
            }
            case 12: {
                return this.getOptionalInstances();
            }
            case 13: {
                return this.getOptionalActorClasses();
            }
            case 14: {
                return this.getWiredInstances();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setLibrary((Boolean)newValue);
                return;
            }
            case 1: {
                this.getSystemInstances().clear();
                this.getSystemInstances().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnSubSystemInstances().clear();
                this.getOwnSubSystemInstances().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getModels().clear();
                this.getModels().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getImportedModels().clear();
                this.getImportedModels().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getXpActorClasses().clear();
                this.getXpActorClasses().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getDataClasses().clear();
                this.getDataClasses().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getProtocolClasses().clear();
                this.getProtocolClasses().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getActorClasses().clear();
                this.getActorClasses().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getEnumClasses().clear();
                this.getEnumClasses().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getSubSystemClasses().clear();
                this.getSubSystemClasses().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getOptionalInstances().clear();
                this.getOptionalInstances().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getOptionalActorClasses().clear();
                this.getOptionalActorClasses().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getWiredInstances().clear();
                this.getWiredInstances().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setLibrary(false);
                return;
            }
            case 1: {
                this.getSystemInstances().clear();
                return;
            }
            case 2: {
                this.getOwnSubSystemInstances().clear();
                return;
            }
            case 4: {
                this.getModels().clear();
                return;
            }
            case 5: {
                this.getImportedModels().clear();
                return;
            }
            case 6: {
                this.getXpActorClasses().clear();
                return;
            }
            case 7: {
                this.getDataClasses().clear();
                return;
            }
            case 8: {
                this.getProtocolClasses().clear();
                return;
            }
            case 9: {
                this.getActorClasses().clear();
                return;
            }
            case 10: {
                this.getEnumClasses().clear();
                return;
            }
            case 11: {
                this.getSubSystemClasses().clear();
                return;
            }
            case 12: {
                this.getOptionalInstances().clear();
                return;
            }
            case 13: {
                this.getOptionalActorClasses().clear();
                return;
            }
            case 14: {
                this.getWiredInstances().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.library;
            }
            case 1: {
                return this.systemInstances != null && !this.systemInstances.isEmpty();
            }
            case 2: {
                return this.ownSubSystemInstances != null && !this.ownSubSystemInstances.isEmpty();
            }
            case 3: {
                return !this.getSubSystemInstances().isEmpty();
            }
            case 4: {
                return this.models != null && !this.models.isEmpty();
            }
            case 5: {
                return this.importedModels != null && !this.importedModels.isEmpty();
            }
            case 6: {
                return this.xpActorClasses != null && !this.xpActorClasses.isEmpty();
            }
            case 7: {
                return !this.getDataClasses().isEmpty();
            }
            case 8: {
                return !this.getProtocolClasses().isEmpty();
            }
            case 9: {
                return !this.getActorClasses().isEmpty();
            }
            case 10: {
                return !this.getEnumClasses().isEmpty();
            }
            case 11: {
                return !this.getSubSystemClasses().isEmpty();
            }
            case 12: {
                return this.optionalInstances != null && !this.optionalInstances.isEmpty();
            }
            case 13: {
                return this.optionalActorClasses != null && !this.optionalActorClasses.isEmpty();
            }
            case 14: {
                return this.wiredInstances != null && !this.wiredInstances.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (library: ");
        result.append(this.library);
        result.append(')');
        return result.toString();
    }

    private void computeUsedClasses() {
        this.dataClasses = new BasicEList();
        this.enumClasses = new BasicEList();
        this.protocolClasses = new BasicEList();
        this.actorClasses = new BasicEList();
        this.subSystemClasses = new BasicEList();
        for (RoomModel mdl : this.getModels()) {
            this.dataClasses.addAll((Collection)mdl.getDataClasses());
            this.enumClasses.addAll((Collection)mdl.getEnumerationTypes());
            for (GeneralProtocolClass gpc : mdl.getProtocolClasses()) {
                if (!(gpc instanceof ProtocolClass)) continue;
                this.protocolClasses.add((Object)((ProtocolClass)gpc));
            }
            this.actorClasses.addAll((Collection)mdl.getActorClasses());
            this.subSystemClasses.addAll((Collection)mdl.getSubSystemClasses());
        }
    }

    private class RoomModelComparator
    implements Comparator<RoomModel> {
        private RoomModelComparator() {
        }

        @Override
        public int compare(RoomModel o1, RoomModel o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class RoomClassComparator
    implements Comparator<RoomClass> {
        private RoomClassComparator() {
        }

        @Override
        public int compare(RoomClass o1, RoomClass o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

