/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.common.base.Documentation;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.converter.BaseConverterService;
import org.eclipse.etrice.core.common.converter.CCStringConverter;
import org.eclipse.etrice.core.common.formatting2.BaseFormatter;
import org.eclipse.etrice.core.common.formatting2.CCStringReplacer;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.ProtocolSemantics;
import org.eclipse.etrice.core.fsm.fSM.SemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.services.FSMGrammarAccess;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FSMFormatter
extends BaseFormatter {
    @Inject
    @Extension
    private FSMGrammarAccess _fSMGrammarAccess;
    @Inject
    private BaseConverterService converterService;

    public void formatAllByKeywords(EObject it, @Extension IFormattableDocument document) {
        super.formatAllByKeywords(it, document);
        Consumer<ISemanticRegion> _function = it_1 -> {
            Procedures.Procedure1 _function_1 = it_2 -> it_2.oneSpace();
            document.surround(it_1, _function_1);
        };
        this.textRegionExtensions.allRegionsFor(it).keywords(new String[]{"->", "extends", "=", "or", "|"}).forEach(_function);
    }

    protected EObject prependDefaultNewLines(EObject it, @Extension IFormattableDocument document) {
        EObject _xifexpression = null;
        if (this.textRegionExtensions.previousHiddenRegion(it) != null && this.textRegionExtensions.previousHiddenRegion(it).getLineCount() > 2) {
            Procedures.Procedure1 _function = it_1 -> it_1.setNewLines(2);
            _xifexpression = document.prepend(it, _function);
        } else {
            Procedures.Procedure1 _function_1 = it_1 -> it_1.newLine();
            _xifexpression = document.prepend(it, _function_1);
        }
        return _xifexpression;
    }

    protected ISemanticRegion prependDefaultNewLines(ISemanticRegion it, @Extension IFormattableDocument document) {
        boolean _greaterThan;
        ISemanticRegion _xifexpression = null;
        int _lineCount = it.getPreviousHiddenRegion().getLineCount();
        boolean bl = _greaterThan = _lineCount > 2;
        if (_greaterThan) {
            Procedures.Procedure1 _function = it_1 -> it_1.setNewLines(2);
            _xifexpression = document.prepend(it, _function);
        } else {
            Procedures.Procedure1 _function_1 = it_1 -> it_1.newLine();
            _xifexpression = document.prepend(it, _function_1);
        }
        return _xifexpression;
    }

    protected void _format(StateGraph it, @Extension IFormattableDocument document) {
        Consumer<EObject> _function = it_1 -> this.prependDefaultNewLines((EObject)it_1, document);
        it.eContents().forEach(_function);
        Consumer<EObject> _function_1 = it_1 -> document.format(it_1);
        it.eContents().forEach(_function_1);
    }

    protected void _format(State it, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it_1 -> {
            this.prependDefaultNewLines((ISemanticRegion)it_1, document);
            Procedures.Procedure1 _function_1 = it_2 -> it_2.oneSpace();
            document.append(it_1, _function_1);
        };
        this.textRegionExtensions.regionFor((EObject)it).keywords(new String[]{"entry", "exit", "do", "subgraph"}).forEach(_function);
        Consumer<EObject> _function_1 = it_1 -> document.format(it_1);
        it.eContents().forEach(_function_1);
    }

    protected void _format(TransitionBase it, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it_1 -> {
            this.prependDefaultNewLines((ISemanticRegion)it_1, document);
            Procedures.Procedure1 _function_1 = it_2 -> it_2.oneSpace();
            document.append(it_1, _function_1);
        };
        this.textRegionExtensions.regionFor((EObject)it).keywords(new String[]{"action", "guard", "cond", "triggers"}).forEach(_function);
        if (it instanceof TriggeredTransition) {
            Procedures.Procedure1 _function_1 = it_1 -> it_1.newLine();
            document.prepend((EObject)IterableExtensions.head(((TriggeredTransition)it).getTriggers()), _function_1);
            Consumer<Trigger> _function_2 = it_1 -> {
                Procedures.Procedure1 _function_3 = it_2 -> it_2.oneSpace();
                document.prepend((EObject)it_1, _function_3);
            };
            IterableExtensions.tail(((TriggeredTransition)it).getTriggers()).forEach(_function_2);
        }
        Consumer<EObject> _function_3 = it_1 -> document.format(it_1);
        it.eContents().forEach(_function_3);
    }

    protected void _format(Trigger it, @Extension IFormattableDocument document) {
        Consumer<Pair> _function = it_1 -> {
            Procedures.Procedure1 _function_1 = it_2 -> it_2.noSpace();
            document.interior(it_1, _function_1);
        };
        this.textRegionExtensions.regionFor((EObject)it).keywordPairs("<", ">").forEach(_function);
        Consumer<EObject> _function_1 = it_1 -> document.format(it_1);
        it.eContents().forEach(_function_1);
    }

    protected void _format(ProtocolSemantics it, @Extension IFormattableDocument document) {
        Consumer<SemanticsRule> _function = it_1 -> this.prependDefaultNewLines((EObject)it_1, document);
        it.getRules().forEach(_function);
        Consumer<EObject> _function_1 = it_1 -> document.format(it_1);
        it.eContents().forEach(_function_1);
    }

    protected void _format(DetailCode detailcode, @Extension IFormattableDocument document) {
        ISemanticRegion ccRegion = this.textRegionExtensions.regionFor((EObject)detailcode).assignment(this._fSMGrammarAccess.getDetailCodeAccess().getLinesAssignment_0_1());
        if (ccRegion != null) {
            Procedures.Procedure1 _function = it -> it.oneSpace();
            document.prepend((EObject)detailcode, _function);
            boolean _isMultiline = this.textRegionExtensions.isMultiline((EObject)detailcode);
            if (_isMultiline) {
                CCStringConverter _cC_StringConverter = this.converterService.getCC_StringConverter();
                CCStringReplacer _cCStringReplacer = new CCStringReplacer(document, (ITextSegment)ccRegion, _cC_StringConverter);
                document.addReplacer((ITextReplacer)_cCStringReplacer);
            }
        } else {
            Consumer<ISemanticRegion> _function_1 = it -> {
                Procedures.Procedure1 _function_2 = it_1 -> it_1.newLine();
                document.prepend(it, _function_2);
            };
            this.textRegionExtensions.regionFor((EObject)detailcode).assignments(new Assignment[]{this._fSMGrammarAccess.getDetailCodeAccess().getLinesAssignment_1_1()}).forEach(_function_1);
        }
    }

    public void format(Object it, IFormattableDocument document) {
        if (it instanceof State) {
            this._format((State)it, document);
            return;
        }
        if (it instanceof XtextResource) {
            this._format((XtextResource)it, document);
            return;
        }
        if (it instanceof TransitionBase) {
            this._format((TransitionBase)it, document);
            return;
        }
        if (it instanceof Annotation) {
            this._format((Annotation)it, document);
            return;
        }
        if (it instanceof AnnotationType) {
            this._format((AnnotationType)it, document);
            return;
        }
        if (it instanceof Documentation) {
            this._format((Documentation)it, document);
            return;
        }
        if (it instanceof Import) {
            this._format((Import)it, document);
            return;
        }
        if (it instanceof DetailCode) {
            this._format((DetailCode)it, document);
            return;
        }
        if (it instanceof ProtocolSemantics) {
            this._format((ProtocolSemantics)it, document);
            return;
        }
        if (it instanceof StateGraph) {
            this._format((StateGraph)it, document);
            return;
        }
        if (it instanceof Trigger) {
            this._format((Trigger)it, document);
            return;
        }
        if (it instanceof EObject) {
            this._format((EObject)it, document);
            return;
        }
        if (it == null) {
            this._format(null, document);
            return;
        }
        if (it != null) {
            this._format(it, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, document).toString());
    }
}

