/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ComplexType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.Initialization;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class DataClassGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private Initialization _initialization;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    private RoomHelpers roomHelpers;

    public void doGenerate(Root root) {
        Functions.Function1 _function = it -> {
            boolean _isDeprecatedGeneration = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !_isDeprecatedGeneration;
        };
        Consumer<DataClass> _function_1 = dc -> {
            String path = this._roomExtensions.getPath((RoomClass)dc);
            String file = this._javaExtensions.getJavaFileName((RoomClass)dc);
            this.fileIO.generateFile("generating DataClass implementation", path + file, this.generate(root, (DataClass)dc));
        };
        IterableExtensions.filter((Iterable)root.getDataClasses(), (Functions.Function1)_function).forEach(_function_1);
    }

    public CharSequence generate(Root root, DataClass dc) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _package = this._roomExtensions.getPackage((RoomClass)dc);
        _builder.append(_package);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import static org.eclipse.etrice.runtime.java.etunit.EtUnit.*;");
        _builder.newLine();
        _builder.append("import java.io.Serializable;");
        _builder.newLine();
        _builder.append("import java.util.Objects;");
        _builder.newLine();
        _builder.newLine();
        EList models = root.getReferencedModels((RoomClass)dc);
        _builder.newLineIfNotEmpty();
        for (RoomModel model : models) {
            _builder.append("import ");
            String _name = model.getName();
            _builder.append(_name);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(dc, 1);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        String _name_1 = dc.getName();
        _builder.append(_name_1);
        DataClass _base = dc.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            _builder.append(" extends ");
            String _name_2 = dc.getBase().getName();
            _builder.append(_name_2);
        }
        _builder.append(" implements Serializable {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final long serialVersionUID = ");
        String _package_1 = this._roomExtensions.getPackage((RoomClass)dc);
        String _name_3 = dc.getName();
        int _hashCode = (_package_1 + _name_3).hashCode();
        _builder.append((Object)_hashCode, "\t");
        _builder.append("L;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode(dc, 2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this._procedureHelpers.attributes((List)dc.getAttributes());
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributeSettersGettersImplementation = this._procedureHelpers.attributeSettersGettersImplementation((List)dc.getAttributes(), dc.getName());
        _builder.append((Object)_attributeSettersGettersImplementation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation((List)dc.getOperations(), dc.getName());
        _builder.append((Object)_operationsImplementation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// default constructor");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _name_4 = dc.getName();
        _builder.append(_name_4, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _attributeInitialization = this._initialization.attributeInitialization((List<Attribute>)dc.getAttributes(), (EObject)dc, true);
        _builder.append((Object)_attributeInitialization, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        String _userStructorBody = this._procedureHelpers.userStructorBody((RoomClass)dc, true);
        _builder.append(_userStructorBody, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// constructor using fields");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _name_5 = dc.getName();
        _builder.append(_name_5, "\t");
        _builder.append("(");
        String _argList = this.argList(dc);
        _builder.append(_argList, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        DataClass _base_1 = dc.getBase();
        boolean bl2 = _tripleNotEquals_1 = _base_1 != null;
        if (_tripleNotEquals_1) {
            _builder.append("\t\t");
            _builder.append("super(");
            String _paramList = this.paramList(dc.getBase());
            _builder.append(_paramList, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t");
            _builder.append("super();");
            _builder.newLine();
        }
        _builder.newLine();
        EList _attributes_1 = dc.getAttributes();
        for (Attribute a : _attributes_1) {
            _builder.append("\t\t");
            _builder.append("this.");
            String _name_6 = a.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append(" = ");
            String _name_7 = a.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        String _userStructorBody_1 = this._procedureHelpers.userStructorBody((RoomClass)dc, true);
        _builder.append(_userStructorBody_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// deep copy");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _name_8 = dc.getName();
        _builder.append(_name_8, "\t");
        _builder.append(" deepCopy() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _name_9 = dc.getName();
        _builder.append(_name_9, "\t\t");
        _builder.append(" copy = new ");
        String _name_10 = dc.getName();
        _builder.append(_name_10, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _deepCopy = this.deepCopy(dc);
        _builder.append(_deepCopy, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return copy;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// deep equals");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _deepEquals = this.deepEquals(dc);
        _builder.append((Object)_deepEquals, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// deep hashCode");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _deepHashCode = this.deepHashCode(dc);
        _builder.append((Object)_deepHashCode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    public String paramList(DataClass _dc) {
        String result = "";
        DataClass dc = _dc;
        while (dc != null) {
            String _plus;
            String _string = this.paramList((List<Attribute>)dc.getAttributes()).toString();
            result = _plus = _string + result;
            if ((dc = dc.getBase()) == null) continue;
            result = ", " + result;
        }
        return result;
    }

    private CharSequence paramList(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : attributes) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name = a.getName();
            _builder.append(_name);
        }
        return _builder;
    }

    public String argList(DataClass dc) {
        return this._procedureHelpers.argList((Iterable)this.roomHelpers.getAllAttributes(dc));
    }

    private String deepCopy(DataClass _dc) {
        String result = "";
        for (DataClass dc = _dc; dc != null; dc = dc.getBase()) {
            String _plus;
            String _string = this.deepCopy((List<Attribute>)dc.getAttributes()).toString();
            result = _plus = _string + result;
        }
        return result;
    }

    private CharSequence deepCopy(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        for (Attribute a : attributes) {
            boolean _equals;
            boolean _isRef = a.getType().isRef();
            if (_isRef) {
                _builder.append("copy.");
                String _name = a.getName();
                _builder.append(_name);
                _builder.append(" = ");
                String _name_1 = a.getName();
                _builder.append(_name_1);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            DataType _type = a.getType().getType();
            if (_type instanceof ComplexType) {
                boolean _lessEqualsThan;
                _builder.append("if (");
                String _name_2 = a.getName();
                _builder.append(_name_2);
                _builder.append("!=null) {");
                _builder.newLineIfNotEmpty();
                int _size = a.getSize();
                boolean bl = _lessEqualsThan = _size <= 1;
                if (_lessEqualsThan) {
                    _builder.append("\t");
                    _builder.append("copy.");
                    String _name_3 = a.getName();
                    _builder.append(_name_3, "\t");
                    _builder.append(" = ");
                    String _name_4 = a.getName();
                    _builder.append(_name_4, "\t");
                    _builder.append(".deepCopy();");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("for (int i=0;i<");
                    String _name_5 = a.getName();
                    _builder.append(_name_5, "\t");
                    _builder.append(".length;i++){");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("copy.");
                    String _name_6 = a.getName();
                    _builder.append(_name_6, "\t\t");
                    _builder.append("[i] = ");
                    String _name_7 = a.getName();
                    _builder.append(_name_7, "\t\t");
                    _builder.append("[i].deepCopy();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("}");
                _builder.newLine();
                continue;
            }
            int _size_1 = a.getSize();
            boolean bl = _equals = _size_1 == 0;
            if (_equals) {
                _builder.append("copy.");
                String _name_8 = a.getName();
                _builder.append(_name_8);
                _builder.append(" = ");
                String _name_9 = a.getName();
                _builder.append(_name_9);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("for (int i=0;i<");
            String _name_10 = a.getName();
            _builder.append(_name_10);
            _builder.append(".length;i++){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("copy.");
            String _name_11 = a.getName();
            _builder.append(_name_11, "\t");
            _builder.append("[i] = ");
            String _name_12 = a.getName();
            _builder.append(_name_12, "\t");
            _builder.append("[i];");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence deepEquals(DataClass it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public boolean equals(Object other) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (this == other) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(other == null || this.getClass() != other.getClass()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        String _name = it.getName();
        _builder.append(_name, "\t");
        _builder.append(" casted = (");
        String _name_1 = it.getName();
        _builder.append(_name_1, "\t");
        _builder.append(") other;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        Functions.Function1 _function = attr -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Objects.deepEquals(this.");
            String _name_2 = attr.getName();
            _builder_1.append(_name_2);
            _builder_1.append(", casted.");
            String _name_3 = attr.getName();
            _builder_1.append(_name_3);
            _builder_1.append(")");
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)this.roomHelpers.getAllAttributes(it), (Functions.Function1)_function), (CharSequence)" && ");
        _builder.append(_join, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence deepHashCode(DataClass it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public int hashCode() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return Objects.hash(");
        Functions.Function1 _function = attr -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("this.");
            String _name = attr.getName();
            _builder_1.append(_name);
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)this.roomHelpers.getAllAttributes(it), (Functions.Function1)_function), (CharSequence)", ");
        _builder.append(_join, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

