/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EnumerationTypeGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;

    public void doGenerate(Root root) {
        Functions.Function1 _function = it -> {
            boolean _isDeprecatedGeneration = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !_isDeprecatedGeneration;
        };
        Consumer<EnumerationType> _function_1 = et -> {
            String path = this._roomExtensions.getPath((RoomClass)et);
            String file = this._javaExtensions.getJavaFileName((RoomClass)et);
            this.fileIO.generateFile("generating Enumeration implementation", path + file, this.generate(root, (EnumerationType)et));
        };
        IterableExtensions.filter((Iterable)root.getEnumClasses(), (Functions.Function1)_function).forEach(_function_1);
    }

    public CharSequence generate(Root root, EnumerationType et) {
        StringConcatenation _xblockexpression = null;
        String type = this._javaExtensions.getTargetType(et);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _package = this._roomExtensions.getPackage((RoomClass)et);
        _builder.append(_package);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public interface ");
        String _name = et.getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        EList _literals = et.getLiterals();
        for (EnumLiteral lit : _literals) {
            _builder.append("\t");
            _builder.append("static final ");
            _builder.append(type, "\t");
            _builder.append(" ");
            String _name_1 = lit.getName();
            _builder.append(_name_1, "\t");
            _builder.append(" = ");
            long _literalValue = lit.getLiteralValue();
            _builder.append((Object)_literalValue, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

