/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class Initialization {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private TypeHelpers typeHelpers;
    @Inject
    @Extension
    private JavaExtensions languageExt;
    @Inject
    @Extension
    private ProcedureHelpers procedureHelpers;

    public CharSequence attributeInitialization(List<Attribute> attribs, EObject roomClass, boolean useClassDefaultsOnly) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// initialize attributes");
        _builder.newLine();
        for (Attribute a : attribs) {
            CharSequence _attributeClassInit = this.attributeClassInit(a, roomClass, useClassDefaultsOnly);
            _builder.append((Object)_attributeClassInit);
            _builder.newLineIfNotEmpty();
            boolean _isDataClass = this.typeHelpers.isDataClass(a.getType().getType());
            if (_isDataClass) {
                CharSequence _attributeInitPrimitiveRec = this.attributeInitPrimitiveRec(this._roomExtensions.union(new ArrayList(), (Object)a), roomClass);
                _builder.append((Object)_attributeInitPrimitiveRec);
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence attributeClassInit(Attribute a, EObject roomClass, boolean useClassDefaultsOnly) {
        CharSequence _xifexpression_3;
        String value;
        CharSequence _xblockexpression_1;
        CharSequence _xblockexpression = null;
        DataType aType = a.getType().getType();
        CharSequence _switchResult = null;
        boolean _matched = false;
        boolean _isRef = a.getType().isRef();
        if (_isRef) {
            boolean _tripleNotEquals;
            _matched = true;
            CharSequence _xifexpression = null;
            String _defaultValueLiteral = a.getDefaultValueLiteral();
            boolean bl = _tripleNotEquals = _defaultValueLiteral != null;
            if (_tripleNotEquals) {
                _xifexpression = this.attributeInit(a, a.getDefaultValueLiteral());
            } else {
                CharSequence _xifexpression_1 = null;
                boolean _needsInitialization = this.languageExt.needsInitialization(a);
                if (_needsInitialization) {
                    _xifexpression_1 = this.attributeInit(a, this.languageExt.nullPointer());
                }
                _xifexpression = _xifexpression_1;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && aType instanceof PrimitiveType) {
            _matched = true;
            _xblockexpression_1 = null;
            value = this.getDataConfigValue(this._roomExtensions.union(new ArrayList(), (Object)a), roomClass);
            if (value == null) {
                value = a.getDefaultValueLiteral();
            }
            CharSequence _xifexpression_2 = null;
            if (value != null) {
                _xifexpression_2 = this.attributeInit(a, this.languageExt.toValueLiteral((PrimitiveType)aType, value));
            } else {
                _xifexpression_3 = null;
                if (!useClassDefaultsOnly || this.languageExt.needsInitialization(a)) {
                    _xifexpression_3 = this.attributeInit(a, this.languageExt.defaultValue(aType));
                }
                _xifexpression_2 = _xifexpression_3;
            }
            _switchResult = _xblockexpression_1 = _xifexpression_2;
        }
        if (!_matched && aType instanceof EnumerationType) {
            _matched = true;
            _xblockexpression_1 = null;
            value = this.getDataConfigValue(this._roomExtensions.union(new ArrayList(), (Object)a), roomClass);
            if (value == null) {
                value = a.getDefaultValueLiteral();
            }
            CharSequence _xifexpression_2 = null;
            if (value != null) {
                _xifexpression_2 = this.attributeInit(a, this.languageExt.toEnumLiteral((EnumerationType)aType, value));
            } else {
                _xifexpression_3 = null;
                if (!useClassDefaultsOnly || this.languageExt.needsInitialization(a)) {
                    _xifexpression_3 = this.attributeInit(a, this.languageExt.defaultValue(aType));
                }
                _xifexpression_2 = _xifexpression_3;
            }
            _switchResult = _xblockexpression_1 = _xifexpression_2;
        }
        if (!_matched) {
            _switchResult = this.attributeInit(a, this.languageExt.defaultValue(aType));
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private CharSequence attributeInitPrimitiveRec(List<Attribute> path, EObject roomClass) {
        Attribute a = (Attribute)IterableExtensions.last(path);
        DataType aType = a.getType().getType();
        boolean _matched = false;
        if (aType instanceof DataClass) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            List _allAttributes = this._roomHelpers.getAllAttributes((DataClass)aType);
            for (Attribute e : _allAttributes) {
                CharSequence _attributeInitPrimitiveRec = this.attributeInitPrimitiveRec(this._roomExtensions.union(path, (Object)e), roomClass);
                _builder.append((Object)_attributeInitPrimitiveRec);
                _builder.newLineIfNotEmpty();
            }
            return _builder;
        }
        if (!_matched && aType instanceof PrimitiveType) {
            _matched = true;
            String value = this.getDataConfigValue(path, roomClass);
            CharSequence _xifexpression = null;
            if (value != null) {
                _xifexpression = this.attributeInit(path, this.languageExt.toValueLiteral((PrimitiveType)aType, value));
            }
            return _xifexpression;
        }
        if (!_matched && aType instanceof EnumerationType) {
            _matched = true;
            String value = this.getDataConfigValue(path, roomClass);
            CharSequence _xifexpression = null;
            if (value != null) {
                _xifexpression = this.attributeInit(path, this.languageExt.toEnumLiteral((EnumerationType)aType, value));
            }
            return _xifexpression;
        }
        return null;
    }

    private CharSequence attributeInit(Attribute a, String value) {
        return this.attributeInit(this._roomExtensions.union(new ArrayList(), (Object)a), value);
    }

    private CharSequence attributeInit(List<Attribute> path, String value) {
        boolean _equals;
        String _xifexpression = null;
        int _size = path.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            _xifexpression = "this";
        } else {
            int _size_1 = path.size();
            int _minus = _size_1 - 1;
            _xifexpression = this.procedureHelpers.invokeGetters(IterableExtensions.take(path, (int)_minus), null).toString();
        }
        String getter = _xifexpression;
        return this.genAttributeInitializer((Attribute)IterableExtensions.last(path), value, getter);
    }

    public CharSequence genAttributeInitializer(Attribute a, String value, String invokes) {
        StringConcatenation _xblockexpression = null;
        DataType aType = a.getType().getType();
        StringConcatenation _builder = new StringConcatenation();
        if (a.getSize() == 0 || a.getSize() > 0 && "char".equals(this.typeHelpers.typeName(aType)) && !value.matches("'.'|\\(char\\).*")) {
            _builder.append(invokes);
            _builder.append(".");
            CharSequence _invokeSetter = this.procedureHelpers.invokeSetter(a.getName(), null, value);
            _builder.append((Object)_invokeSetter);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        } else if (!value.trim().startsWith("{") || "char".equals(this.typeHelpers.typeName(aType))) {
            boolean _not;
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            String _typeName = this.typeHelpers.typeName(aType);
            _builder.append(_typeName, "\t");
            _builder.append("[] array = new ");
            String _typeName_1 = this.typeHelpers.typeName(aType);
            _builder.append(_typeName_1, "\t");
            _builder.append("[");
            int _size = a.getSize();
            _builder.append((Object)_size, "\t");
            _builder.append("];");
            _builder.newLineIfNotEmpty();
            boolean bl = _not = !a.getType().isRef() || !this.typeHelpers.isPrimitive(aType);
            if (_not) {
                _builder.append("\t");
                _builder.append("for (int i=0;i<");
                int _size_1 = a.getSize();
                _builder.append((Object)_size_1, "\t");
                _builder.append(";i++){");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("array[i] = ");
                _builder.append(value, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append(invokes, "\t");
            _builder.append(".");
            CharSequence _invokeSetter_1 = this.procedureHelpers.invokeSetter(a.getName(), null, "array");
            _builder.append((Object)_invokeSetter_1, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append(invokes);
            _builder.append(".");
            String _name = a.getName();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("new ");
            String _typeName_2 = this.typeHelpers.typeName(aType);
            _builder_1.append(_typeName_2);
            _builder_1.append("[] ");
            _builder_1.append(value);
            CharSequence _invokeSetter_2 = this.procedureHelpers.invokeSetter(_name, null, _builder_1.toString());
            _builder.append((Object)_invokeSetter_2);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getDataConfigValue(List<Attribute> path, EObject roomClass) {
        String _switchResult = null;
        boolean _matched = false;
        if (roomClass instanceof ActorClass) {
            _matched = true;
            _switchResult = this.typeHelpers.getAttrClassConfigValue(path, (ActorClass)roomClass, false);
        }
        if (!_matched && roomClass instanceof PortClass) {
            _matched = true;
            _switchResult = this.typeHelpers.getAttrClassConfigValue(path, (PortClass)roomClass);
        }
        if (!_matched && roomClass instanceof DataClass) {
            _matched = true;
            _switchResult = null;
        }
        return _switchResult;
    }
}

