/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class JavaExtensions
implements ILanguageExtension {
    @Inject
    private TypeHelpers typeHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public String getTypedDataDefinition(EObject msg) {
        String _xifexpression = null;
        _xifexpression = msg instanceof Message ? this.generateArglistAndTypedData((EObject)((Message)msg).getData())[ILanguageExtensionBase.TypedDataKind.DECLARATION_AND_INITIALIZATION.ordinal()] : "";
        return _xifexpression;
    }

    public String getJavaFileName(RoomClass rc) {
        String _name = rc.getName();
        return _name + ".java";
    }

    public String getJavaFactoryName(ActorClass rc) {
        String _name = rc.getName();
        return _name + "Factory";
    }

    public String getJavaFactoryFileName(ActorClass rc) {
        String _javaFactoryName = this.getJavaFactoryName(rc);
        return _javaFactoryName + ".java";
    }

    public String getJavaScalarInterfaceName(ActorClass rc) {
        String _name = rc.getName();
        return _name + "Interface";
    }

    public String getJavaScalarInterfaceFileName(ActorClass rc) {
        String _javaScalarInterfaceName = this.getJavaScalarInterfaceName(rc);
        return _javaScalarInterfaceName + ".java";
    }

    public String getJavaReplicatedInterfaceName(ActorClass rc) {
        String _name = rc.getName();
        return _name + "ReplicatedInterface";
    }

    public String getJavaReplicatedInterfaceFileName(ActorClass rc) {
        String _javaReplicatedInterfaceName = this.getJavaReplicatedInterfaceName(rc);
        return _javaReplicatedInterfaceName + ".java";
    }

    public String getJavaInterfaceName(ActorClass ac, boolean replicated) {
        String _xifexpression = null;
        _xifexpression = replicated ? this.getJavaReplicatedInterfaceName(ac) : this.getJavaScalarInterfaceName(ac);
        return _xifexpression;
    }

    public String getJavaInterfaceFileName(ActorClass ac, boolean replicated) {
        String _xifexpression = null;
        _xifexpression = replicated ? this.getJavaReplicatedInterfaceFileName(ac) : this.getJavaScalarInterfaceFileName(ac);
        return _xifexpression;
    }

    public String getJavaClassName(NodeRef nr, SubSystemInstance ssi) {
        String _name = nr.getName();
        String _plus = "Node_" + _name;
        String _plus_1 = _plus + "_";
        String _name_1 = ssi.getName();
        return _plus_1 + _name_1;
    }

    public String getJavaFileName(NodeRef nr, SubSystemInstance ssi) {
        String _javaClassName = this.getJavaClassName(nr, ssi);
        return _javaClassName + ".java";
    }

    public String toWrapper(String type) {
        String _switchResult = null;
        if (type != null) {
            switch (type) {
                case "int": {
                    _switchResult = "Integer";
                    break;
                }
                case "char": {
                    _switchResult = "Character";
                    break;
                }
                default: {
                    _switchResult = StringExtensions.toFirstUpper((String)type);
                    break;
                }
            }
        } else {
            _switchResult = StringExtensions.toFirstUpper((String)type);
        }
        return _switchResult;
    }

    public boolean needsInitialization(Attribute a) {
        return a.getSize() > 0 || !this.typeHelpers.isEnumerationOrPrimitive(a.getType().getType()) || this.typeHelpers.typeName(a.getType().getType()).equals("String");
    }

    public String accessLevelPrivate() {
        return "private ";
    }

    public String accessLevelProtected() {
        return "protected ";
    }

    public String accessLevelPublic() {
        return "public ";
    }

    public String memberAccess() {
        return "this.";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        return "";
    }

    public String selfPointer(boolean hasArgs) {
        return "";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        return "";
    }

    public String scopeSeparator() {
        return ".";
    }

    public String memberInDeclaration(String namespace, String member) {
        return member;
    }

    public String memberInUse(String namespace, String member) {
        return namespace + "." + member;
    }

    public boolean usesInheritance() {
        return true;
    }

    public boolean usesPointers() {
        return false;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        StringConcatenation _builder = new StringConcatenation();
        for (Pair<String, String> entry : entries) {
            _builder.append("public static final int ");
            String _first = (String)entry.getFirst();
            _builder.append(_first);
            _builder.append(" = ");
            String _second = (String)entry.getSecond();
            _builder.append(_second);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public String booleanConstant(boolean b) {
        return Boolean.valueOf(b).toString();
    }

    public String pointerLiteral() {
        return "";
    }

    public String nullPointer() {
        return "null";
    }

    public String voidPointer() {
        return "Object";
    }

    public String arrayType(String type, int size, boolean isRef) {
        return type + "[]";
    }

    public String arrayDeclaration(String type, int size, boolean isRef, String name) {
        return type + " " + name + "[]";
    }

    public String superCall(String baseClassName, String method, String args) {
        return "super." + method + "(" + args + ");";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        String _xifexpression = null;
        if (!this.typeHelpers.isCharacterType(type) && (value.contains(",") || value.contains("{"))) {
            String _xblockexpression = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{ ");
            boolean _hasElements = false;
            for (String v : singleValues) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _castValue = this.castValue(type, v.trim());
                _builder.append(_castValue);
            }
            _builder.append(" }");
            _xifexpression = _xblockexpression = _builder.toString();
        } else {
            _xifexpression = this.castValue(type, value);
        }
        return _xifexpression;
    }

    public String toEnumLiteral(EnumerationType type, String value) {
        String _xifexpression = null;
        if (value.contains(",") || value.contains("{")) {
            String _xblockexpression = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{ ");
            boolean _hasElements = false;
            for (String v : singleValues) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _convertStringEnumLiteral = this.convertStringEnumLiteral(type, v.trim());
                _builder.append(_convertStringEnumLiteral);
            }
            _builder.append(" }");
            _xifexpression = _xblockexpression = _builder.toString();
        } else {
            _xifexpression = this.convertStringEnumLiteral(type, value);
        }
        return _xifexpression;
    }

    private String convertStringEnumLiteral(EnumerationType type, String value) {
        String v = value;
        boolean _startsWith = v.startsWith(type.getName());
        if (_startsWith) {
            int _length = type.getName().length();
            int _plus = _length + 1;
            v = v.substring(_plus);
        }
        EList _literals = type.getLiterals();
        for (EnumLiteral l : _literals) {
            boolean _equals = l.getName().equals(v);
            if (!_equals) continue;
            String _name = type.getName();
            String _plus_1 = _name + ".";
            String _name_1 = l.getName();
            return _plus_1 + _name_1;
        }
        return null;
    }

    private String castValue(PrimitiveType type, String value) {
        String _switchResult = null;
        String _targetName = type.getTargetName();
        if (_targetName != null) {
            switch (_targetName) {
                case "boolean": {
                    _switchResult = value.toLowerCase();
                    break;
                }
                case "byte": {
                    _switchResult = "(byte)" + value;
                    break;
                }
                case "short": {
                    _switchResult = "(short)" + value;
                    break;
                }
                case "int": {
                    _switchResult = value;
                    break;
                }
                case "long": {
                    _switchResult = value + "L";
                    break;
                }
                case "float": {
                    _switchResult = value + "f";
                    break;
                }
                case "double": {
                    _switchResult = value + "d";
                    break;
                }
                case "char": {
                    String _xifexpression = null;
                    boolean _isEmpty = value.isEmpty();
                    if (_isEmpty) {
                        _xifexpression = "(char) 0";
                    } else {
                        boolean _equals;
                        String _xifexpression_1 = null;
                        int _length = value.length();
                        boolean bl = _equals = _length == 1;
                        if (_equals) {
                            char _charAt = value.charAt(0);
                            String _plus = "'" + Character.valueOf(_charAt);
                            _xifexpression_1 = _plus + "'";
                        } else {
                            String _replace = value.replace("\\", "\\\\").replace("\"", "\\\"");
                            String _plus_1 = "\"" + _replace;
                            _xifexpression_1 = _plus_1 + "\".toCharArray()";
                        }
                        _xifexpression = _xifexpression_1;
                    }
                    _switchResult = _xifexpression;
                    break;
                }
                case "String": {
                    String _replace_1 = value.replace("\\", "\\\\").replace("\"", "\\\"");
                    String _plus_2 = "\"" + _replace_1;
                    _switchResult = _plus_2 + "\"";
                    break;
                }
                default: {
                    String _targetName_1 = type.getTargetName();
                    throw new UnsupportedOperationException(_targetName_1);
                }
            }
        } else {
            String _targetName_1 = type.getTargetName();
            throw new UnsupportedOperationException(_targetName_1);
        }
        return _switchResult;
    }

    public String defaultValue(DataType dt) {
        String _plus;
        String _switchResult = null;
        boolean _matched = false;
        if (dt instanceof PrimitiveType) {
            _matched = true;
            _switchResult = this.toValueLiteral((PrimitiveType)dt, ((PrimitiveType)dt).getDefaultValueLiteral());
        }
        if (!_matched && dt instanceof EnumerationType) {
            _matched = true;
            _switchResult = this.getDefaultValue((EnumerationType)dt);
        }
        if (!_matched && dt instanceof ExternalType) {
            _matched = true;
            String _targetName = ((ExternalType)dt).getTargetName();
            _plus = "new " + _targetName;
            _switchResult = _plus + "()";
        }
        if (!_matched) {
            String _name = dt.getName();
            _plus = "new " + _name;
            _switchResult = _plus + "()";
        }
        return _switchResult;
    }

    public String getDefaultValue(EnumerationType type) {
        String _xifexpression = null;
        boolean _isEmpty = type.getLiterals().isEmpty();
        _xifexpression = _isEmpty ? "" : this.getCastedValue((EnumLiteral)type.getLiterals().get(0));
        return _xifexpression;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String _xblockexpression = null;
        String dv = this.defaultValue(dt);
        String _xifexpression = null;
        if (size > 1) {
            String _xblockexpression_1 = null;
            String res = "{";
            int i = 0;
            while (i < size) {
                res = res + dv;
                if (++i >= size) continue;
                res = res + ",";
            }
            _xifexpression = _xblockexpression_1 = res + "}";
        } else {
            _xifexpression = dv;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String[] generateArglistAndTypedData(EObject d) {
        String typeName;
        if (d == null || !(d instanceof MessageData)) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        MessageData data = (MessageData)d;
        String castTypeName = typeName = data.getRefType().getType().getName();
        DataType _type = data.getRefType().getType();
        if (_type instanceof PrimitiveType) {
            DataType _type_1 = data.getRefType().getType();
            typeName = ((PrimitiveType)_type_1).getTargetName();
            DataType _type_2 = data.getRefType().getType();
            String ct = ((PrimitiveType)_type_2).getCastName();
            if (ct != null && !ct.isEmpty()) {
                castTypeName = ct;
            }
        } else {
            DataType _type_3 = data.getRefType().getType();
            if (_type_3 instanceof EnumerationType) {
                DataType _type_4 = data.getRefType().getType();
                typeName = this.getTargetType((EnumerationType)_type_4);
                DataType _type_5 = data.getRefType().getType();
                castTypeName = this.getCastType((EnumerationType)_type_5);
            }
        }
        String _xifexpression = null;
        _xifexpression = this._generatorOptionsHelper.isOldStyleTransitionData(Main.getSettings()) && data.getDeprecatedName() != null && !data.getDeprecatedName().trim().isEmpty() ? data.getDeprecatedName() : "transitionData";
        String dataName = _xifexpression;
        String dataArg = ", " + dataName;
        String typedData = typeName + " " + dataName + " = (" + castTypeName + ") generic_data__et;\n";
        String typedArgList = ", " + typeName + " " + dataName;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }

    public String getTargetType(EnumerationType type) {
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean _tripleNotEquals = _primitiveType != null;
        _xifexpression = _tripleNotEquals ? type.getPrimitiveType().getTargetName() : "int";
        return _xifexpression;
    }

    public String getCastedValue(EnumLiteral literal) {
        boolean _tripleEquals;
        String _xblockexpression = null;
        EObject _eContainer = literal.eContainer();
        EnumerationType type = (EnumerationType)_eContainer;
        String cast = this.getTargetType(type);
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean bl = _tripleEquals = _primitiveType == null;
        if (_tripleEquals) {
            _xifexpression = Long.toString(literal.getLiteralValue());
        } else {
            String _string = Long.toString(literal.getLiteralValue());
            String _plus = "((" + cast + ")" + _string;
            _xifexpression = _plus + ")";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getCastType(EnumerationType type) {
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean _tripleNotEquals = _primitiveType != null;
        _xifexpression = _tripleNotEquals ? type.getPrimitiveType().getCastName() : "int";
        return _xifexpression;
    }

    public String makeOverridable() {
        return "";
    }

    public String getTypeSignature(RefableType type) {
        boolean _isRef;
        String _switchResult = null;
        RefableType it = type;
        boolean _matched = false;
        if (Objects.equal((Object)it, null)) {
            _matched = true;
            _switchResult = "void";
        }
        if (!_matched && (_isRef = it.isRef())) {
            _matched = true;
            String _dataTypeName = this.getDataTypeName(type.getType());
            String _pointerLiteral = this.pointerLiteral();
            _switchResult = _dataTypeName + _pointerLiteral;
        }
        if (!_matched) {
            _switchResult = this.getDataTypeName(type.getType());
        }
        return _switchResult;
    }

    public String getDataTypeName(DataType it) {
        String _switchResult = null;
        boolean _matched = false;
        if (it instanceof PrimitiveType) {
            _matched = true;
            _switchResult = ((PrimitiveType)it).getTargetName();
        }
        if (!_matched && it instanceof EnumerationType) {
            _matched = true;
            _switchResult = this.getTargetType((EnumerationType)it);
        }
        if (!_matched && it instanceof ExternalType) {
            _matched = true;
            _switchResult = ((ExternalType)it).getTargetName();
        }
        if (!_matched) {
            _switchResult = it.getName();
        }
        return _switchResult;
    }

    public String toParameterDecl(VarDecl it) {
        String _switchResult = null;
        boolean _matched = false;
        boolean _isVarargs = it.isVarargs();
        if (_isVarargs) {
            _matched = true;
            String _typeSignature = this.getTypeSignature(it.getRefType());
            String _plus = _typeSignature + "... ";
            String _name = it.getName();
            _switchResult = _plus + _name;
        }
        if (!_matched) {
            String _typeSignature_1 = this.getTypeSignature(it.getRefType());
            String _plus_1 = _typeSignature_1 + " ";
            String _name_1 = it.getName();
            _switchResult = _plus_1 + _name_1;
        }
        return _switchResult;
    }
}

