/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInterfaceInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.OptionalActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredStructureClass;
import org.eclipse.etrice.core.genmodel.etricegen.WiredSubSystemClass;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.fsm.base.Indexed;
import org.eclipse.etrice.generator.fsm.base.IntelligentSeparator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.gen.ConfigGenAddon;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.etrice.generator.java.gen.VariableServiceGen;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    private IDataConfiguration dataConfigExt;
    @Inject
    private ConfigGenAddon configGenAddon;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    private VariableServiceGen varService;
    @Inject
    private IDiagnostician diagnostician;

    public void doGenerate(Root root) {
        HashMap sscc2wired = new HashMap();
        Functions.Function1 _function = w -> w instanceof WiredSubSystemClass;
        Consumer<WiredStructureClass> _function_1 = w -> sscc2wired.put(((WiredSubSystemClass)w).getSubSystemClass(), (WiredSubSystemClass)w);
        IterableExtensions.filter((Iterable)root.getWiredInstances(), (Functions.Function1)_function).forEach(_function_1);
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                if (ssi == null) continue;
                WiredSubSystemClass wired = (WiredSubSystemClass)sscc2wired.get(ssi.getSubSystemClass());
                String path = this._roomExtensions.getPath((RoomClass)ssi.getSubSystemClass());
                String file = this._javaExtensions.getJavaFileName(nr, ssi);
                this.checkDataPorts(ssi);
                Set usedThreads = ETMapUtil.getUsedThreads((NodeRef)nr, (SubSystemInstance)ssi);
                this.fileIO.generateFile("generating Node implementation", path + file, this.generate(root, ssi, wired, usedThreads));
                boolean _hasVariableService = this.dataConfigExt.hasVariableService(ssi);
                if (!_hasVariableService) continue;
                this.varService.doGenerate(root, ssi);
            }
        }
    }

    private HashSet<ActorClass> getOptionalActorClasses(Root root, StructureInstance si) {
        Functions.Function1 _function = i -> i instanceof ActorInterfaceInstance;
        Functions.Function1 _function_1 = aii -> (ActorInterfaceInstance)aii;
        ArrayList aifs = Lists.newArrayList((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.filter((Iterator)si.eAllContents(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = aii -> aii.getActorClass();
        HashSet result = Sets.newHashSet((Iterable)ListExtensions.map((List)aifs, (Functions.Function1)_function_2));
        for (ActorInterfaceInstance ai : aifs) {
            EList _optionalInstances = ai.getOptionalInstances();
            for (OptionalActorInstance oi : _optionalInstances) {
                result.addAll(this.getOptionalActorClasses(root, (StructureInstance)oi));
            }
        }
        return result;
    }

    public CharSequence generate(Root root, SubSystemInstance comp, WiredSubSystemClass wired, Collection<PhysicalThread> usedThreads) {
        boolean _isGenerateMSCInstrumentation_4;
        boolean _hasVariableService;
        Object _threadId;
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = comp.getSubSystemClass();
        EList models = root.getReferencedModels((RoomClass)cc);
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)comp);
        String clsname = this._javaExtensions.getJavaClassName(nr, comp);
        Functions.Function1 _function = t -> usedThreads.contains(t);
        Iterable threads = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)_function);
        HashSet<ActorClass> opt = this.getOptionalActorClasses(root, (StructureInstance)comp);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _package = this._roomExtensions.getPackage((RoomClass)cc);
        _builder.append(_package);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.config.IVariableService;");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
            _builder.newLine();
        }
        _builder.append("import org.eclipse.etrice.runtime.java.messaging.IRTObject;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.messaging.IMessageService;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.messaging.MessageService;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.messaging.MessageServiceController;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.messaging.RTServices;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.ActorClassBase;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.DataPortBase;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.OptionalActorInterfaceBase;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.IOptionalActorFactory;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.SubSystemClassBase;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBase;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBroker;");
        _builder.newLine();
        _builder.newLine();
        for (RoomModel model : models) {
            _builder.append("import ");
            String _name = model.getName();
            _builder.append(_name);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode((ActorContainerClass)cc, 1, false);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(clsname);
        _builder.append(" extends SubSystemClassBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Iterable _indexed = Indexed.indexed((Iterable)threads);
        for (Indexed thread : _indexed) {
            _builder.append("\t");
            _builder.append("public static final int ");
            _threadId = this.getThreadId((PhysicalThread)thread.getValue());
            _builder.append((String)_threadId, "\t");
            _builder.append(" = ");
            int _index0 = thread.getIndex0();
            _builder.append((Object)_index0, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode((ActorContainerClass)cc, 2, false);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(clsname, "\t");
        _builder.append("(IRTObject parent, String name) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(parent, name);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void receiveEvent(InterfaceItemBase ifitem, int evt, Object data){");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void instantiateMessageServices() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("IMessageService msgService;");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> {
            long _prio = it.getPrio();
            return -_prio;
        };
        List _sortBy = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)_function_1);
        _threadId = _sortBy.iterator();
        while (_threadId.hasNext()) {
            PhysicalThread thread_1 = (PhysicalThread)_threadId.next();
            if (Objects.equal((Object)thread_1.getExecmode(), (Object)ExecMode.POLLED) || Objects.equal((Object)thread_1.getExecmode(), (Object)ExecMode.MIXED)) {
                _builder.append("\t\t");
                _builder.append("msgService = new MessageService(this, MessageService.ExecMode.");
                String _name_1 = thread_1.getExecmode().getName();
                _builder.append(_name_1, "\t\t");
                _builder.append(", ");
                long _time = thread_1.getTime();
                _builder.append((Object)_time, "\t\t");
                _builder.append("L, 0, ");
                String _threadId_1 = this.getThreadId(thread_1);
                _builder.append(_threadId_1, "\t\t");
                _builder.append(", \"MessageService_");
                String _name_2 = thread_1.getName();
                _builder.append(_name_2, "\t\t");
                _builder.append("\" /*, thread_prio */);");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t\t");
                _builder.append("msgService = new MessageService(this, MessageService.ExecMode.");
                String _name_3 = thread_1.getExecmode().getName();
                _builder.append(_name_3, "\t\t");
                _builder.append(", 0, ");
                String _threadId_2 = this.getThreadId(thread_1);
                _builder.append(_threadId_2, "\t\t");
                _builder.append(", \"MessageService_");
                String _name_4 = thread_1.getName();
                _builder.append(_name_4, "\t\t");
                _builder.append("\" /*, thread_prio */);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("RTServices.getInstance().getMsgSvcCtrl().addMsgSvc(msgService);");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void instantiateActors() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// thread mappings");
        _builder.newLine();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            _builder.append("\t\t");
            ETMapUtil.MappedThread mapped = ETMapUtil.getMappedThread((AbstractInstance)ai);
            _builder.newLineIfNotEmpty();
            boolean _not = !mapped.isImplicit() && !mapped.isAsParent();
            if (!_not) continue;
            _builder.append("\t\t");
            _builder.append("addPathToThread(\"");
            String _path = ai.getPath();
            _builder.append(_path, "\t\t");
            _builder.append("\", ");
            String _threadId_3 = this.getThreadId(mapped.getThread());
            _builder.append(_threadId_3, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// sub actors");
        _builder.newLine();
        EList _actorRefs = cc.getActorRefs();
        for (ActorRef sub : _actorRefs) {
            boolean _greaterThan;
            int _multiplicity = sub.getMultiplicity();
            boolean bl = _greaterThan = _multiplicity > 1;
            if (_greaterThan) {
                _builder.append("\t\t");
                _builder.append("for (int i=0; i<");
                int _multiplicity_1 = sub.getMultiplicity();
                _builder.append((Object)_multiplicity_1, "\t\t");
                _builder.append("; ++i) {");
                _builder.newLineIfNotEmpty();
                boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
                if (_isGenerateMSCInstrumentation_1) {
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("DebuggingService.getInstance().addMessageActorCreate(this, \"");
                    String _name_5 = sub.getName();
                    _builder.append(_name_5, "\t\t\t");
                    _builder.append((Object)Character.valueOf(':'), "\t\t\t");
                    _builder.append("\"+i);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("new ");
                String _name_6 = sub.getType().getName();
                _builder.append(_name_6, "\t\t\t");
                _builder.append("(this, \"");
                String _name_7 = sub.getName();
                _builder.append(_name_7, "\t\t\t");
                _builder.append((Object)Character.valueOf(':'), "\t\t\t");
                _builder.append("\"+i);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                continue;
            }
            boolean _isGenerateMSCInstrumentation_2 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (_isGenerateMSCInstrumentation_2) {
                _builder.append("\t\t");
                _builder.append("DebuggingService.getInstance().addMessageActorCreate(this, \"");
                String _name_8 = sub.getName();
                _builder.append(_name_8, "\t\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("new ");
            String _name_9 = sub.getType().getName();
            _builder.append(_name_9, "\t\t");
            _builder.append("(this, \"");
            String _name_10 = sub.getName();
            _builder.append(_name_10, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// create service brokers in optional actor interfaces");
        _builder.newLine();
        Functions.Function1 _function_2 = inst -> inst instanceof ActorInterfaceInstance;
        Functions.Function1 _function_3 = inst -> (ActorInterfaceInstance)inst;
        Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)this._roomExtensions.getAllSubInstances((StructureInstance)comp), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        for (ActorInterfaceInstance aii : _map) {
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("OptionalActorInterfaceBase oai = (OptionalActorInterfaceBase) getObject(\"");
            String _path_1 = aii.getPath();
            _builder.append(_path_1, "\t\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            EList _providedServices = aii.getProvidedServices();
            for (ServiceImplInstance svc : _providedServices) {
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("new InterfaceItemBroker(oai, \"");
                String _fullyQualifiedName = this._roomExtensions.getFullyQualifiedName((RoomClass)svc.getProtocol());
                _builder.append(_fullyQualifiedName, "\t\t\t");
                _builder.append("\", 0);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("InterfaceItemBase.connect(this, \"");
                String _path_2 = svc.getPath();
                _builder.append(_path_2, "\t\t\t");
                _builder.append("\", \"");
                String _path_3 = aii.getPath();
                String _plus = _path_3 + Character.valueOf('/');
                String _fullyQualifiedName_1 = this._roomExtensions.getFullyQualifiedName((RoomClass)svc.getProtocol());
                String _plus_1 = _plus + _fullyQualifiedName_1;
                _builder.append(_plus_1, "\t\t\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// wiring");
        _builder.newLine();
        EList _wires = wired.getWires();
        for (Wire wire : _wires) {
            _builder.append("\t\t");
            String _xifexpression = null;
            boolean _isDataDriven = wire.isDataDriven();
            _xifexpression = _isDataDriven ? "DataPortBase" : "InterfaceItemBase";
            _builder.append(_xifexpression, "\t\t");
            _builder.append(".connect(this, \"");
            String _join = IterableExtensions.join((Iterable)wire.getPath1(), (CharSequence)"/");
            _builder.append(_join, "\t\t");
            _builder.append("\", \"");
            String _join_1 = IterableExtensions.join((Iterable)wire.getPath2(), (CharSequence)"/");
            _builder.append(_join_1, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// apply instance attribute configurations");
        _builder.newLine();
        EList _allContainedInstances_1 = comp.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            _builder.append("\t\t");
            CharSequence cfg = this.configGenAddon.genActorInstanceConfig(ai_1, "inst");
            _builder.newLineIfNotEmpty();
            int _length = cfg.length();
            boolean _greaterThan_1 = _length > 0;
            if (!_greaterThan_1) continue;
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            String _name_11 = ai_1.getActorClass().getName();
            _builder.append(_name_11, "\t\t\t");
            _builder.append(" inst = (");
            String _name_12 = ai_1.getActorClass().getName();
            _builder.append(_name_12, "\t\t\t");
            _builder.append(") getObject(\"");
            String _path_4 = ai_1.getPath();
            _builder.append(_path_4, "\t\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("if (inst!=null) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append((Object)cfg, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void init(){");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_3 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_3) {
            _builder.append("\t\t");
            _builder.append("DebuggingService.getInstance().addVisibleComment(\"begin sub system initialization\");");
            _builder.newLine();
        }
        if (_hasVariableService = this.dataConfigExt.hasVariableService(comp)) {
            _builder.append("\t\t");
            _builder.append("variableService = new ");
            _builder.append(clsname, "\t\t");
            _builder.append("VariableService(this);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("super.init();");
        _builder.newLine();
        boolean _hasVariableService_1 = this.dataConfigExt.hasVariableService(comp);
        if (_hasVariableService_1) {
            _builder.append("\t\t");
            _builder.append("variableService.init();");
            _builder.newLine();
        }
        if (_isGenerateMSCInstrumentation_4 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings())) {
            _builder.append("\t\t");
            _builder.append("DebuggingService.getInstance().addVisibleComment(\"done sub system initialization\");");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void stop(){");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("super.stop();");
        _builder.newLine();
        boolean _hasVariableService_2 = this.dataConfigExt.hasVariableService(comp);
        if (_hasVariableService_2) {
            _builder.append("\t\t");
            _builder.append("variableService.stop();");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_5 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_5) {
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public boolean hasGeneratedMSCInstrumentation() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void destroy() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("DebuggingService.getInstance().addVisibleComment(\"begin sub system destruction\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("super.destroy();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("DebuggingService.getInstance().addVisibleComment(\"done sub system destruction\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public IOptionalActorFactory getFactory(String optionalActorClass, String actorClass) {");
        _builder.newLine();
        _builder.append("\t\t");
        IntelligentSeparator else1 = new IntelligentSeparator("else ");
        _builder.newLineIfNotEmpty();
        for (ActorClass oa : opt) {
            _builder.append("\t\t");
            _builder.append((Object)else1, "\t\t");
            _builder.append("if (optionalActorClass.equals(\"");
            String _name_13 = oa.getName();
            _builder.append(_name_13, "\t\t");
            _builder.append("\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            IntelligentSeparator else2 = new IntelligentSeparator("else ");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_4 = s -> {
                boolean _isAbstract = s.isAbstract();
                return !_isAbstract;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)this._roomExtensions.union((Iterable)root.getSubClasses(oa), (Object)oa), (Functions.Function1)_function_4);
            for (ActorClass subcls : _filter) {
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append((Object)else2, "\t\t\t");
                _builder.append("if (\"");
                String _name_14 = subcls.getName();
                _builder.append(_name_14, "\t\t\t");
                _builder.append("\".equals(actorClass)) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return new ");
                String _javaFactoryName = this._javaExtensions.getJavaFactoryName(subcls);
                _builder.append(_javaFactoryName, "\t\t\t\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getThreadId(PhysicalThread thread) {
        String _upperCase = thread.getName().toUpperCase();
        return "THREAD_" + _upperCase;
    }

    private void checkDataPorts(SubSystemInstance comp) {
        HashSet<String> found = new HashSet<String>();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            int thread = ai.getThreadId();
            EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances) {
                CommunicationType _commType = pi.getProtocol().getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                if (!_equals) continue;
                EList _peers = pi.getPeers();
                for (InterfaceItemInstance peer : _peers) {
                    EObject _eContainer = peer.eContainer();
                    ActorInstance peer_ai = (ActorInstance)_eContainer;
                    int peer_thread = peer_ai.getThreadId();
                    if (thread == peer_thread) continue;
                    String path = pi.getPath();
                    String ppath = peer.getPath();
                    String _xifexpression = null;
                    int _compareTo = path.compareTo(ppath);
                    boolean _lessThan = _compareTo < 0;
                    _xifexpression = _lessThan ? path + " and " + ppath : ppath + " and " + path;
                    String pair = _xifexpression;
                    boolean _contains = found.contains(pair);
                    boolean _not = !_contains;
                    if (!_not) continue;
                    found.add(pair);
                    this.diagnostician.error(pair + ": data ports placed on different threads (not supported yet)", (EObject)pi.getInterfaceItem(), pi.getInterfaceItem().eContainingFeature());
                }
            }
        }
    }
}

