/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class NodeRunnerGen {
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    private IGeneratorFileIO fileIO;

    public void doGenerate(Root root) {
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                if (ssi == null) continue;
                String _javaClassName = this._javaExtensions.getJavaClassName(nr, ssi);
                String file = _javaClassName + "Runner.java";
                String filepath = this.roomExt.getPath((RoomClass)ssi.getSubSystemClass());
                this.fileIO.generateFile("generating SubSystemRunner implementation", filepath + file, this.generate(root, ssi));
            }
        }
    }

    public CharSequence generate(Root root, SubSystemInstance ssc) {
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = ssc.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssc);
        String clsname = this._javaExtensions.getJavaClassName(nr, ssc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* this class contains the main function running component ");
        String _name = ssc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* it instantiates ");
        String _name_1 = ssc.getName();
        _builder.append(_name_1, " ");
        _builder.append(" and starts and ends the lifecycle");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("package ");
        String _package = this.roomExt.getPackage((RoomClass)cc);
        _builder.append(_package);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.RTSystem;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.SubSystemRunnerBase;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(clsname + "Runner");
        _builder.append(" extends SubSystemRunnerBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* main function");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* creates the main component and starts and stops the lifecycle");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static void main(String[] args) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// instantiate the main component");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("RTSystem sys = ");
        EObject _eContainer = ssc.eContainer();
        if (_eContainer instanceof SystemInstance) {
            _builder.append("new RTSystem(\"");
            EObject _eContainer_1 = ssc.eContainer();
            String _name_2 = ((SystemInstance)_eContainer_1).getName();
            _builder.append(_name_2, "\t\t");
            _builder.append("\")");
        } else {
            _builder.append("null");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append(clsname, "\t\t");
        _builder.append(" main_component = new ");
        _builder.append(clsname, "\t\t");
        _builder.append("(sys, \"");
        String _name_3 = ssc.getName();
        _builder.append(_name_3, "\t\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("run(main_component, args);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

