/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.OpenBinding;
import org.eclipse.etrice.core.genmodel.etricegen.OpenServiceConnection;
import org.eclipse.etrice.core.genmodel.etricegen.OptionalActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.WiredActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.WiredStructureClass;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class OptionalActorFactoryGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;

    public void doGenerate(Root root) {
        HashMap ac2wired = new HashMap();
        Functions.Function1 _function = w -> w instanceof WiredActorClass;
        Consumer<WiredStructureClass> _function_1 = w -> ac2wired.put(((WiredActorClass)w).getActorClass(), (WiredActorClass)w);
        IterableExtensions.filter((Iterable)root.getWiredInstances(), (Functions.Function1)_function).forEach(_function_1);
        EList _optionalInstances = root.getOptionalInstances();
        for (OptionalActorInstance oi : _optionalInstances) {
            ActorClass ac = oi.getActorClass();
            WiredActorClass wired = (WiredActorClass)ac2wired.get(ac);
            String path = this._roomExtensions.getPath((RoomClass)ac);
            String file = this._javaExtensions.getJavaFactoryFileName(ac);
            this.fileIO.generateFile("generating ActorClass Interface implementation", path + file, this.generate(root, oi, wired));
        }
    }

    public CharSequence generate(Root root, OptionalActorInstance oi, WiredActorClass wired) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = oi.getActorClass();
        String clsname = this._javaExtensions.getJavaFactoryName(ac);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _package = this._roomExtensions.getPackage((RoomClass)ac);
        _builder.append(_package);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import ");
        String _package_1 = this._roomExtensions.getPackage((RoomClass)ac);
        _builder.append(_package_1);
        _builder.append(".");
        String _name = ac.getName();
        _builder.append(_name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.OptionalActorInterfaceBase;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.IOptionalActorFactory;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBase;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(clsname);
        _builder.append(" implements IOptionalActorFactory {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _name_1 = ac.getName();
        _builder.append(_name_1, "\t");
        _builder.append(" create(OptionalActorInterfaceBase ai, String name) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("// instantiate sub tree");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_2 = ac.getName();
        _builder.append(_name_2, "\t\t");
        _builder.append(" actor = new ");
        String _name_3 = ac.getName();
        _builder.append(_name_3, "\t\t");
        _builder.append("(ai, name);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// wiring");
        _builder.newLine();
        Functions.Function1 _function = p -> this._roomHelpers.isExternal(p);
        Iterable _filter = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)_function);
        for (Port port : _filter) {
            _builder.append("\t\t");
            String _xifexpression = null;
            boolean _isDataDriven = this._roomHelpers.isDataDriven((InterfaceItem)port);
            _xifexpression = _isDataDriven ? "DataPortBase" : "InterfaceItemBase";
            _builder.append(_xifexpression, "\t\t");
            _builder.append(".connect(ai, \"");
            String _name_4 = port.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append("\", name+\"/");
            String _name_5 = port.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        EList _openBindings = wired.getOpenBindings();
        for (OpenBinding open : _openBindings) {
            _builder.append("\t\t");
            String _xifexpression_1 = null;
            boolean _isDataDriven_1 = this._roomHelpers.isDataDriven((InterfaceItem)open.getPort());
            _xifexpression_1 = _isDataDriven_1 ? "DataPortBase" : "InterfaceItemBase";
            _builder.append(_xifexpression_1, "\t\t");
            _builder.append(".connect(ai, \"");
            String _name_6 = open.getPort().getName();
            _builder.append(_name_6, "\t\t");
            _builder.append("\", name+\"/");
            String _join = IterableExtensions.join((Iterable)open.getPath(), (CharSequence)"/");
            _builder.append(_join, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        EList _requiredServices = wired.getRequiredServices();
        for (OpenServiceConnection req : _requiredServices) {
            _builder.append("\t\t");
            String _xifexpression_2 = null;
            CommunicationType _commType = req.getProtocol().getCommType();
            boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
            _xifexpression_2 = _equals ? "DataPortBase" : "InterfaceItemBase";
            _builder.append(_xifexpression_2, "\t\t");
            _builder.append(".connect(ai, \"");
            String _fullyQualifiedName = this._roomExtensions.getFullyQualifiedName((RoomClass)req.getProtocol());
            _builder.append(_fullyQualifiedName, "\t\t");
            _builder.append("\", name+\"/");
            String _join_1 = IterableExtensions.join((Iterable)req.getPath(), (CharSequence)"/");
            _builder.append(_join_1, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return actor;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

