/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class OptionalActorInterfaceGen
extends GenericActorClassGenerator {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public void doGenerate(Root root) {
        EList _optionalActorClasses = root.getOptionalActorClasses();
        for (ActorClass ac : _optionalActorClasses) {
            String path = this._roomExtensions.getPath((RoomClass)ac);
            String file = this._javaExtensions.getJavaInterfaceFileName(ac, false);
            this.fileIO.generateFile("generating ActorClass Interface implementation", path + file, this.generate(root, ac, false));
            file = this._javaExtensions.getJavaInterfaceFileName(ac, true);
            this.fileIO.generateFile("generating ActorClass Interface implementation", path + file, this.generate(root, ac, true));
        }
    }

    public CharSequence generate(Root root, ActorClass ac, boolean replicated) {
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = replicated ? "ReplicatedOptionalActorInterfaceBase" : "ScalarOptionalActorInterfaceBase";
        String baseClass = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _package = this._roomExtensions.getPackage((RoomClass)ac);
        _builder.append(_package);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
            _builder.newLine();
        }
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.IEventReceiver;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBroker;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.");
        _builder.append(baseClass);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        String _javaInterfaceName = this._javaExtensions.getJavaInterfaceName(ac, replicated);
        _builder.append(_javaInterfaceName);
        _builder.append(" extends ");
        _builder.append(baseClass);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//--------------------- brokers for ports on the interface");
        _builder.newLine();
        List _allInterfacePorts = this._roomHelpers.getAllInterfacePorts((ActorContainerClass)ac);
        for (Port ep : _allInterfacePorts) {
            _builder.append("\t");
            _builder.append("protected InterfaceItemBroker ");
            String _name = ep.getName();
            _builder.append(_name, "\t");
            _builder.append(" = null;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//--------------------- interface item IDs");
        _builder.newLine();
        _builder.append("\t");
        String _genInterfaceItemConstantsForOptionalActor = this.genInterfaceItemConstantsForOptionalActor(ac);
        _builder.append(_genInterfaceItemConstantsForOptionalActor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//--------------------- construction");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _javaInterfaceName_1 = this._javaExtensions.getJavaInterfaceName(ac, replicated);
        _builder.append(_javaInterfaceName_1, "\t");
        _builder.append(" (IEventReceiver parent, String name) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(parent, name, \"");
        String _name_1 = ac.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        List _allInterfacePorts_1 = this._roomHelpers.getAllInterfacePorts((ActorContainerClass)ac);
        for (Port ep_1 : _allInterfacePorts_1) {
            boolean _isReplicated = ep_1.isReplicated();
            if (_isReplicated) {
                _builder.append("\t\t");
                String _name_2 = ep_1.getName();
                _builder.append(_name_2, "\t\t");
                _builder.append(" = new ReplicatedInterfaceItemBroker(this, \"");
                String _name_3 = ep_1.getName();
                _builder.append(_name_3, "\t\t");
                _builder.append("\", ");
                String _ifItemId = this.getIfItemId((AbstractInterfaceItem)ep_1);
                _builder.append(_ifItemId, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("\t\t");
            String _name_4 = ep_1.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append(" = new InterfaceItemBroker(this, \"");
            String _name_5 = ep_1.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("\", ");
            String _ifItemId_1 = this.getIfItemId((AbstractInterfaceItem)ep_1);
            _builder.append(_ifItemId_1, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_1) {
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("protected void logCreation(String actorClass, String name) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("DebuggingService.getInstance().addMessageActorCreate(this, actorClass, name);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("protected void logDeletion(String name) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("DebuggingService.getInstance().addMessageActorDestroy(this, name);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

