/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.gen.DataClassGen;
import org.eclipse.etrice.generator.java.gen.Initialization;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private Initialization _initialization;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private DataClassGen _dataClassGen;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IDiagnostician diagnostician;

    public void doGenerate(Root root) {
        Functions.Function1 _function = it -> {
            boolean _isDeprecatedGeneration = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !_isDeprecatedGeneration;
        };
        Consumer<ProtocolClass> _function_1 = pc -> {
            CharSequence contents;
            boolean _isEmpty;
            String path = this._roomExtensions.getPath((RoomClass)pc);
            String file = this._javaExtensions.getJavaFileName((RoomClass)pc);
            CharSequence _switchResult = null;
            CommunicationType _commType = pc.getCommType();
            if (_commType != null) {
                switch (_commType) {
                    case EVENT_DRIVEN: {
                        _switchResult = this.generate(root, (ProtocolClass)pc);
                        break;
                    }
                    case DATA_DRIVEN: {
                        _switchResult = this.generateDataDriven(root, (ProtocolClass)pc);
                        break;
                    }
                    case SYNCHRONOUS: {
                        _switchResult = "";
                        break;
                    }
                }
            }
            if (_isEmpty = (contents = _switchResult).toString().isEmpty()) {
                this.diagnostician.error("synchronous protocols not supported yet", (EObject)pc, null);
            } else {
                this.fileIO.generateFile("generating ProtocolClass implementation", path + file, contents);
            }
        };
        IterableExtensions.filter((Iterable)root.getProtocolClasses(), (Functions.Function1)_function).forEach(_function_1);
    }

    public CharSequence generate(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _package = this._roomExtensions.getPackage((RoomClass)pc);
        _builder.append(_package);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.messaging.Message;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.EventMessage;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.EventWithDataMessage;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.IInterfaceItemOwner;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBase;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.PortBase;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.ReplicatedPortBase;");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
            _builder.newLine();
        }
        _builder.append("import static org.eclipse.etrice.runtime.java.etunit.EtUnit.*;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(pc, 1);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList models = root.getReferencedModels((RoomClass)pc);
        _builder.newLineIfNotEmpty();
        for (RoomModel model : models) {
            _builder.append("import ");
            String _name = model.getName();
            _builder.append(_name);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("public class ");
        String _name_1 = pc.getName();
        _builder.append(_name_1);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// message IDs");
        _builder.newLine();
        _builder.append("\t");
        String _genMessageIDs = this.genMessageIDs(pc);
        _builder.append(_genMessageIDs, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode(pc, 2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static String messageStrings[] = {\"MIN\", ");
        List _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
        for (Message m : _allOutgoingMessages) {
            _builder.append("\"");
            String _name_2 = m.getName();
            _builder.append(_name_2, "\t");
            _builder.append("\",");
        }
        _builder.append(" ");
        List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
        for (Message m_1 : _allIncomingMessages) {
            _builder.append("\"");
            String _name_3 = m_1.getName();
            _builder.append(_name_3, "\t");
            _builder.append("\",");
        }
        _builder.append("\"MAX\"};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String getMessageString(int msg_id) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (msg_id<MSG_MIN || msg_id>MSG_MAX+1){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// id out of range");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return \"Message ID out of range\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return messageStrings[msg_id];");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _portClass = this.portClass(pc, false);
        _builder.append((Object)_portClass, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _portClass_1 = this.portClass(pc, true);
        _builder.append((Object)_portClass_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence portClass(ProtocolClass pc, boolean conj) {
        boolean _handlesReceive;
        boolean _isGenerateMSCInstrumentation;
        StringConcatenation _xblockexpression = null;
        PortClass pclass = this._roomExtensions.getPortClass(pc, conj);
        String portClassName = this._roomExtensions.getPortClassName(pc, conj);
        String replPortClassName = this._roomExtensions.getPortClassName(pc, conj, true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("// port class");
        _builder.newLine();
        _builder.append("static public class ");
        _builder.append(portClassName);
        _builder.append(" extends PortBase {");
        _builder.newLineIfNotEmpty();
        if (pclass != null) {
            _builder.append("\t");
            CharSequence _userCode = this._procedureHelpers.userCode(pclass.getUserCode());
            _builder.append((Object)_userCode, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("// constructors");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(portClassName, "\t");
        _builder.append("(IInterfaceItemOwner actor, String name, int localId) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("this(actor, name, localId, 0);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(portClassName, "\t");
        _builder.append("(IInterfaceItemOwner actor, String name, int localId, int idx) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(actor, name, localId, idx);");
        _builder.newLine();
        if (pclass != null) {
            _builder.append("\t\t");
            CharSequence _attributeInitialization = this._initialization.attributeInitialization((List<Attribute>)pclass.getAttributes(), (EObject)pclass, true);
            _builder.append((Object)_attributeInitialization, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        if (_isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings())) {
            _builder.append("\t\t");
            _builder.append("DebuggingService.getInstance().addPortInstance(this);");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_1) {
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void destroy() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("DebuggingService.getInstance().removePortInstance(this);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("super.destroy();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void receive(Message m) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (!(m instanceof EventMessage))");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("EventMessage msg = (EventMessage) m;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (0 < msg.getEvtId() && msg.getEvtId() < MSG_MAX) {");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_2 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_2) {
            _builder.append("\t\t\t");
            _builder.append("DebuggingService.getInstance().addMessageAsyncIn(getPeerAddress(), getAddress(), messageStrings[msg.getEvtId()]);");
            _builder.newLine();
        }
        if (_handlesReceive = this._roomExtensions.handlesReceive(pc, conj)) {
            _builder.append("\t\t\t");
            _builder.append("switch (msg.getEvtId()) {");
            _builder.newLine();
            List _receiveHandlers = this._roomExtensions.getReceiveHandlers(pc, conj);
            for (MessageHandler hdlr : _receiveHandlers) {
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("case ");
                String _codeName = this._roomExtensions.getCodeName(hdlr.getMsg());
                _builder.append(_codeName, "\t\t\t\t");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                EList _lines = hdlr.getDetailCode().getLines();
                for (String command : _lines) {
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append(command, "\t\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("default:");
            _builder.newLine();
        }
        _builder.append("\t\t\t");
        _builder.append("if (msg instanceof EventWithDataMessage)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("getActor().receiveEvent(this, msg.getEvtId(), ((EventWithDataMessage)msg).getData());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("getActor().receiveEvent(this, msg.getEvtId(), null);");
        _builder.newLine();
        boolean _handlesReceive_1 = this._roomExtensions.handlesReceive(pc, conj);
        if (_handlesReceive_1) {
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        if (pclass != null) {
            _builder.append("\t");
            CharSequence _attributes = this._procedureHelpers.attributes((List)pclass.getAttributes());
            _builder.append((Object)_attributes, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _attributeSettersGettersImplementation = this._procedureHelpers.attributeSettersGettersImplementation((List)pclass.getAttributes(), null);
            _builder.append((Object)_attributeSettersGettersImplementation, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation((List)pclass.getOperations(), portClassName);
            _builder.append((Object)_operationsImplementation, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// sent messages");
        _builder.newLine();
        List _allMessages = this._roomHelpers.getAllMessages(pc, conj);
        for (Message m : _allMessages) {
            _builder.append("\t");
            CharSequence _sendMessage = this.sendMessage(m, conj);
            _builder.append((Object)_sendMessage, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// replicated port class");
        _builder.newLine();
        _builder.append("static public class ");
        _builder.append(replPortClassName);
        _builder.append(" extends ReplicatedPortBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(replPortClassName, "\t");
        _builder.append("(IInterfaceItemOwner actor, String name, int localId) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(actor, name, localId);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public int getReplication() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return getNInterfaceItems();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public int getIndexOf(InterfaceItemBase ifitem){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ifitem.getIdx();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(portClassName, "\t");
        _builder.append(" get(int idx) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return (");
        _builder.append(portClassName, "\t\t");
        _builder.append(") getInterfaceItem(idx);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected InterfaceItemBase createInterfaceItem(IInterfaceItemOwner rcv, String name, int lid, int idx) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return new ");
        _builder.append(portClassName, "\t\t");
        _builder.append("(rcv, name, lid, idx);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        if (conj) {
            _builder.append("\t");
            _builder.append("// incoming messages");
            _builder.newLine();
            List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message m_1 : _allIncomingMessages) {
                _builder.append("\t");
                CharSequence _messageSignature = this.messageSignature(m_1);
                _builder.append((Object)_messageSignature, "\t");
                _builder.append("{");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("for (InterfaceItemBase item : getItems()) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("((");
                _builder.append(portClassName, "\t\t\t");
                _builder.append(")item).");
                CharSequence _messageCall = this.messageCall(m_1);
                _builder.append((Object)_messageCall, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
        } else {
            _builder.append("\t");
            _builder.append("// outgoing messages");
            _builder.newLine();
            List _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message m_2 : _allOutgoingMessages) {
                _builder.append("\t");
                CharSequence _messageSignature_1 = this.messageSignature(m_2);
                _builder.append((Object)_messageSignature_1, "\t");
                _builder.append("{");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("for (InterfaceItemBase item : getItems()) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("((");
                _builder.append(portClassName, "\t\t\t");
                _builder.append(")item).");
                CharSequence _messageCall_1 = this.messageCall(m_2);
                _builder.append((Object)_messageCall_1, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence messageSignature(Message m) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isPriv = m.isPriv();
        if (_isPriv) {
            _builder.append("private");
        } else {
            _builder.append("public");
        }
        _builder.append(" void ");
        String _name = m.getName();
        _builder.append(_name);
        _builder.append("(");
        MessageData _data = m.getData();
        boolean bl = _tripleNotEquals = _data != null;
        if (_tripleNotEquals) {
            String _typeName = this._typeHelpers.typeName(m.getData().getRefType().getType());
            _builder.append(_typeName);
            _builder.append(" ");
            _builder.append("transitionData");
        }
        _builder.append(")");
        return _builder;
    }

    public CharSequence messageSignatureExplicit(Message m) {
        StringConcatenation _xblockexpression = null;
        DataType _type = m.getData().getRefType().getType();
        DataClass dc = (DataClass)_type;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public void ");
        String _name = m.getName();
        _builder.append(_name);
        _builder.append("(");
        String _argList = this._dataClassGen.argList(dc);
        _builder.append(_argList);
        _builder.append(")");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence messageCall(Message m) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = m.getName();
        _builder.append(_name);
        _builder.append("(");
        MessageData _data = m.getData();
        boolean bl = _tripleNotEquals = _data != null;
        if (_tripleNotEquals) {
            _builder.append(" ");
            _builder.append("transitionData");
        }
        _builder.append(")");
        return _builder;
    }

    public CharSequence sendMessage(Message m, boolean conj) {
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = conj ? "IN" : "OUT";
        String dir = _xifexpression;
        MessageHandler hdlr = this._roomExtensions.getSendHandler(m, conj);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messageSignature = this.messageSignature(m);
        _builder.append((Object)_messageSignature);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        if (hdlr != null) {
            _builder.append("\t");
            EList _lines = hdlr.getDetailCode().getLines();
            for (String command : _lines) {
                _builder.append("\t");
                _builder.append(command, "\t");
                _builder.newLineIfNotEmpty();
            }
        } else {
            boolean _tripleEquals;
            boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (_isGenerateMSCInstrumentation) {
                _builder.append("\t");
                _builder.append("DebuggingService.getInstance().addMessageAsyncOut(getAddress(), getPeerAddress(), messageStrings[");
                _builder.append(dir, "\t");
                _builder.append("_");
                String _name = m.getName();
                _builder.append(_name, "\t");
                _builder.append("]);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("if (getPeerAddress()!=null)");
            _builder.newLine();
            MessageData _data = m.getData();
            boolean bl = _tripleEquals = _data == null;
            if (_tripleEquals) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("getPeerMsgReceiver().receive(new EventMessage(getPeerAddress(), ");
                _builder.append(dir, "\t\t");
                _builder.append("_");
                String _name_1 = m.getName();
                _builder.append(_name_1, "\t\t");
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("getPeerMsgReceiver().receive(new EventWithDataMessage(getPeerAddress(), ");
                _builder.append(dir, "\t\t");
                _builder.append("_");
                String _name_2 = m.getName();
                _builder.append(_name_2, "\t\t");
                _builder.append(", ");
                _builder.append("transitionData", "\t\t");
                if (!m.getData().getRefType().isRef() && !this._typeHelpers.isEnumerationOrPrimitive(m.getData().getRefType().getType())) {
                    _builder.append(".deepCopy()");
                }
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        if (m.getData() != null && m.getData().getRefType().getType() instanceof DataClass) {
            CharSequence _messageSignatureExplicit = this.messageSignatureExplicit(m);
            _builder.append((Object)_messageSignatureExplicit);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _name_3 = m.getName();
            _builder.append(_name_3, "\t");
            _builder.append("(new ");
            String _name_4 = m.getData().getRefType().getType().getName();
            _builder.append(_name_4, "\t");
            _builder.append("(");
            DataType _type = m.getData().getRefType().getType();
            String _paramList = this._dataClassGen.paramList((DataClass)_type);
            _builder.append(_paramList, "\t");
            _builder.append("));");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateDataDriven(Root root, ProtocolClass pc) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = m -> {
            MessageData _data = m.getData();
            return _data != null;
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)_function);
        EList models = root.getReferencedModels((RoomClass)pc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _package = this._roomExtensions.getPackage((RoomClass)pc);
        _builder.append(_package);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.messaging.IRTObject;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.DataReceivePort;");
        _builder.newLine();
        _builder.append("import org.eclipse.etrice.runtime.java.modelbase.DataSendPort;");
        _builder.newLine();
        _builder.append("import static org.eclipse.etrice.runtime.java.etunit.EtUnit.*;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(pc, 1);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (RoomModel model : models) {
            _builder.append("import ");
            String _name = model.getName();
            _builder.append(_name);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("public class ");
        String _name_1 = pc.getName();
        _builder.append(_name_1);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode(pc, 2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// send port holds data");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static public class ");
        String _portClassName = this._roomExtensions.getPortClassName(pc, true);
        _builder.append(_portClassName, "\t");
        _builder.append(" extends DataSendPort {");
        _builder.newLineIfNotEmpty();
        for (Object msg : sentMsgs) {
            _builder.append("\t\t");
            _builder.append("private ");
            String _typeName = this._typeHelpers.typeName(msg.getData().getRefType().getType());
            _builder.append(_typeName, "\t\t");
            _builder.append(" ");
            String _name_2 = msg.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// constructor");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public ");
        String _portClassName_1 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append(_portClassName_1, "\t\t");
        _builder.append("(IRTObject parent, String name, int localId) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("super(parent, name, localId);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// getters and setters");
        _builder.newLine();
        for (Message msg_1 : sentMsgs) {
            _builder.append("\t\t");
            _builder.append("public void ");
            String _name_3 = msg_1.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append("(");
            String _typeName_1 = this._typeHelpers.typeName(msg_1.getData().getRefType().getType());
            _builder.append(_typeName_1, "\t\t");
            _builder.append(" ");
            String _name_4 = msg_1.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("this.");
            String _name_5 = msg_1.getName();
            _builder.append(_name_5, "\t\t\t");
            _builder.append(" = ");
            String _name_6 = msg_1.getName();
            _builder.append(_name_6, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("public ");
            String _typeName_2 = this._typeHelpers.typeName(msg_1.getData().getRefType().getType());
            _builder.append(_typeName_2, "\t\t");
            _builder.append(" ");
            String _name_7 = msg_1.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("return ");
            String _name_8 = msg_1.getName();
            _builder.append(_name_8, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// receive port accesses send port");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static public class ");
        String _portClassName_2 = this._roomExtensions.getPortClassName(pc, false);
        _builder.append(_portClassName_2, "\t");
        _builder.append(" extends DataReceivePort {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("private ");
        String _portClassName_3 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append(_portClassName_3, "\t\t");
        _builder.append(" peer;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// constructor");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public ");
        String _portClassName_4 = this._roomExtensions.getPortClassName(pc, false);
        _builder.append(_portClassName_4, "\t\t");
        _builder.append("(IRTObject parent, String name, int localId) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("super(parent, name, localId);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// getters");
        _builder.newLine();
        for (Message msg_2 : sentMsgs) {
            _builder.append("\t\t");
            _builder.append("public ");
            String _typeName_3 = this._typeHelpers.typeName(msg_2.getData().getRefType().getType());
            _builder.append(_typeName_3, "\t\t");
            _builder.append(" ");
            String _name_9 = msg_2.getName();
            _builder.append(_name_9, "\t\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("if (peer==null)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("return ");
            String _defaultValue = this._javaExtensions.defaultValue(msg_2.getData().getRefType().getType());
            _builder.append(_defaultValue, "\t\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("return peer.");
            String _name_10 = msg_2.getName();
            _builder.append(_name_10, "\t\t\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("protected void connect(DataSendPort dataSendPort) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (dataSendPort instanceof ");
        String _portClassName_5 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append(_portClassName_5, "\t\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("peer = (");
        String _portClassName_6 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append(_portClassName_6, "\t\t\t\t");
        _builder.append(")dataSendPort;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

