/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.generator.generic.GenericStateMachineGenerator;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
public class StateMachineGen
extends GenericStateMachineGenerator {
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    private final NodeComparator nodeComparator = new NodeComparator();

    public CharSequence genExtra(GraphContainer gc, boolean generateImplementation) {
        boolean _isGenerateWithVerboseOutput;
        StringConcatenation _xblockexpression = null;
        List orderedStateNodes = IterableExtensions.sortWith((Iterable)IteratorExtensions.toList((Iterator)FsmGenExtensions.getAllStateNodes((Graph)gc.getGraph())), (Comparator)this.nodeComparator);
        StringConcatenation _builder = new StringConcatenation();
        if (this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) || this._generatorOptionsHelper.isGenerateWithVerboseOutput(Main.getSettings())) {
            _builder.append("// state names");
            _builder.newLine();
            _builder.append("protected static final String stateStrings[] = {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"<no state>\",");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"<top>\",");
            _builder.newLine();
            boolean _hasElements = false;
            for (Node node : orderedStateNodes) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                _builder.append("\t");
                _builder.append("\"");
                StateGraphNode _stateGraphNode = node.getStateGraphNode();
                String _genStatePathName = this._codegenHelpers.getGenStatePathName((State)_stateGraphNode);
                _builder.append(_genStatePathName, "\t");
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("};");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.append("// history");
        _builder.newLine();
        _builder.append("protected int history[] = {NO_STATE, NO_STATE");
        for (Node state : orderedStateNodes) {
            _builder.append(", NO_STATE");
        }
        _builder.append("};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("private void setState(int new_state) {");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("\t");
            _builder.append("DebuggingService.getInstance().addActorState(this,stateStrings[new_state]);");
            _builder.newLine();
        }
        if (_isGenerateWithVerboseOutput = this._generatorOptionsHelper.isGenerateWithVerboseOutput(Main.getSettings())) {
            _builder.append("\t");
            _builder.append("if (stateStrings[new_state]!=\"Idle\") {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("System.out.println(\"state switch of \"+getInstancePath() + \": \"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("+ stateStrings[this.state] + \" -> \" + stateStrings[new_state]);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("this.state = new_state;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence finalAction() {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isGenerateStoreDataObj = this._generatorOptionsHelper.isGenerateStoreDataObj(Main.getSettings());
        if (_isGenerateStoreDataObj) {
            _builder.append("finalAction();");
            _builder.newLine();
        }
        return _builder;
    }

    public int getHistorySize(ExpandedActorClass xpac) {
        int _size = this._fSMHelpers.getAllBaseStates((ModelComponent)xpac.getActorClass()).size();
        return _size + 2;
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            int _inheritanceLevel_1;
            boolean _equals;
            int _inheritanceLevel = o1.getInheritanceLevel();
            boolean bl = _equals = _inheritanceLevel == (_inheritanceLevel_1 = o2.getInheritanceLevel());
            if (_equals) {
                if (FsmGenExtensions.isLeaf((Node)o1) && FsmGenExtensions.isLeaf((Node)o2)) {
                    return 0;
                }
                boolean _isLeaf = FsmGenExtensions.isLeaf((Node)o1);
                if (_isLeaf) {
                    return 1;
                }
                boolean _isLeaf_1 = FsmGenExtensions.isLeaf((Node)o2);
                if (_isLeaf_1) {
                    return -1;
                }
                return 0;
            }
            return Integer.compare(o1.getInheritanceLevel(), o1.getInheritanceLevel());
        }
    }
}

