/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CommunicationType implements Enumerator
{
    EVENT_DRIVEN(0, "EVENT_DRIVEN", "eventdriven"),
    DATA_DRIVEN(1, "DATA_DRIVEN", "datadriven"),
    SYNCHRONOUS(2, "SYNCHRONOUS", "sync");

    public static final int EVENT_DRIVEN_VALUE = 0;
    public static final int DATA_DRIVEN_VALUE = 1;
    public static final int SYNCHRONOUS_VALUE = 2;
    private static final CommunicationType[] VALUES_ARRAY;
    public static final List<CommunicationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static CommunicationType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CommunicationType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CommunicationType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CommunicationType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CommunicationType get(int value) {
        switch (value) {
            case 0: {
                return EVENT_DRIVEN;
            }
            case 1: {
                return DATA_DRIVEN;
            }
            case 2: {
                return SYNCHRONOUS;
            }
        }
        return null;
    }

    private CommunicationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new CommunicationType[]{EVENT_DRIVEN, DATA_DRIVEN, SYNCHRONOUS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

