/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.abstractexec.behavior.Activator;
import org.eclipse.etrice.abstractexec.behavior.ActiveRules;
import org.eclipse.etrice.abstractexec.behavior.SemanticsCheck;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.SemanticsRule;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.CommonTrigger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphItem;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;

public class ProposalGenerator {
    private SemanticsCheck checker;
    private List<MessageFromIf> outgoingProposal = new LinkedList<MessageFromIf>();
    private List<MessageFromIf> incomingProposal = new LinkedList<MessageFromIf>();
    private FSMNameProvider fsmNameProvider = new FSMNameProvider();
    private static boolean traceProposals;

    public ProposalGenerator(SemanticsCheck chk) {
        this.checker = chk;
    }

    public List<MessageFromIf> getIncomingProposals() {
        return this.incomingProposal;
    }

    public List<MessageFromIf> getOutgoingProposals() {
        return this.outgoingProposal;
    }

    public void createProposals(Node node) {
        ActiveRules rules = this.checker.getActiveRules((GraphItem)node);
        if (rules == null) {
            return;
        }
        if (node.getSubgraph() != null) {
            return;
        }
        this.outgoingProposal.clear();
        this.incomingProposal.clear();
        for (AbstractInterfaceItem port : rules.getPortList()) {
            HashSet<EObject> messages = new HashSet<EObject>();
            for (CommonTrigger t : node.getCaughtTriggers()) {
                if (!t.getIfitem().equals(port)) continue;
                messages.add(t.getMsg());
            }
            if (!rules.getPortList().contains(port)) continue;
            for (SemanticsRule curRule : rules.getRulesForPort(port)) {
                if (messages.contains(curRule.getMsg())) continue;
                MessageFromIf mif = FSMFactory.eINSTANCE.createMessageFromIf();
                mif.setFrom(port);
                mif.setMessage(curRule.getMsg());
                boolean isOutgoing = port.getAllOutgoingAbstractMessages().contains((Object)curRule.getMsg());
                if (isOutgoing) {
                    this.outgoingProposal.add(mif);
                    continue;
                }
                this.incomingProposal.add(mif);
            }
        }
        if (traceProposals) {
            System.out.println("  Proposals for : " + FsmGenExtensions.getName((GraphItem)node));
            for (MessageFromIf msg : this.outgoingProposal) {
                System.out.println("    Outgoing msg proposal : " + msg.getFrom().getName() + "." + this.fsmNameProvider.getMessageName(msg.getMessage()) + "()");
            }
            for (MessageFromIf msg : this.incomingProposal) {
                System.out.println("    Incoming msg proposal : " + this.fsmNameProvider.getMessageName(msg.getMessage()) + " from " + msg.getFrom().getName());
            }
        }
    }

    static {
        String value;
        traceProposals = false;
        if (Activator.getDefault().isDebugging() && (value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/proposals")) != null && value.equalsIgnoreCase(Boolean.toString(true))) {
            traceProposals = true;
        }
    }
}

