/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.modelpath;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class ModelPathDescription {
    private final List<IContainer> sourceDirectories;
    private final List<IProject> projectDependencies;
    private final List<IMarker> problemMarkers;

    private ModelPathDescription(List<IContainer> sourceDirectories, List<IProject> projectDependencies, List<IMarker> problemMarkers) {
        this.sourceDirectories = sourceDirectories;
        this.projectDependencies = projectDependencies;
        this.problemMarkers = problemMarkers;
    }

    public List<IContainer> getSourceDirectories() {
        return this.sourceDirectories;
    }

    public List<IProject> getProjectDependencies() {
        return this.projectDependencies;
    }

    public List<IMarker> getProblemMarkers() {
        return this.problemMarkers;
    }

    public static ModelPathDescription load(IFile file) throws CoreException {
        try {
            return new ModelPathDescriptionLoader(file).load();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /* synthetic */ ModelPathDescription(List list, List list2, List list3, ModelPathDescription modelPathDescription) {
        this(list, list2, list3);
    }

    private static class ModelPathDescriptionLoader {
        private static final String KEYWORD_SRCDIR = "srcDir";
        private static final String KEYWORD_PROJECT = "project";
        private static final Pattern KEYWORD_PATTERN = Pattern.compile("\\S+");
        private IFile file;
        private IProject project;
        private IWorkspaceRoot root;
        private List<IContainer> srcDirs;
        private List<IProject> projects;
        private List<IMarker> problemMarkers;
        private int lineNumber;

        public ModelPathDescriptionLoader(IFile file) {
            this.file = file;
            this.project = file.getProject();
            this.root = ResourcesPlugin.getWorkspace().getRoot();
            this.srcDirs = new ArrayList<IContainer>();
            this.projects = new ArrayList<IProject>();
            this.problemMarkers = new ArrayList<IMarker>();
            this.lineNumber = 0;
        }

        public ModelPathDescription load() throws CoreException, IOException {
            this.file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.file.getContents()));){
                String line = reader.readLine();
                while (line != null) {
                    line = this.trimComments(line);
                    this.parseLine(line);
                    line = reader.readLine();
                    ++this.lineNumber;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new ModelPathDescription(Collections.unmodifiableList(this.srcDirs), Collections.unmodifiableList(this.projects), Collections.unmodifiableList(this.problemMarkers), null);
        }

        private void parseLine(String line) throws CoreException {
            block10: {
                Matcher matcher = KEYWORD_PATTERN.matcher(line);
                if (!matcher.find()) break block10;
                String keyword = matcher.group();
                String str = line.substring(matcher.end()).trim();
                switch (keyword) {
                    case "srcDir": {
                        this.parseSrcDir(str);
                        break;
                    }
                    case "project": {
                        this.parseProject(str);
                        break;
                    }
                    default: {
                        this.addProblemMarker(2, "unexpected keyword " + keyword);
                    }
                }
            }
        }

        private String trimComments(String line) {
            int index = line.indexOf("//");
            if (index != -1) {
                line = line.substring(0, index);
            }
            return line;
        }

        private void parseSrcDir(String str) throws CoreException {
            if (str.isEmpty()) {
                this.addProblemMarker(2, "directory path is missing");
                return;
            }
            if (!Path.EMPTY.isValidPath(str)) {
                this.addProblemMarker(2, String.valueOf(str) + " isn't a valid path");
                return;
            }
            try {
                IFolder dir = this.project.getFolder(str);
                if (!dir.exists()) {
                    this.addProblemMarker(1, "directory " + dir.getFullPath() + " doesn't exist");
                }
                this.srcDirs.add((IContainer)dir);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.addProblemMarker(2, String.valueOf(str) + " is not a valid directory");
            }
        }

        private void parseProject(String str) throws CoreException {
            if (str.isEmpty()) {
                this.addProblemMarker(2, "project name is missing");
                return;
            }
            if (!Path.EMPTY.isValidSegment(str)) {
                this.addProblemMarker(2, String.valueOf(str) + " isn't a valid project name");
                return;
            }
            IProject project = this.root.getProject(str);
            if (!project.isAccessible()) {
                this.addProblemMarker(1, "project " + project.getName() + " doesn't exist");
            }
            this.projects.add(project);
        }

        private void addProblemMarker(int severity, String message) throws CoreException {
            IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", severity);
            marker.setAttribute("lineNumber", this.lineNumber + 1);
            marker.setAttribute("message", (Object)message);
            this.problemMarkers.add(marker);
        }
    }
}

