/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.scoping;

import com.google.common.base.Predicates;
import com.google.inject.Inject;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.common.scoping.ModelLocatorUriResolver;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.etrice.generator.base.io.IModelPathProvider;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.AbstractScope;

public class ModelPathGlobalScopeProvider
extends AbstractGlobalScopeProvider {
    private IModelPathProvider modelPathProvider;
    private IQualifiedNameProvider qualifiedNameProvider;
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    private IModelPathFileFilter modelPathFileFilter;
    private ModelLocatorUriResolver uriResolver;

    @Inject
    public ModelPathGlobalScopeProvider(IModelPathProvider modelPathProvider, IQualifiedNameProvider qualifiedNameProvider, IResourceServiceProvider.Registry resourceServiceProviderRegistry, IModelPathFileFilter modelPathFileFilter, ModelLocatorUriResolver uriResolver) {
        this.modelPathProvider = modelPathProvider;
        this.qualifiedNameProvider = qualifiedNameProvider;
        this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
        this.modelPathFileFilter = modelPathFileFilter;
        this.uriResolver = uriResolver;
    }

    protected IScope getScope(Resource context, boolean ignoreCase, EClass type, com.google.common.base.Predicate<IEObjectDescription> filter) {
        return new ModelPathGlobalScope(ignoreCase, context, type, filter);
    }

    public AbstractScope getScope(IScope parent, Resource context, EReference reference, com.google.common.base.Predicate<IEObjectDescription> filter) {
        return new ModelPathGlobalScope(parent, this.isIgnoreCase(reference), context, reference.getEReferenceType(), filter);
    }

    private static final class FileDescriptionPair {
        public final IModelPath.ModelFile mf;
        public final IResourceDescription rd;

        public FileDescriptionPair(IModelPath.ModelFile modelFile, IResourceDescription resourceDescription) {
            this.mf = modelFile;
            this.rd = resourceDescription;
        }
    }

    @FunctionalInterface
    public static interface IModelPathFileFilter
    extends com.google.common.base.Predicate<IModelPath.ModelFile> {
    }

    private class ModelPathGlobalScope
    extends AbstractScope {
        private Resource context;
        private EClass type;
        private com.google.common.base.Predicate<IEObjectDescription> filter;

        public ModelPathGlobalScope(boolean ignoreCase, Resource context, EClass type, com.google.common.base.Predicate<IEObjectDescription> filter) {
            this(IScope.NULLSCOPE, ignoreCase, context, type, filter);
        }

        public ModelPathGlobalScope(IScope parent, boolean ignoreCase, Resource context, EClass type, com.google.common.base.Predicate<IEObjectDescription> filter) {
            super(parent, ignoreCase);
            this.context = context;
            this.type = type;
            this.filter = filter == null ? Predicates.alwaysTrue() : filter;
        }

        protected IEObjectDescription getSingleLocalElementByName(QualifiedName name) {
            return this.getResourceDescriptionsByName(name).flatMap(fdp -> this.getExportedObjectsByName((FileDescriptionPair)fdp, name)).findFirst().orElse(null);
        }

        protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
            return this.getResourceDescriptionsByName(name).flatMap(fdp -> this.getExportedObjectsByName((FileDescriptionPair)fdp, name)).collect(Collectors.toList());
        }

        protected Iterable<IEObjectDescription> getLocalElementsByEObject(EObject object, URI uri) {
            return this.getResourceDescriptionsByObject(object).flatMap(fdp -> this.getExportedObjectsByObject((FileDescriptionPair)fdp, object)).collect(Collectors.toList());
        }

        protected Iterable<IEObjectDescription> getAllLocalElements() {
            return this.getAllResourceDescriptions().flatMap(fdp -> this.getExportedObjectsByType((FileDescriptionPair)fdp, this.type)).collect(Collectors.toList());
        }

        private Stream<IEObjectDescription> getExportedObjectsByName(FileDescriptionPair fdp, QualifiedName name) {
            return this.filterEObjectDescriptions(fdp.rd.getExportedObjects(this.type, name, this.isIgnoreCase()), fdp.mf);
        }

        private Stream<IEObjectDescription> getExportedObjectsByType(FileDescriptionPair fdp, EClass type) {
            return this.filterEObjectDescriptions(fdp.rd.getExportedObjectsByType(type), fdp.mf);
        }

        private Stream<IEObjectDescription> getExportedObjectsByObject(FileDescriptionPair fdp, EObject object) {
            return this.filterEObjectDescriptions(fdp.rd.getExportedObjectsByObject(object), fdp.mf);
        }

        private Stream<IEObjectDescription> filterEObjectDescriptions(Iterable<IEObjectDescription> eods, IModelPath.ModelFile mf) {
            return StreamSupport.stream(eods.spliterator(), false).filter(eo -> eo.getQualifiedName().startsWith(modelFile.name)).filter(arg_0 -> this.filter.apply(arg_0));
        }

        private Stream<FileDescriptionPair> getResourceDescriptionsByObject(EObject object) {
            QualifiedName name = ModelPathGlobalScopeProvider.this.qualifiedNameProvider.getFullyQualifiedName(object);
            if (name != null) {
                return this.getResourceDescriptionsByName(name);
            }
            return Stream.empty();
        }

        private Stream<FileDescriptionPair> getResourceDescriptionsByName(QualifiedName name) {
            IModelPath modelPath = ModelPathGlobalScopeProvider.this.modelPathProvider.get(this.context);
            Stream.Builder<QualifiedName> builder = Stream.builder();
            while (!name.isEmpty()) {
                builder.add(name);
                name = name.skipLast(1);
            }
            Stream<IModelPath.ModelFile> files = builder.build().flatMap(n -> modelPath.getFiles(n));
            return this.getResourceDescriptions(files);
        }

        private Stream<FileDescriptionPair> getAllResourceDescriptions() {
            IModelPath modelPath = ModelPathGlobalScopeProvider.this.modelPathProvider.get(this.context);
            return this.getResourceDescriptions(modelPath.getAllFiles());
        }

        private Stream<FileDescriptionPair> getResourceDescriptions(Stream<IModelPath.ModelFile> files) {
            IResourceDescriptions descriptions = ModelPathGlobalScopeProvider.this.getResourceDescriptions(this.context);
            ResourceSet resourceSet = this.context.getResourceSet();
            return files.filter((Predicate<IModelPath.ModelFile>)((Object)ModelPathGlobalScopeProvider.this.modelPathFileFilter)).flatMap(mf -> this.getResourceDescription(mf.uri, descriptions, resourceSet).map(rd -> new FileDescriptionPair((IModelPath.ModelFile)mf, (IResourceDescription)rd)));
        }

        private Stream<IResourceDescription> getResourceDescription(URI uri, IResourceDescriptions descriptions, ResourceSet resourceSet) {
            IResourceDescription resourceDescription = descriptions.getResourceDescription(uri = this.resolveURI(uri));
            if (resourceDescription != null) {
                return Stream.of(resourceDescription);
            }
            IResourceServiceProvider resourceServiceProvider = ModelPathGlobalScopeProvider.this.resourceServiceProviderRegistry.getResourceServiceProvider(uri);
            if (resourceServiceProvider != null) {
                Resource resource = resourceSet.getResource(uri, true);
                IResourceDescription.Manager descriptionManager = resourceServiceProvider.getResourceDescriptionManager();
                resourceDescription = descriptionManager.getResourceDescription(resource);
                return Stream.of(resourceDescription);
            }
            return Stream.empty();
        }

        private URI resolveURI(URI uri) {
            String uriStr = ModelPathGlobalScopeProvider.this.uriResolver.resolve(uri.toString(), null);
            return URI.createURI((String)uriStr);
        }
    }
}

