/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room.util;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.base.util.ImportHelpers;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class InterfaceContractHelpers {
    public static final String InterfaceContract_NAME = "InterfaceContract";
    public static final String ContractClass_KEY = "definedBy";
    public static final String InterfaceContractDefinition_NAME = "InterfaceContractDefinition";
    public static final String Protocol_KEY = "protocol";
    public static final String GeneratedMonitorName_KEY = "generatedMonitorName";
    @Inject
    private RoomHelpers roomHelpers;
    @Inject
    private ImportHelpers importHelpers;
    @Inject
    private IQualifiedNameConverter fqnConverter;
    @Inject
    private IQualifiedNameProvider fqnProvider;

    public boolean hasContract(ProtocolClass pc) {
        return this.roomHelpers.isAnnotationPresent((List)pc.getAnnotations(), InterfaceContract_NAME);
    }

    public boolean isContract(ActorClass ac) {
        return this.roomHelpers.isAnnotationPresent((List)ac.getAnnotations(), InterfaceContractDefinition_NAME);
    }

    public ActorClass getInterfaceContractActorClass(ProtocolClass pc) {
        boolean bl;
        String name = this.roomHelpers.getAttribute((List)pc.getAnnotations(), InterfaceContract_NAME, ContractClass_KEY);
        boolean bl2 = Strings.isNullOrEmpty((String)name);
        boolean bl3 = bl = !bl2;
        if (bl) {
            EObject eObject = pc.eContainer();
            EObject match = this.findClassForName(name, RoomPackage.Literals.ACTOR_CLASS, (RoomModel)eObject);
            EObject eObject2 = null;
            eObject2 = match != null && match.eIsProxy() ? EcoreUtil.resolve((EObject)match, (ResourceSet)pc.eResource().getResourceSet()) : match;
            EObject resolved = eObject2;
            if (resolved instanceof ActorClass) {
                return (ActorClass)resolved;
            }
        }
        return null;
    }

    public ProtocolClass getContractProtocol(ActorClass ac) {
        boolean bl;
        String name = this.roomHelpers.getAttribute((List)ac.getAnnotations(), InterfaceContractDefinition_NAME, Protocol_KEY);
        boolean bl2 = Strings.isNullOrEmpty((String)name);
        boolean bl3 = bl = !bl2;
        if (bl) {
            EObject eObject = ac.eContainer();
            EObject eObject2 = this.findClassForName(name, RoomPackage.Literals.PROTOCOL_CLASS, (RoomModel)eObject);
            ProtocolClass match = (ProtocolClass)eObject2;
            ProtocolClass protocolClass = null;
            protocolClass = match != null && match.eIsProxy() ? EcoreUtil.resolve((EObject)match, (ResourceSet)ac.eResource().getResourceSet()) : match;
            ProtocolClass resolved = protocolClass;
            if (resolved instanceof ProtocolClass) {
                return resolved;
            }
        }
        return null;
    }

    public String getGeneratedMonitorName(ActorClass ac) {
        boolean bl;
        String userName = this.roomHelpers.getAttribute((List)ac.getAnnotations(), InterfaceContractDefinition_NAME, GeneratedMonitorName_KEY);
        String string = null;
        boolean bl2 = Strings.isNullOrEmpty((String)userName);
        boolean bl3 = bl = !bl2;
        if (bl) {
            string = userName;
        } else {
            String string2 = ac.getName();
            string = String.valueOf(string2) + "_GeneratedMontior";
        }
        return string;
    }

    public Pair<List<Port>, List<Port>> getContractPorts(ActorClass ac, final ProtocolClass contractProtocol) {
        Pair pair = null;
        List<Port> allPorts = this.roomHelpers.getAllEndPorts(ac);
        Functions.Function1<Port, Boolean> function1 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return Objects.equal((Object)it.getProtocol(), (Object)contractProtocol) && !it.isConjugated();
            }
        };
        ArrayList regularPorts = CollectionLiterals.newArrayList((Object[])((Port[])Conversions.unwrapArray((Object)IterableExtensions.filter(allPorts, (Functions.Function1)function1), Port.class)));
        Functions.Function1<Port, Boolean> function12 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return Objects.equal((Object)it.getProtocol(), (Object)contractProtocol) && it.isConjugated();
            }
        };
        ArrayList conjugatedPorts = CollectionLiterals.newArrayList((Object[])((Port[])Conversions.unwrapArray((Object)IterableExtensions.filter(allPorts, (Functions.Function1)function12), Port.class)));
        pair = Pair.of((Object)regularPorts, (Object)conjugatedPorts);
        return pair;
    }

    private EObject findClassForName(String name, final EClass type, RoomModel currentModel) {
        EObject eObject = null;
        final QualifiedName fqn = this.fqnConverter.toQualifiedName(name);
        QualifiedName modelFQN = this.fqnProvider.getFullyQualifiedName((EObject)currentModel);
        EObject eObject2 = null;
        if (fqn.getSegmentCount() == 1 || fqn.startsWith(modelFQN)) {
            Functions.Function1<EObject, Boolean> function1 = new Functions.Function1<EObject, Boolean>(){

                public Boolean apply(EObject it) {
                    return type.isSuperTypeOf(it.eClass());
                }
            };
            Functions.Function1<RoomClass, Boolean> function12 = new Functions.Function1<RoomClass, Boolean>(){

                public Boolean apply(RoomClass it) {
                    String string = it.getName();
                    String string2 = fqn.getLastSegment();
                    return Objects.equal((Object)string, (Object)string2);
                }
            };
            eObject2 = (EObject)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IterableExtensions.filter((Iterable)currentModel.eContents(), (Functions.Function1)function1), RoomClass.class), (Functions.Function1)function12);
        } else {
            boolean bl;
            EObject eObject3 = null;
            Resource resource = currentModel.eResource();
            boolean bl2 = bl = resource != null;
            if (bl) {
                IEObjectDescription iEObjectDescription = this.importHelpers.getVisibleScope(currentModel.eResource(), type).getSingleElement(fqn);
                EObject eObject4 = null;
                if (iEObjectDescription != null) {
                    eObject4 = iEObjectDescription.getEObjectOrProxy();
                }
                eObject3 = eObject4;
            }
            eObject2 = eObject3;
        }
        eObject = eObject2;
        return eObject;
    }
}

