/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.etunit.converter;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.etrice.etunit.converter.Etunit.DocumentRoot;
import org.eclipse.etrice.etunit.converter.Etunit.EtunitFactory;
import org.eclipse.etrice.etunit.converter.Etunit.EtunitPackage;
import org.eclipse.etrice.etunit.converter.Etunit.FailureType;
import org.eclipse.etrice.etunit.converter.Etunit.SkippedType;
import org.eclipse.etrice.etunit.converter.Etunit.TestcaseType;
import org.eclipse.etrice.etunit.converter.Etunit.TestsuiteType;
import org.eclipse.etrice.etunit.converter.Etunit.TestsuitesType;
import org.eclipse.etrice.etunit.converter.Etunit.util.EtunitResourceFactoryImpl;

public class EtUnitReportConverter {
    private static final String TC_END = "tc end";
    private static final String TC_FAIL = "tc fail";
    private static final String TC_SKIP = "tc skip";
    private static final String TC_START = "tc start";
    private static final String TS_START = "ts start: ";
    public static final String ETU_EXTENSION = ".etu";
    public static final String OPTION_COMBINED = "-combined";
    public static final String OPTION_ONLY_COMBINED = "-only_combined";
    public static final String OPTION_SUITE_NAME = "-suite";
    public static final String OPTION_SUITE_NAME_PREFIX = "-presuite";

    protected void printUsage() {
        System.err.println("usage: EtUnitReportConverter [(-combined|-only_combined) <combined file>] [-suite <name>] <*.etu files>\n    -combined <combined file>: also save a combined result for all tests to the specified file\n    -only_combined <combined file>: don't create reports for every single test, only combined one to the specified file\n    -suite <name>: replace the suite name in the result\n    -presuite <prefix>: prefix the prefix to the suitename\n");
    }

    public static void main(String[] args) {
        int result = new EtUnitReportConverter().run(args);
        System.exit(result);
    }

    public int run(String[] args) {
        Options options = this.parseOptions(args);
        if (options == null) {
            return 1;
        }
        this.doEMFRegistration();
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new EtunitResourceFactoryImpl());
        boolean success = this.saveReports(options, (ResourceSet)rs);
        if (options.needCombined()) {
            success &= this.saveCombined(this.createCombinedReport((ResourceSet)rs), options, (ResourceSet)rs);
        }
        return success ? 0 : 2;
    }

    public List<String> convert(BaseOptions options, Iterable<InputStream> etUnitStreams) {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new EtunitResourceFactoryImpl());
        boolean success = this.saveReports(options, etUnitStreams, (ResourceSet)rs);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (options.needCombined()) {
            DocumentRoot root = this.createCombinedReport((ResourceSet)rs);
            Resource res = rs.createResource(URI.createURI((String)("dummy:/" + UUID.randomUUID() + ".xml")));
            res.getContents().add((Object)root);
            resources.add(res);
        } else {
            resources.addAll((Collection<Resource>)rs.getResources());
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Resource res : resources) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                res.save((OutputStream)output, null);
                result.add(output.toString(StandardCharsets.UTF_8.name()));
            }
            catch (IOException e) {
                System.err.println("Error: could not serialize report");
                e.printStackTrace();
                success = false;
            }
        }
        return success ? result : Collections.emptyList();
    }

    protected Options parseOptions(String[] args) {
        Options options = new Options();
        if (!options.parseOptions(args)) {
            this.printUsage();
            return null;
        }
        return options;
    }

    private DocumentRoot createCombinedReport(ResourceSet rs) {
        DocumentRoot root = EtunitFactory.eINSTANCE.createDocumentRoot();
        TestsuitesType testsuites = EtunitFactory.eINSTANCE.createTestsuitesType();
        root.setTestsuites(testsuites);
        for (Resource res : rs.getResources()) {
            DocumentRoot r = (DocumentRoot)res.getContents().get(0);
            testsuites.getTestsuite().addAll(r.getTestsuites().getTestsuite());
        }
        this.computeAndSetInfo(testsuites);
        return root;
    }

    protected boolean saveCombined(DocumentRoot root, Options options, ResourceSet rs) {
        if (options.isCombinedResults()) {
            File report = new File(options.getCombinedFile());
            return this.saveJUnitReport(root, report, rs, true);
        }
        return true;
    }

    protected boolean saveReports(BaseOptions options, Iterable<InputStream> etUnitStreams, ResourceSet rs) {
        boolean success = true;
        for (InputStream stream : etUnitStreams) {
            DocumentRoot root = this.applyOptions(options, this.createParseTree(stream, options));
            if (!(success &= root != null)) continue;
            Resource resource = rs.createResource(URI.createURI((String)("dummy:/" + UUID.randomUUID() + ".xml")));
            resource.getContents().add((Object)root);
        }
        return success;
    }

    protected boolean saveReports(Options options, ResourceSet rs) {
        boolean success = true;
        for (String file : options.getFiles()) {
            File report = new File(file);
            if (report.exists()) {
                DocumentRoot root = this.applyOptions(options, this.createParseTree(report, (BaseOptions)options));
                success &= root != null && this.saveJUnitReport(root, report, rs, !options.isCombinedResults());
                continue;
            }
            System.err.println("Error: report " + file + " does not exist");
            success = false;
        }
        return success;
    }

    protected DocumentRoot applyOptions(BaseOptions options, DocumentRoot root) {
        if (root != null && options.isReplaceSuiteName() && root.getTestsuites() != null) {
            if (root.getTestsuites().getTestsuite().size() == 1) {
                ((TestsuiteType)root.getTestsuites().getTestsuite().get(0)).setName(options.getSuiteName());
            } else {
                int i = 0;
                for (TestsuiteType suite : root.getTestsuites().getTestsuite()) {
                    suite.setName(String.valueOf(options.getSuiteName()) + i);
                    ++i;
                }
            }
        }
        if (root != null && options.isPrefixSuiteName() && root.getTestsuites() != null) {
            for (TestsuiteType suite : root.getTestsuites().getTestsuite()) {
                suite.setName(String.valueOf(options.getSuiteNamePrefix()) + suite.getName());
            }
        }
        return root;
    }

    private boolean saveJUnitReport(DocumentRoot root, File report, ResourceSet rs, boolean save) {
        URI uri = URI.createFileURI((String)report.toString());
        uri = uri.trimFileExtension();
        uri = uri.appendFileExtension("xml");
        Resource resource = rs.createResource(uri);
        resource.getContents().add((Object)root);
        if (save) {
            try {
                resource.save(Collections.EMPTY_MAP);
                System.out.println("saved " + uri);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Error: file " + uri + " could not be saved (" + e.getMessage() + ")");
                return false;
            }
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private DocumentRoot createParseTree(File report, BaseOptions options) {
        FileReader input = null;
        input = new FileReader(report.toString());
        BufferedReader bufRead = new BufferedReader(input);
        DocumentRoot documentRoot = this.createParseTree(bufRead, options);
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {}
        return documentRoot;
        catch (IOException e) {
            try {
                System.err.println("Error: file " + report + " could not be read (" + e.getMessage() + ")");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private DocumentRoot createParseTree(InputStream etUnitStream, BaseOptions options) {
        try {
            return this.createParseTree(new BufferedReader(new InputStreamReader(etUnitStream)), options);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DocumentRoot createParseTree(BufferedReader bufRead, BaseOptions options) throws IOException {
        int count = 0;
        try {
            if (options.checkEtUnitHeader) {
                String line = bufRead.readLine();
                ++count;
                if (line == null) {
                    System.err.println("Error: etUnit report is empty - no etunit file");
                    return null;
                }
                if (!line.equals("etUnit report")) {
                    System.err.println("Error: in etUnt report line " + line + " is missing header line - no etunit file");
                    return null;
                }
            }
            HashMap<Integer, TestcaseType> id2case = new HashMap<Integer, TestcaseType>();
            TestsuiteType currentSuite = null;
            DocumentRoot root = EtunitFactory.eINSTANCE.createDocumentRoot();
            TestsuitesType testsuites = EtunitFactory.eINSTANCE.createTestsuitesType();
            root.setTestsuites(testsuites);
            String line = bufRead.readLine();
            ++count;
            while (true) {
                int id;
                int pos;
                if (line == null) {
                    this.computeAndSetInfo(testsuites);
                    return root;
                }
                if (line.startsWith(TS_START)) {
                    currentSuite = EtunitFactory.eINSTANCE.createTestsuiteType();
                    currentSuite.setName(line.substring(TS_START.length(), line.length()));
                    testsuites.getTestsuite().add((Object)currentSuite);
                } else if (line.startsWith(TC_START)) {
                    pos = line.indexOf(58);
                    id = Integer.parseInt(line.substring(9, pos));
                    TestcaseType tc = EtunitFactory.eINSTANCE.createTestcaseType();
                    tc.setName(line.substring(pos + 2));
                    id2case.put(id, tc);
                    currentSuite.getTestcase().add((Object)tc);
                } else if (line.startsWith(TC_FAIL)) {
                    String actualMsg;
                    pos = line.indexOf(58);
                    id = Integer.parseInt(line.substring(8, pos));
                    TestcaseType tc = (TestcaseType)id2case.get(id);
                    if (tc == null) {
                        System.err.println("Error: in etUnit report line " + count + " - unknown test case id");
                        return null;
                    }
                    FailureType fail = EtunitFactory.eINSTANCE.createFailureType();
                    pos = line.indexOf(35) + 1;
                    int end = line.indexOf(35, pos);
                    String expectedMsg = end > pos ? "expected=" + line.substring(pos, end) : "";
                    pos = end + 1;
                    end = line.indexOf(35, pos);
                    String string = actualMsg = end > pos ? " actual=" + line.substring(pos, end) : "";
                    if (!(String.valueOf(expectedMsg) + actualMsg).isEmpty()) {
                        fail.setMessage(String.valueOf(expectedMsg) + actualMsg);
                    }
                    String loc = (end = line.indexOf(35, pos = end + 1)) > pos ? line.substring(pos, end) : null;
                    pos = line.lastIndexOf(35);
                    String trace = line.substring(pos + 1);
                    if (loc != null) {
                        trace = String.valueOf(trace) + "\n at " + loc;
                    }
                    FeatureMapUtil.addText((FeatureMap)fail.getMixed(), (String)trace);
                    tc.getFailure().add((Object)fail);
                } else if (line.startsWith(TC_END)) {
                    pos = line.indexOf(58);
                    id = Integer.parseInt(line.substring(7, pos));
                    int time = Integer.parseInt(line.substring(pos + 2));
                    TestcaseType tc = (TestcaseType)id2case.get(id);
                    if (tc == null) {
                        System.err.println("Error: in etUnit report line " + count + " - unknown test case id");
                        return null;
                    }
                    tc.setTime(BigDecimal.valueOf((double)time / 1000.0).toString());
                } else if (line.startsWith(TC_SKIP)) {
                    pos = line.indexOf(58);
                    id = Integer.parseInt(line.substring(8, pos));
                    TestcaseType tc = (TestcaseType)id2case.get(id);
                    if (tc == null) {
                        System.err.println("Error: in etUnit report line " + count + " - unknown test case id");
                        return null;
                    }
                    SkippedType skip = EtunitFactory.eINSTANCE.createSkippedType();
                    String msg = line.substring(pos + 1).trim();
                    if (!msg.isEmpty()) {
                        skip.setMessage(msg);
                    }
                    tc.setSkipped(skip);
                }
                line = bufRead.readLine();
                ++count;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error: in etUnit report line " + count + " - could not read number");
            return null;
        }
    }

    private void computeAndSetInfo(TestsuitesType testsuites) {
        for (TestsuiteType ts : testsuites.getTestsuite()) {
            int failures = 0;
            int skipped = 0;
            BigDecimal time = new BigDecimal(0);
            for (TestcaseType tc : ts.getTestcase()) {
                if (tc.getTime() != null) {
                    time = time.add(new BigDecimal(tc.getTime()));
                }
                failures += tc.getFailure().size();
                skipped += tc.getSkipped() != null ? 1 : 0;
            }
            ts.setTests(Integer.toString(ts.getTestcase().size()));
            ts.setFailures(Integer.toString(failures));
            if (skipped > 0) {
                ts.setSkipped(Integer.toString(skipped));
            }
            ts.setTime(time.toString());
        }
    }

    private void doEMFRegistration() {
        if (!EPackage.Registry.INSTANCE.containsKey((Object)"platform:/resource/org.eclipse.etrice.etunit.converter/model/etunit.xsd")) {
            EPackage.Registry.INSTANCE.put((Object)"platform:/resource/org.eclipse.etrice.etunit.converter/model/etunit.xsd", (Object)EtunitPackage.eINSTANCE);
        }
    }

    public static class BaseOptions {
        private boolean combinedResults = false;
        private boolean replaceSuiteName = false;
        private boolean prefixSuiteName = false;
        private boolean onlyCombinedResults = false;
        private String combinedFile = null;
        private String suiteName = null;
        private String suiteNamePrefix = null;
        private boolean checkEtUnitHeader = true;

        public boolean isCombinedResults() {
            return this.combinedResults;
        }

        public void setCombinedResults(boolean combinedResults) {
            this.combinedResults = combinedResults;
        }

        public boolean isReplaceSuiteName() {
            return this.replaceSuiteName;
        }

        public void setReplaceSuiteName(boolean replaceSuiteName) {
            this.replaceSuiteName = replaceSuiteName;
        }

        public boolean isPrefixSuiteName() {
            return this.prefixSuiteName;
        }

        public void setPrefixSuiteName(boolean appendSuiteName) {
            this.prefixSuiteName = appendSuiteName;
        }

        public boolean isOnlyCombinedResults() {
            return this.onlyCombinedResults;
        }

        public void setOnlyCombinedResults(boolean onlyCombinedResults) {
            this.onlyCombinedResults = onlyCombinedResults;
        }

        public String getCombinedFile() {
            return this.combinedFile;
        }

        public void setCombinedFile(String combinedFile) {
            this.combinedFile = combinedFile;
        }

        public String getSuiteName() {
            return this.suiteName;
        }

        public void setSuiteName(String suiteName) {
            this.suiteName = suiteName;
        }

        public String getSuiteNamePrefix() {
            return this.suiteNamePrefix;
        }

        public void setSuiteNamePrefix(String suiteNamePrefix) {
            this.suiteNamePrefix = suiteNamePrefix;
        }

        public boolean needCombined() {
            return this.combinedResults;
        }

        public boolean checkEtUnitHeader() {
            return this.checkEtUnitHeader;
        }

        public void setCheckEtUnitHeader(boolean checkEtUnitHeader) {
            this.checkEtUnitHeader = checkEtUnitHeader;
        }
    }

    public static class Options
    extends BaseOptions {
        private ArrayList<String> files = new ArrayList();

        public ArrayList<String> getFiles() {
            return this.files;
        }

        public void setFiles(ArrayList<String> files) {
            this.files = files;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean parseOptions(String[] args) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals(EtUnitReportConverter.OPTION_COMBINED)) {
                    this.setCombinedResults(true);
                    if (++i >= args.length) {
                        System.err.println("Error: -combined must be followed by filename");
                        return false;
                    }
                    this.setCombinedFile(args[i]);
                } else if (args[i].equals(EtUnitReportConverter.OPTION_SUITE_NAME)) {
                    this.setReplaceSuiteName(true);
                    if (++i >= args.length) {
                        System.err.println("Error: -suite must be followed by a suite name");
                        return false;
                    }
                    this.setSuiteName(args[i]);
                } else if (args[i].equals(EtUnitReportConverter.OPTION_SUITE_NAME_PREFIX)) {
                    this.setPrefixSuiteName(true);
                    if (++i >= args.length) {
                        System.err.println("Error: -presuitemust be followed by a suite name prefix");
                        return false;
                    }
                    this.setSuiteNamePrefix(args[i]);
                } else if (args[i].equals(EtUnitReportConverter.OPTION_ONLY_COMBINED)) {
                    this.setCombinedResults(true);
                    this.setOnlyCombinedResults(true);
                    if (++i >= args.length) {
                        System.err.println("Error: -only_combined must be followed by filename");
                        return false;
                    }
                    this.setCombinedFile(args[i]);
                } else if (args[i].startsWith("-")) {
                    int nextOption = this.parseOption(args, i);
                    if (nextOption < 0) {
                        System.err.println("Error: unknown option " + args[i]);
                        return false;
                    }
                    i = nextOption;
                } else {
                    if (!args[i].endsWith(EtUnitReportConverter.ETU_EXTENSION)) {
                        System.err.println("Error: invalid file name '" + args[i] + "' (only *" + EtUnitReportConverter.ETU_EXTENSION + " files allowed)");
                        return false;
                    }
                    this.getFiles().add(args[i]);
                }
                ++i;
            }
            if (this.getFiles().isEmpty()) {
                System.err.println("Error: no reports specified");
                return false;
            }
            return true;
        }

        protected int parseOption(String[] args, int i) {
            return -1;
        }
    }
}

