/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.generator.base.GeneratorException;
import org.eclipse.etrice.generator.base.IGenerator;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.args.Options;
import org.eclipse.etrice.generator.base.cli.CommandLineParseException;
import org.eclipse.etrice.generator.base.cli.ICommandLineParser;
import org.eclipse.etrice.generator.base.cli.IHelpFormatter;
import org.eclipse.etrice.generator.base.io.GeneratorFileIO;
import org.eclipse.etrice.generator.base.io.IGeneratorResourceLoader;
import org.eclipse.etrice.generator.base.io.ILineOutput;
import org.eclipse.etrice.generator.base.io.LineOutput;
import org.eclipse.etrice.generator.base.logging.Logger;
import org.eclipse.etrice.generator.base.logging.Loglevel;
import org.eclipse.etrice.generator.base.setup.GeneratorApplicationOptions;
import org.eclipse.etrice.generator.base.setup.GeneratorName;
import org.eclipse.etrice.generator.base.setup.GeneratorOptions;
import org.eclipse.etrice.generator.base.validation.IGeneratorResourceValidator;

public class GeneratorApplication {
    private String name;
    private Options options;
    private ICommandLineParser commandLineParser;
    private IHelpFormatter helpFormatter;
    private Provider<Logger> loggerProvider;
    private Provider<GeneratorFileIO> fileIOProvider;
    private IGenerator generator;
    private IGeneratorResourceLoader resourceLoader;
    private IGeneratorResourceValidator resourceValidator;

    public static GeneratorApplication create(Module module) {
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        GeneratorApplication genAppl = (GeneratorApplication)injector.getInstance(GeneratorApplication.class);
        return genAppl;
    }

    public static GeneratorApplication create(String moduleName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Module module = (Module)Class.forName(moduleName).newInstance();
        return GeneratorApplication.create(module);
    }

    @Inject
    public GeneratorApplication(@GeneratorName String name, GeneratorOptions optionsModule, ICommandLineParser commandLineParser, IHelpFormatter helpFormatter, Provider<Logger> loggerProvider, Provider<GeneratorFileIO> fileIOProvider, IGenerator generator, IGeneratorResourceLoader resourceLoader, IGeneratorResourceValidator resourceValidator) {
        this.name = name;
        this.options = new Options(new GeneratorApplicationOptions(), optionsModule);
        this.commandLineParser = commandLineParser;
        this.helpFormatter = helpFormatter;
        this.loggerProvider = loggerProvider;
        this.fileIOProvider = fileIOProvider;
        this.generator = generator;
        this.resourceLoader = resourceLoader;
        this.resourceValidator = resourceValidator;
    }

    public void run(String[] args) throws GeneratorException {
        this.run(args, (ILineOutput)new LineOutput());
    }

    public void run(String[] args, ILineOutput out) throws GeneratorException {
        try {
            Arguments arguments = this.commandLineParser.parseArgs(this.options, GeneratorApplicationOptions.FILES, args);
            if (arguments.get(GeneratorApplicationOptions.HELP).booleanValue()) {
                this.printHelp(out);
            } else {
                this.run(arguments, out);
            }
        }
        catch (CommandLineParseException e) {
            out.println("Error: " + e.getMessage());
            this.printHelp(out);
            throw new GeneratorException(e);
        }
    }

    public void run(Arguments arguments, ILineOutput out) throws GeneratorException {
        Logger logger = this.createLogger(arguments, out);
        try {
            GeneratorFileIO fileIO = this.createGeneratorFileIO(arguments, logger);
            this.logArguments(arguments, fileIO, logger);
            List<Resource> resources = this.load(arguments, logger);
            this.validate(resources, arguments, logger);
            this.generate(resources, arguments, fileIO, logger);
            this.cleanOutputDirectory(arguments, fileIO, logger);
        }
        catch (Exception e) {
            this.logException(e, logger);
            throw e;
        }
    }

    public String getName() {
        return this.name;
    }

    public Options getOptions() {
        return this.options;
    }

    public Arguments createArguments() {
        return new Arguments(this.getOptions());
    }

    private void printHelp(ILineOutput out) {
        String help = this.helpFormatter.getHelp(this.name, this.options, GeneratorApplicationOptions.FILES);
        out.println(help);
    }

    private Logger createLogger(Arguments arguments, ILineOutput out) {
        Logger logger = (Logger)this.loggerProvider.get();
        logger.setLoglevel(arguments.get(GeneratorApplicationOptions.LOGLEVEL));
        logger.setOutput(out);
        return logger;
    }

    private GeneratorFileIO createGeneratorFileIO(Arguments arguments, Logger logger) {
        GeneratorFileIO fileIO = (GeneratorFileIO)this.fileIOProvider.get();
        fileIO.setOutputDirectory(arguments.get(GeneratorApplicationOptions.GEN_DIR));
        fileIO.setLogger(logger);
        return fileIO;
    }

    private List<Resource> load(Arguments arguments, Logger logger) {
        List<String> files = Arrays.asList(arguments.get(GeneratorApplicationOptions.FILES));
        List<String> modelpath = Arrays.asList(arguments.get(GeneratorApplicationOptions.MODELPATH));
        return this.resourceLoader.load(files, modelpath, arguments, logger);
    }

    private void validate(List<Resource> models, Arguments arguments, Logger logger) {
        this.resourceValidator.validate(models, arguments, logger);
    }

    private void generate(List<Resource> resources, Arguments arguments, GeneratorFileIO fileIO, Logger logger) {
        this.generator.generate(resources, arguments, fileIO, logger);
    }

    private void cleanOutputDirectory(Arguments arguments, GeneratorFileIO fileIO, Logger logger) {
        if (arguments.get(GeneratorApplicationOptions.CLEAN).booleanValue()) {
            fileIO.cleanOutputDirectory();
        }
    }

    private void logArguments(Arguments arguments, GeneratorFileIO fileIO, Logger logger) {
        logger.logDebug("arguments: " + arguments);
        logger.logDebug("output directory: " + fileIO.getOutputDirectory().toAbsolutePath());
    }

    private void logException(Exception e, Logger logger) {
        if (Loglevel.DEBUG.compareTo(logger.getLoglevel()) >= 0) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logger.logDebug(sw.toString());
        }
    }
}

