/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.logging;

import org.eclipse.etrice.generator.base.io.ILineOutput;
import org.eclipse.etrice.generator.base.io.LineOutput;
import org.eclipse.etrice.generator.base.logging.ILineOutputLogger;
import org.eclipse.etrice.generator.base.logging.Loglevel;

public class Logger
implements ILineOutputLogger,
ILineOutput {
    private static final String DEBUG_PREFIX = "[DEBUG]   ";
    private static final String INFO_PREFIX = "[INFO]    ";
    private static final String WARNING_PREFIX = "[WARNING] ";
    private static final String ERROR_PREFIX = "[ERROR]   ";
    private Loglevel loglevel;
    private ILineOutput output;

    public Logger() {
        this(Loglevel.WARNING, new LineOutput());
    }

    public Logger(Loglevel loglevel) {
        this(loglevel, new LineOutput());
    }

    public Logger(ILineOutput out) {
        this(Loglevel.WARNING, out);
    }

    public Logger(Loglevel loglevel, ILineOutput out) {
        this.setLoglevel(loglevel);
        this.setOutput(out);
    }

    @Override
    public void logDebug(String text) {
        if (Loglevel.DEBUG.compareTo(this.loglevel) >= 0) {
            this.println(DEBUG_PREFIX + text);
        }
    }

    @Override
    public void logInfo(String text) {
        if (Loglevel.INFO.compareTo(this.loglevel) >= 0) {
            this.println(INFO_PREFIX + text);
        }
    }

    @Override
    public void logWarning(String text) {
        if (Loglevel.WARNING.compareTo(this.loglevel) >= 0) {
            this.println(WARNING_PREFIX + text);
        }
    }

    @Override
    public void logError(String text) {
        if (Loglevel.ERROR.compareTo(this.loglevel) >= 0) {
            this.println(ERROR_PREFIX + text);
        }
    }

    @Override
    public Loglevel getLoglevel() {
        return this.loglevel;
    }

    @Override
    public void setLoglevel(Loglevel loglevel) {
        this.loglevel = loglevel;
    }

    @Override
    public void setOutput(ILineOutput out) {
        this.output = out;
    }

    @Override
    public void println(String txt) {
        this.output.println(txt);
    }
}

