/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.base;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.generator.fsm.base.IFSMTranslationProvider;

public class FSMDetailCodeTranslator {
    protected IFSMTranslationProvider provider;
    protected EObject container;
    protected boolean doTranslate;
    private boolean isPrepared = false;
    private FSMNameProvider fsmNameProvider = new FSMNameProvider();
    protected HashMap<String, AbstractInterfaceItem> name2item = new HashMap();

    public FSMDetailCodeTranslator(ModelComponent container, IFSMTranslationProvider provider, boolean doTranslate) {
        this((EObject)container, provider, doTranslate);
    }

    protected FSMDetailCodeTranslator(EObject container, IFSMTranslationProvider provider, boolean doTranslate) {
        this.provider = provider;
        this.container = container;
        this.doTranslate = doTranslate;
    }

    protected void prepare() {
        this.provider.setContainerClass(this.container);
        if (this.container instanceof ModelComponent) {
            ModelComponent mc = (ModelComponent)this.container;
            EList items = mc.getAllAbstractInterfaceItems();
            for (AbstractInterfaceItem item : items) {
                this.name2item.put(item.getName(), item);
            }
        }
    }

    public String translateDetailCode(DetailCode code) {
        if (code == null) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        for (String line : code.getLines()) {
            text.append(String.valueOf(line) + "\n");
        }
        String result = text.substring(0, Math.max(0, text.length() - 1));
        if (!this.doTranslate) {
            return result;
        }
        if (this.provider.translateMembers()) {
            result = this.translateText(result);
        }
        if (this.provider.translateTags()) {
            result = this.translateTags(result, code);
        }
        return result;
    }

    public String translateText(String text) {
        if (!this.isPrepared) {
            this.isPrepared = true;
            this.prepare();
        }
        StringBuilder result = new StringBuilder();
        Position curr = new Position();
        int last = 0;
        while (curr.pos < text.length()) {
            this.proceedToToken(text, curr);
            last = this.appendParsed(text, curr, last, result);
            String token = this.getToken(text, curr);
            if (token.isEmpty()) {
                if (curr.pos < text.length() && !this.isTokenChar(text.charAt(curr.pos))) {
                    ++curr.pos;
                }
                last = this.appendParsed(text, curr, last, result);
                continue;
            }
            String translated = this.translateToken(text, curr, last, token);
            if (translated != null) {
                last = curr.pos;
                result.append(translated);
                continue;
            }
            last = this.appendParsed(text, curr, last, result);
        }
        return result.toString();
    }

    protected String translateTags(String text, DetailCode code) {
        StringBuilder result = new StringBuilder();
        int last = 0;
        int next = text.indexOf("<|", last);
        while (next >= 0) {
            result.append(text.substring(last, next));
            last = next + "<|".length();
            next = text.indexOf("|>", last);
            if (next < 0) break;
            String tag = text.substring(last, next);
            result.append(this.provider.translateTag(tag, code));
            last = next + "|>".length();
            next = text.indexOf("<|", last);
        }
        result.append(text.substring(last));
        return result.toString();
    }

    protected String translateToken(String text, Position curr, int last, String token) {
        String translated = null;
        AbstractInterfaceItem item = this.name2item.get(token);
        if (item != null) {
            EObject msg;
            int start = curr.pos;
            String index = this.getArrayIndex(text, curr);
            if (index == null) {
                curr.pos = start;
            }
            if ((msg = this.getMessage(text, curr, item, true)) != null) {
                ArrayList<String> args = this.getArgs(text, curr);
                if (args != null && this.argsMatching(msg, args)) {
                    int i = 0;
                    while (i < args.size()) {
                        String transArg = this.translateText(args.remove(i));
                        args.add(i, transArg);
                        ++i;
                    }
                    String orig = text.substring(last, curr.pos);
                    translated = this.provider.getInterfaceItemMessageText(item, msg, args, index, orig);
                }
            } else {
                curr.pos = start;
                translated = this.translateInterfaceItemToken(item, text, curr, last, token);
            }
        }
        return translated;
    }

    protected String translateInterfaceItemToken(AbstractInterfaceItem item, String text, Position curr, int last, String token) {
        return null;
    }

    protected EObject getMessage(String text, Position curr, AbstractInterfaceItem item, boolean outgoing) {
        this.proceedToToken(text, curr);
        if (curr.pos >= text.length() || text.charAt(curr.pos) != '.') {
            return null;
        }
        ++curr.pos;
        this.proceedToToken(text, curr);
        String token = this.getToken(text, curr);
        EList messages = outgoing ? item.getAllOutgoingAbstractMessages() : item.getAllIncomingAbstractMessages();
        for (EObject message : messages) {
            if (!this.fsmNameProvider.getMessageName(message).equals(token)) continue;
            return message;
        }
        return null;
    }

    protected String getArrayIndex(String text, Position curr) {
        this.proceedToToken(text, curr);
        if (curr.pos >= text.length() || text.charAt(curr.pos) != '[') {
            return null;
        }
        ++curr.pos;
        String token = this.getIndex(text, curr);
        if (curr.pos >= text.length() || text.charAt(curr.pos) != ']') {
            return null;
        }
        ++curr.pos;
        return this.translateText(token);
    }

    protected int appendParsed(String text, Position curr, int last, StringBuilder result) {
        String str = text.substring(last, curr.pos);
        result.append(str);
        return curr.pos;
    }

    protected void proceedToToken(String text, Position curr) {
        this.proceedToToken(text, curr, true);
    }

    protected void proceedToToken(String text, Position curr, boolean skipString) {
        boolean stop = false;
        while (curr.pos < text.length() && !stop) {
            if (text.charAt(curr.pos) == '\"') {
                if (skipString) {
                    this.skipString(text, curr);
                    continue;
                }
                stop = true;
                continue;
            }
            if (text.charAt(curr.pos) == '/') {
                if (curr.pos + 1 < text.length()) {
                    if (text.charAt(curr.pos + 1) == '/') {
                        this.skipSingleComment(text, curr);
                        continue;
                    }
                    if (text.charAt(curr.pos + 1) == '*') {
                        this.skipMultiComment(text, curr);
                        continue;
                    }
                    stop = true;
                    continue;
                }
                stop = true;
                continue;
            }
            if (Character.isWhitespace(text.charAt(curr.pos))) {
                this.skipWhiteSpace(text, curr);
                continue;
            }
            stop = true;
        }
    }

    protected ArrayList<String> getArgs(String text, Position curr) {
        this.proceedToToken(text, curr);
        if (curr.pos >= text.length() || text.charAt(curr.pos) != '(') {
            return null;
        }
        ++curr.pos;
        ArrayList<String> result = new ArrayList<String>();
        boolean stop = false;
        do {
            this.proceedToToken(text, curr, false);
            if (curr.pos < text.length() && text.charAt(curr.pos) != ')') {
                String arg = this.getParam(text, curr);
                result.add(arg);
                this.proceedToToken(text, curr);
            }
            if (curr.pos < text.length() && text.charAt(curr.pos) == ',') {
                ++curr.pos;
                continue;
            }
            stop = true;
        } while (!stop);
        if (curr.pos >= text.length() || text.charAt(curr.pos) != ')') {
            return null;
        }
        ++curr.pos;
        return result;
    }

    protected String getToken(String text, Position curr) {
        int begin = curr.pos;
        while (curr.pos < text.length() && this.isTokenChar(text.charAt(curr.pos))) {
            ++curr.pos;
        }
        String token = text.substring(begin, curr.pos);
        return token;
    }

    protected String getParam(String text, Position curr) {
        int begin = curr.pos;
        int parenthesisLevel = 0;
        boolean inStringLiteral = false;
        boolean escaped = false;
        while (curr.pos < text.length()) {
            char currentChar = text.charAt(curr.pos);
            if (!escaped && currentChar == '\"') {
                inStringLiteral = !inStringLiteral;
            } else if (currentChar == '\\') {
                escaped = !escaped;
            } else if (!inStringLiteral) {
                if (currentChar == '(') {
                    ++parenthesisLevel;
                } else if (currentChar == ')') {
                    if (parenthesisLevel == 0) break;
                    --parenthesisLevel;
                } else if (parenthesisLevel == 0 && currentChar == ',') break;
            }
            ++curr.pos;
        }
        String token = text.substring(begin, curr.pos).trim();
        return token;
    }

    protected String getIndex(String text, Position curr) {
        int begin = curr.pos;
        int parenthesisLevel = 0;
        while (curr.pos < text.length()) {
            if (text.charAt(curr.pos) == '[') {
                ++parenthesisLevel;
            } else if (text.charAt(curr.pos) == ']') {
                if (parenthesisLevel == 0) break;
                --parenthesisLevel;
            }
            ++curr.pos;
        }
        String token = text.substring(begin, curr.pos).trim();
        return token;
    }

    protected void skipWhiteSpace(String text, Position curr) {
        while (curr.pos < text.length() && Character.isWhitespace(text.charAt(curr.pos))) {
            ++curr.pos;
        }
    }

    protected void skipMultiComment(String text, Position curr) {
        curr.pos += 2;
        while (curr.pos < text.length() - 1 && text.charAt(curr.pos++) != '*') {
            if (text.charAt(curr.pos) == '/') break;
        }
        if (curr.pos < text.length()) {
            ++curr.pos;
        }
    }

    protected void skipSingleComment(String text, Position curr) {
        while (curr.pos < text.length() && text.charAt(curr.pos) != '\n') {
            ++curr.pos;
        }
        if (curr.pos < text.length()) {
            ++curr.pos;
        }
    }

    protected void skipString(String text, Position curr) {
        while (++curr.pos < text.length() && text.charAt(curr.pos) != '\"') {
            if (text.charAt(curr.pos) != '\\') continue;
            ++curr.pos;
        }
        if (curr.pos < text.length()) {
            ++curr.pos;
        }
    }

    protected boolean argsMatching(EObject msg, ArrayList<String> args) {
        return true;
    }

    protected boolean isTokenChar(char c) {
        return Character.isDigit(c) || Character.isLetter(c) || c == '_';
    }

    public static class Position {
        public int pos = 0;
    }
}

