/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.etrice.core.common.ui.modelpath.ModelPathManager;
import org.eclipse.etrice.core.common.ui.modelpath.WorkspaceModelPath;
import org.eclipse.etrice.generator.base.AbstractGeneratorOptions;
import org.eclipse.etrice.generator.base.io.ILineOutput;
import org.eclipse.etrice.generator.base.setup.GeneratorApplicationOptions;
import org.eclipse.etrice.generator.launch.ConsoleOutput;
import org.eclipse.etrice.generator.launch.GeneratorLaunchHelper;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class GeneratorLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(String.valueOf(configuration.getName()) + "...", 3);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            ConsoleOutput output = this.getConsoleOutput();
            List<String> models = this.getModels(configuration);
            Map<IProject, List<String>> project2Models = GeneratorLaunchHelper.groupByProject(models);
            for (Map.Entry<IProject, List<String>> entry : project2Models.entrySet()) {
                StringBuffer argString = new StringBuffer();
                this.addModels(configuration, entry.getKey(), (Iterable<String>)entry.getValue(), argString);
                this.addArguments(configuration, entry.getKey(), argString);
                this.addModelpath(entry.getKey(), argString);
                String[] args = this.splitCommandLine(argString.toString());
                output.println("\n*** generating project " + entry.getKey().getName() + " ***\n");
                this.runGenerator(args, output);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
        finally {
            monitor.done();
        }
        this.launchRefreshJob(configuration);
    }

    private void launchRefreshJob(final ILaunchConfiguration configuration) {
        Job job = new Job("refresh resources after code generation"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    protected ConsoleOutput getConsoleOutput() {
        final MessageConsole myConsole = this.findConsole(this.getConsoleName());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                    IWorkbenchPage page = win.getActivePage();
                    String id = "org.eclipse.ui.console.ConsoleView";
                    IConsoleView view = (IConsoleView)page.showView(id);
                    view.display((IConsole)myConsole);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        MessageConsoleStream out = myConsole.newMessageStream();
        out.getConsole().clearConsole();
        return new ConsoleOutput(out);
    }

    protected void addModels(ILaunchConfiguration configuration, IProject project, Iterable<String> models, StringBuffer argString) throws CoreException {
        if (configuration.getAttribute("GenerateDepsWithinProject", true)) {
            models = GeneratorLaunchHelper.getAllDependenciesWithinProject(project, models);
        }
        for (String model : models) {
            argString.append(" \"" + model + "\"");
        }
    }

    protected List<String> getModels(ILaunchConfiguration configuration) throws CoreException {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        List models = configuration.getAttribute("ModelFiles", Collections.EMPTY_LIST);
        ArrayList substitutedModels = Lists.newArrayList();
        for (String model : models) {
            substitutedModels.add(variableManager.performStringSubstitution(model));
        }
        return substitutedModels;
    }

    protected void addArguments(ILaunchConfiguration configuration, IProject project, StringBuffer argString) throws CoreException {
        String projectDir = String.valueOf(project.getLocation().toString()) + "/";
        if (configuration.getAttribute("Lib", false)) {
            argString.append(" -" + AbstractGeneratorOptions.LIB.getName());
        }
        if (configuration.getAttribute("SaveGenModel", false)) {
            String genModelPath = configuration.getAttribute("GenModelPath", "?");
            argString.append(" -" + AbstractGeneratorOptions.SAVE_GEN_MODEL.getName());
            argString.append(" " + projectDir + genModelPath);
        }
        if (!configuration.getAttribute("MainMethodName", (String)AbstractGeneratorOptions.MAIN_NAME.getDefaultValue()).equals(AbstractGeneratorOptions.MAIN_NAME.getDefaultValue())) {
            argString.append(" -" + AbstractGeneratorOptions.MAIN_NAME.getName());
            argString.append(" " + configuration.getAttribute("MainMethodName", (String)AbstractGeneratorOptions.MAIN_NAME.getDefaultValue()));
        }
        if (configuration.getAttribute("Debug", false)) {
            argString.append(" -" + GeneratorApplicationOptions.LOGLEVEL.getName());
            argString.append(" debug");
        }
        if (configuration.getAttribute("MSC", false)) {
            argString.append(" -" + AbstractGeneratorOptions.MSC_INSTR.getName());
        }
        if (configuration.getAttribute("Verbose", false)) {
            argString.append(" -" + AbstractGeneratorOptions.VERBOSE_RT.getName());
        }
        if (!configuration.getAttribute("UseTranslation", true)) {
            argString.append(" -" + AbstractGeneratorOptions.NOTRANSLATE.getName());
        }
        if (!configuration.getAttribute("OldStyleTransitionData", true)) {
            argString.append(" -" + AbstractGeneratorOptions.OLD_STYLE_TRANSITION_DATA.getName());
        }
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.etrice.generator.ui");
        boolean override = configuration.getAttribute("OverrideDirectories", false);
        String srcgenDir = prefStore.getString(this.getSrcgenDirPreferenceConstantName());
        if (override) {
            srcgenDir = configuration.getAttribute("SrcgenPath", srcgenDir);
        }
        argString.append(" -" + GeneratorApplicationOptions.GEN_DIR.getName());
        argString.append(" \"" + projectDir + srcgenDir + "\"");
        argString.append(" -clean");
    }

    protected String getSrcgenDirPreferenceConstantName() {
        return "GenerationDirectory";
    }

    protected void addModelpath(IProject project, StringBuffer argString) throws CoreException {
        WorkspaceModelPath modelpath = ModelPathManager.INSTANCE.getModelPath(project);
        CharSequence[] paths = (String[])modelpath.getPaths().stream().map(container -> container.getLocation()).filter(Objects::nonNull).map(path -> path.toOSString()).toArray(String[]::new);
        if (paths.length > 0) {
            String modelpathArg = String.join((CharSequence)File.pathSeparator, paths);
            argString.append(" -modelpath \"").append(modelpathArg).append('\"');
        }
    }

    protected String[] splitCommandLine(String cl) {
        cl = cl.trim();
        ArrayList<String> res = new ArrayList<String>();
        int begin = 0;
        int end = cl.indexOf(32);
        boolean inQuotes = false;
        while (end > 0) {
            if (cl.charAt(begin) == '\"') {
                inQuotes = true;
            }
            if (inQuotes && cl.charAt(end - 1) == '\"') {
                inQuotes = false;
            }
            if (!inQuotes) {
                res.add(cl.substring(begin, end).replace("\"", ""));
                begin = end + 1;
            }
            end = cl.indexOf(32, end + 1);
        }
        res.add(cl.substring(begin).replace("\"", ""));
        String[] args = new String[res.size()];
        return res.toArray(args);
    }

    protected abstract void runGenerator(String[] var1, ILineOutput var2);

    protected abstract String getConsoleName();

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }
}

