/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.genmodel.builder.GeneratorModelBuilder;
import org.eclipse.etrice.core.genmodel.builder.GeneratorModelBuilderFactory;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.base.AbstractGeneratorOptions;
import org.eclipse.etrice.generator.base.DetailCodeTranslator;
import org.eclipse.etrice.generator.base.GeneratorApplication;
import org.eclipse.etrice.generator.base.GeneratorException;
import org.eclipse.etrice.generator.base.IGenerator;
import org.eclipse.etrice.generator.base.ITranslationProvider;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.args.Option;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.io.ILineOutput;
import org.eclipse.etrice.generator.base.io.LineOutput;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.fsm.base.Diagnostician;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.etrice.generator.generic.TestInstanceCreator;

public abstract class AbstractGenerator
implements IGenerator,
IDetailCodeTranslator {
    public static final int GENERATOR_OK = 0;
    public static final int GENERATOR_ERROR = 1;
    protected static ILineOutput output = new LineOutput();
    private static Arguments settings = null;
    @Inject
    protected Diagnostician diagnostician;
    @Inject
    protected ITranslationProvider translationProvider;
    @Inject
    private GeneratorModelBuilderFactory genModelBuilderFactory;
    private HashMap<DetailCode, String> detailcode2string = new HashMap();
    private ResourceSet resourceSet = null;

    public static Arguments getSettings() {
        return settings;
    }

    public static void setOutput(ILineOutput out) {
        if (out != null) {
            output = out;
        }
    }

    public static int createAndRunGenerator(Module generatorModule, String[] args) {
        int ret = 0;
        GeneratorApplication genAppl = GeneratorApplication.create((Module)generatorModule);
        try {
            genAppl.run(args, output);
        }
        catch (GeneratorException generatorException) {
            ret = 1;
        }
        return ret;
    }

    public void generate(List<Resource> resources, Arguments arguments, IGeneratorFileIO fileIO, ILogger logger) {
        settings = arguments;
        this.diagnostician.setFailed(false);
        if (resources.isEmpty()) {
            logger.logError("no input files");
            logger.logInfo("-- terminating");
            throw new GeneratorException("can't determine resource set without input files");
        }
        this.resourceSet = resources.get(0).getResourceSet();
        int ret = this.runGenerator(resources, arguments, fileIO, logger);
        if (ret != 0) {
            logger.logInfo("-- terminating");
            throw new GeneratorException("generator error");
        }
        logger.logInfo("-- finished");
        this.detailcode2string.clear();
    }

    protected abstract int runGenerator(List<Resource> var1, Arguments var2, IGeneratorFileIO var3, ILogger var4);

    protected ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Deprecated
    protected Root createGeneratorModel(List<Resource> resources, Arguments arguments, ILogger logger) {
        return this.createGeneratorModel(resources, arguments, null, logger);
    }

    protected Root createGeneratorModel(List<Resource> resources, Arguments arguments, IGeneratorFileIO fileIO, ILogger logger) {
        boolean doTranslate = (Boolean)arguments.get((Option)AbstractGeneratorOptions.NOTRANSLATE) == false;
        boolean asLibrary = (Boolean)arguments.get((Option)AbstractGeneratorOptions.LIB);
        String genModelPath = (String)arguments.get((Option)AbstractGeneratorOptions.SAVE_GEN_MODEL);
        Set<URI> mainModelURIs = resources.stream().map(m -> m.getURI()).collect(Collectors.toSet());
        List<Resource> testInstanceResources = new TestInstanceCreator(logger, (IDiagnostician)this.diagnostician).createInstancesAndMapping(mainModelURIs, this.getResourceSet());
        if (testInstanceResources == null) {
            return null;
        }
        ArrayList<RoomModel> mainModels = new ArrayList<RoomModel>();
        ArrayList<RoomModel> importedModels = new ArrayList<RoomModel>();
        for (Resource resource : this.getResourceSet().getResources()) {
            boolean isMainModel = mainModelURIs.contains(resource.getURI());
            for (Iterator content : resource.getContents()) {
                if (!(content instanceof RoomModel)) continue;
                if (isMainModel) {
                    mainModels.add((RoomModel)content);
                    continue;
                }
                importedModels.add((RoomModel)content);
            }
        }
        if (!testInstanceResources.isEmpty()) {
            for (Resource resource : testInstanceResources) {
                for (EObject content : resource.getContents()) {
                    if (!(content instanceof RoomModel)) continue;
                    mainModels.add((RoomModel)content);
                }
            }
        }
        if (importedModels.isEmpty() && mainModels.isEmpty()) {
            logger.logError("no ROOM models found");
            return null;
        }
        logger.logInfo("-- creating generator model");
        GeneratorModelBuilder gmb = this.genModelBuilderFactory.create(logger, (IDiagnostician)this.diagnostician);
        Root gmRoot = gmb.createGeneratorModel(mainModels, importedModels, asLibrary);
        if (this.diagnostician.isFailed()) {
            logger.logError("validation failed during build of generator model");
            return null;
        }
        this.translateDetailCodes(gmRoot, doTranslate);
        URI genModelURI = !genModelPath.isEmpty() ? URI.createFileURI((String)genModelPath) : URI.createFileURI((String)"tmp.rim");
        Resource genResource = this.getResourceSet().createResource(genModelURI);
        genResource.getContents().add((Object)gmRoot);
        if (!genModelPath.isEmpty()) {
            try {
                logger.logInfo("saving genmodel to " + genModelPath);
                if (fileIO != null) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    genResource.save((OutputStream)outputStream, Collections.EMPTY_MAP);
                    fileIO.generateFile(genModelURI.toFileString(), (CharSequence)outputStream.toString());
                } else {
                    genResource.save(Collections.EMPTY_MAP);
                }
            }
            catch (IOException e) {
                logger.logError(e.getMessage());
                return null;
            }
        }
        return gmRoot;
    }

    protected void translateDetailCodes(Root gmRoot, boolean doTranslate) {
        DetailCodeTranslator dct;
        for (ExpandedActorClass xpac : gmRoot.getXpActorClasses()) {
            dct = new DetailCodeTranslator(xpac.getActorClass(), this.translationProvider, doTranslate);
            this.translateDetailCodesOfTree((EObject)xpac.getActorClass(), dct);
            List allDetailCodes = FsmGenExtensions.getAllDetailCodes((Graph)xpac.getGraphContainer().getGraph());
            for (DetailCode dc : allDetailCodes) {
                this.detailcode2string.put(dc, dct.translateDetailCode(dc));
            }
        }
        for (DataClass dc : gmRoot.getDataClasses()) {
            dct = new DetailCodeTranslator(dc, this.translationProvider, doTranslate);
            this.translateDetailCodesOfTree((EObject)dc, dct);
        }
        for (ProtocolClass pc : gmRoot.getProtocolClasses()) {
            if (pc.getConjugated() != null) {
                dct = new DetailCodeTranslator(pc.getConjugated(), this.translationProvider, doTranslate);
                this.translateDetailCodesOfTree((EObject)pc.getConjugated(), dct);
            }
            if (pc.getRegular() != null) {
                dct = new DetailCodeTranslator(pc.getRegular(), this.translationProvider, doTranslate);
                this.translateDetailCodesOfTree((EObject)pc.getRegular(), dct);
            }
            dct = new DetailCodeTranslator(pc, this.translationProvider, doTranslate);
            this.translateDetailCodesOfTree((EObject)pc.getUserCode1(), dct);
            this.translateDetailCodesOfTree((EObject)pc.getUserCode2(), dct);
            this.translateDetailCodesOfTree((EObject)pc.getUserCode3(), dct);
        }
    }

    protected void translateDetailCodesOfTree(EObject container, DetailCodeTranslator dct) {
        if (container == null) {
            return;
        }
        if (container instanceof DetailCode) {
            DetailCode dc = (DetailCode)container;
            this.detailcode2string.put(dc, dct.translateDetailCode(dc));
            return;
        }
        TreeIterator it = container.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof DetailCode)) continue;
            DetailCode dc = (DetailCode)obj;
            this.detailcode2string.put(dc, dct.translateDetailCode(dc));
        }
    }

    public String getTranslatedCode(DetailCode dc) {
        String code = this.detailcode2string.get(dc);
        if (code == null) {
            return "";
        }
        return code;
    }
}

