/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.TriggerExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.generator.fsm.generic.AbstractStateMachineGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GenericStateMachineGenerator
extends AbstractStateMachineGenerator {
    @Inject
    @Extension
    protected TriggerExtensions _triggerExtensions;
    @Inject
    @Extension
    protected FSMHelpers _fSMHelpers;

    public CharSequence genStateMachine(GraphContainer gc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this.genStateMachineConstants(gc);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        CharSequence charSequence2 = this.genStateMachineMethods(gc, true);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    public CharSequence genStateMachineConstants(GraphContainer gc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/* state IDs */");
        stringConcatenation.newLine();
        String string = this.genStateIdConstants(gc);
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("/* transition chains */");
        stringConcatenation.newLine();
        String string2 = this.genTransitionChainConstants(gc);
        stringConcatenation.append(string2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("/* triggers */");
        stringConcatenation.newLine();
        String string3 = this.genTriggerConstants(gc);
        stringConcatenation.append(string3);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    public CharSequence genStateMachineMethods(GraphContainer gc, boolean generateImplementation) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this.genExtra(gc, generateImplementation);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("/* Entry and Exit Codes */");
        stringConcatenation.newLine();
        String string = this.genEntryAndExitCodes(gc, generateImplementation);
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("/* Action Codes */");
        stringConcatenation.newLine();
        String string2 = this.genActionCodes(gc, generateImplementation);
        stringConcatenation.append(string2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("/* State Switch Methods */");
        stringConcatenation.newLine();
        String string3 = this.genStateSwitchMethods(gc, generateImplementation);
        stringConcatenation.append(string3);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    public String genTriggeredTransitionGuard(Link tt, final String trigger, GraphContainer gc) {
        String string = null;
        TransitionBase transitionBase = tt.getTransition();
        Functions.Function1<Trigger, Boolean> function1 = new Functions.Function1<Trigger, Boolean>(){

            public Boolean apply(Trigger trig) {
                return GenericStateMachineGenerator.this._triggerExtensions.isMatching(trig, trigger);
            }
        };
        Trigger tr = (Trigger)IterableExtensions.findFirst((Iterable)((TriggeredTransition)transitionBase).getTriggers(), (Functions.Function1)function1);
        StringConcatenation stringConcatenation = new StringConcatenation();
        boolean bl = this._fSMHelpers.hasGuard(tr);
        if (bl) {
            stringConcatenation.append("if (");
            String string2 = this.translator.getTranslatedCode(tr.getGuard().getGuard());
            stringConcatenation.append(string2);
            stringConcatenation.append(")");
            stringConcatenation.newLineIfNotEmpty();
        }
        string = stringConcatenation.toString();
        return string;
    }

    public String genGuardedTransitionGuard(Link link, String trigger, GraphContainer gc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        TransitionBase transitionBase = link.getTransition();
        String string = this.translator.getTranslatedCode(((GuardedTransition)transitionBase).getGuard());
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation.toString();
    }

    public String genActionCodeMethod(GraphContainer gc, Link link, boolean generateImplementation) {
        String string = null;
        boolean hasArgs = !link.getChainHeads().isEmpty() && IterableExtensions.forall((Iterable)link.getChainHeads(), (Functions.Function1)new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                return it.getTransition() instanceof NonInitialTransition && !(it.getTransition() instanceof GuardedTransition);
            }
        });
        String opScope = this.langExt.operationScope(this.getClassName(gc), false);
        String string2 = null;
        boolean bl = this.langExt.usesInheritance();
        string2 = bl ? opScope : "";
        String opScopePriv = string2;
        String string3 = this.langExt.pointerLiteral();
        String ifItemPtr = "InterfaceItemBase" + string3;
        String string4 = null;
        boolean bl2 = this.langExt.usesPointers();
        string4 = bl2 ? "const " + ifItemPtr : ifItemPtr;
        String constIfItemPtr = string4;
        String string5 = null;
        if (generateImplementation) {
            String string6;
            StringConcatenation stringConcatenation = new StringConcatenation();
            String string7 = this.langExt.accessLevelProtected();
            stringConcatenation.append(string7);
            stringConcatenation.append("void ");
            stringConcatenation.append(opScopePriv);
            String string8 = this._codegenHelpers.getActionCodeOperationName(link.getTransition());
            stringConcatenation.append(string8);
            stringConcatenation.append("(");
            String string9 = this.langExt.selfPointer(this.getClassName(gc), hasArgs);
            stringConcatenation.append(string9);
            if (hasArgs) {
                stringConcatenation.append(constIfItemPtr);
                stringConcatenation.append(" ifitem");
                string6 = this.transitionChainGenerator.generateArgumentList(gc, link);
                stringConcatenation.append(string6);
            }
            stringConcatenation.append(") {");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("    ");
            string6 = this.translator.getTranslatedCode(link.getTransition().getAction());
            stringConcatenation.append(string6, "    ");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
            string5 = stringConcatenation.toString();
        } else {
            StringConcatenation stringConcatenation = new StringConcatenation();
            String string10 = this.langExt.accessLevelProtected();
            stringConcatenation.append(string10);
            String string11 = this.langExt.makeOverridable();
            stringConcatenation.append(string11);
            stringConcatenation.append("void ");
            String string12 = this._codegenHelpers.getActionCodeOperationName(link.getTransition());
            stringConcatenation.append(string12);
            stringConcatenation.append("(");
            String string13 = this.langExt.selfPointer(this.getClassName(gc), hasArgs);
            stringConcatenation.append(string13);
            if (hasArgs) {
                stringConcatenation.append(constIfItemPtr);
                stringConcatenation.append(" ifitem");
                String string14 = this.transitionChainGenerator.generateArgumentList(gc, link);
                stringConcatenation.append(string14);
            }
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
            string5 = stringConcatenation.toString();
        }
        string = string5;
        return string;
    }

    public String genActionCodeMethods(GraphContainer gc, Node node, boolean generateImplementation) {
        String string;
        boolean bl;
        String string2 = null;
        ModelComponent mc = this._fSMHelpers.getModelComponent((EObject)gc);
        String selfPtr = this.langExt.selfPointer(this.getClassName(gc), false);
        String opScope = this.langExt.operationScope(this.getClassName(gc), false);
        String string3 = null;
        boolean bl2 = this.langExt.usesInheritance();
        string3 = bl2 ? opScope : "";
        String opScopePriv = string3;
        StateGraphNode stateGraphNode = node.getStateGraphNode();
        State state = (State)stateGraphNode;
        String entryOp = this._codegenHelpers.getEntryCodeOperationName(state);
        String exitOp = this._codegenHelpers.getExitCodeOperationName(state);
        String doOp = this._codegenHelpers.getDoCodeOperationName(state);
        String entry = this.translator.getTranslatedCode(state.getEntryCode());
        String exit = this.translator.getTranslatedCode(state.getExitCode());
        String docode = this.translator.getTranslatedCode(state.getDoCode());
        if (state instanceof RefinedState) {
            String inhEntry = this.translator.getTranslatedCode(this._fSMHelpers.getInheritedEntryCode((RefinedState)state));
            String inhExit = this.translator.getTranslatedCode(this._fSMHelpers.getInheritedExitCode((RefinedState)state));
            String inhDo = this.translator.getTranslatedCode(this._fSMHelpers.getInheritedDoCode((RefinedState)state));
            boolean bl3 = this.langExt.usesInheritance();
            if (bl3) {
                boolean bl4;
                String string4;
                boolean bl5;
                String string5;
                String baseName = this.getClassName(mc.getBase());
                boolean bl6 = this._fSMHelpers.hasDetailCode(this._fSMHelpers.getInheritedEntryCode((RefinedState)state));
                if (bl6) {
                    String string6 = this.langExt.superCall(baseName, entryOp, "");
                    entry = string5 = String.valueOf(string6) + entry;
                }
                if (bl5 = this._fSMHelpers.hasDetailCode(this._fSMHelpers.getInheritedExitCode((RefinedState)state))) {
                    string5 = this.langExt.superCall(baseName, exitOp, "");
                    exit = string4 = String.valueOf(exit) + string5;
                }
                if (bl4 = this._fSMHelpers.hasDetailCode(this._fSMHelpers.getInheritedDoCode((RefinedState)state))) {
                    String string7;
                    string4 = this.langExt.superCall(baseName, doOp, "");
                    docode = string7 = String.valueOf(string4) + docode;
                }
            } else {
                entry = String.valueOf(inhEntry) + entry;
                exit = String.valueOf(exit) + inhExit;
                docode = String.valueOf(inhDo) + docode;
            }
        }
        StringConcatenation stringConcatenation = new StringConcatenation();
        boolean bl7 = entry.isEmpty();
        boolean bl8 = bl = !bl7;
        if (bl) {
            if (generateImplementation) {
                String string8 = this.langExt.accessLevelProtected();
                stringConcatenation.append(string8);
                stringConcatenation.append("void ");
                stringConcatenation.append(opScopePriv);
                stringConcatenation.append(entryOp);
                stringConcatenation.append("(");
                stringConcatenation.append(selfPtr);
                stringConcatenation.append(") {");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                stringConcatenation.append(entry, "\t");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("}");
                stringConcatenation.newLine();
            } else {
                String string9 = this.langExt.accessLevelProtected();
                stringConcatenation.append(string9);
                string = this.langExt.makeOverridable();
                stringConcatenation.append(string);
                stringConcatenation.append("void ");
                stringConcatenation.append(entryOp);
                stringConcatenation.append("(");
                stringConcatenation.append(selfPtr);
                stringConcatenation.append(");");
                stringConcatenation.newLineIfNotEmpty();
            }
        }
        boolean bl9 = bl = !(bl7 = exit.isEmpty());
        if (bl) {
            if (generateImplementation) {
                String string10 = this.langExt.accessLevelProtected();
                stringConcatenation.append(string10);
                stringConcatenation.append("void ");
                stringConcatenation.append(opScopePriv);
                stringConcatenation.append(exitOp);
                stringConcatenation.append("(");
                stringConcatenation.append(selfPtr);
                stringConcatenation.append(") {");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                stringConcatenation.append(exit, "\t");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("}");
                stringConcatenation.newLine();
            } else {
                String string11 = this.langExt.accessLevelProtected();
                stringConcatenation.append(string11);
                string = this.langExt.makeOverridable();
                stringConcatenation.append(string);
                stringConcatenation.append("void ");
                stringConcatenation.append(exitOp);
                stringConcatenation.append("(");
                stringConcatenation.append(selfPtr);
                stringConcatenation.append(");");
                stringConcatenation.newLineIfNotEmpty();
            }
        }
        boolean bl10 = bl = !(bl7 = docode.isEmpty());
        if (bl) {
            if (generateImplementation) {
                String string12 = this.langExt.accessLevelProtected();
                stringConcatenation.append(string12);
                stringConcatenation.append(" void ");
                stringConcatenation.append(opScopePriv);
                stringConcatenation.append(doOp);
                stringConcatenation.append("(");
                stringConcatenation.append(selfPtr);
                stringConcatenation.append(") {");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                stringConcatenation.append(docode, "\t");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("}");
                stringConcatenation.newLine();
            } else {
                String string13 = this.langExt.accessLevelProtected();
                stringConcatenation.append(string13);
                string = this.langExt.makeOverridable();
                stringConcatenation.append(string);
                stringConcatenation.append("void ");
                stringConcatenation.append(doOp);
                stringConcatenation.append("(");
                stringConcatenation.append(selfPtr);
                stringConcatenation.append(");");
                stringConcatenation.newLineIfNotEmpty();
            }
        }
        string2 = stringConcatenation.toString();
        return string2;
    }

    public CharSequence genExtra(GraphContainer gc, boolean generateImplementation) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        return stringConcatenation;
    }
}

