/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.base.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.etrice.core.common.base.BaseFactory;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.scoping.ModelLocatorUriResolver;
import org.eclipse.etrice.core.common.scoping.RelativeFileURIHandler;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;

public class ImportHelpers {
    private static final EClass EOBJECT = EcorePackage.eINSTANCE.getEObject();
    @Inject
    IQualifiedNameConverter nameConverter;
    @Inject
    ModelLocatorUriResolver importUriResolver;
    @Inject
    IGlobalScopeProvider globalScope;
    @Inject(optional=true)
    IResourceDescriptions resourceDescriptions;

    public ModelLocatorUriResolver getUriResolver() {
        return this.importUriResolver;
    }

    public Iterable<IEObjectDescription> findInWorskpace(QualifiedName fqn, boolean ignoreCase) {
        return this.getWorkspaceDescriptions().getExportedObjects(EOBJECT, fqn, ignoreCase);
    }

    public IResourceDescriptions getWorkspaceDescriptions() {
        if (this.resourceDescriptions != null) {
            return this.resourceDescriptions;
        }
        throw new IllegalStateException("workspace resource descriptions not set or available");
    }

    public IScope getVisibleScope(Resource context) {
        return this.getVisibleScope(context, EOBJECT);
    }

    public IScope getVisibleScope(Resource context, EClass type) {
        return this.getVisibleScope(context, type, (Predicate<IEObjectDescription>)Predicates.alwaysTrue());
    }

    public IScope getVisibleScope(Resource context, EClass type, Predicate<IEObjectDescription> filter) {
        EReference reference = EcoreFactory.eINSTANCE.createEReference();
        reference.setEType((EClassifier)(type != null ? type : EOBJECT));
        return this.globalScope.getScope(context, reference, filter);
    }

    public IGlobalScopeProvider getVisibleScopeProvider() {
        return this.globalScope;
    }

    public Optional<List<IEObjectDescription>> getImportedObjectsFor(Import imp, Predicate<IEObjectDescription> quickFixCandidateMatcher) {
        QualifiedName importedFQN = this.toFQN(imp);
        if (importedFQN == null) {
            return Optional.empty();
        }
        String uriString = this.importUriResolver.resolve(imp);
        if (uriString == null) {
            return Optional.empty();
        }
        URI uri = URI.createURI((String)uriString);
        Resource importedResource = null;
        try {
            if (imp.eResource().getResourceSet() instanceof ResourceSetImpl) {
                ResourceSetImpl rs = (ResourceSetImpl)imp.eResource().getResourceSet();
                importedResource = (Resource)rs.getURIResourceMap().get(uri);
            }
            if (importedResource == null) {
                importedResource = new ResourceSetImpl().getResource(uri, true);
            }
        }
        catch (RuntimeException runtimeException) {
            return Optional.empty();
        }
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        if (importedResource == null || resourceServiceProvider == null) {
            return Optional.empty();
        }
        IResourceDescription.Manager manager = resourceServiceProvider.getResourceDescriptionManager();
        IResourceDescription description = manager.getResourceDescription(importedResource);
        ArrayList candidates = Lists.newArrayList();
        if (description != null) {
            for (IEObjectDescription eObjDesc : description.getExportedObjects()) {
                if (importedFQN.equals((Object)eObjDesc.getQualifiedName())) {
                    candidates.add(eObjDesc);
                    continue;
                }
                if (!quickFixCandidateMatcher.apply((Object)eObjDesc)) continue;
                candidates.add(eObjDesc);
            }
        }
        return Optional.of(candidates);
    }

    public QualifiedName toFQN(String fqn) {
        boolean isWildcard = false;
        try {
            QualifiedName orig = this.nameConverter.toQualifiedName(fqn);
            isWildcard = orig.getLastSegment().equals("*");
            return isWildcard ? orig.skipLast(1) : orig;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public QualifiedName toFQN(Import imp) {
        return this.toFQN(imp.getImportedNamespace());
    }

    public List<Import> createModelPathImports(String issueString, Resource resource, EClass type, boolean wildcard) {
        ArrayList<Import> result = new ArrayList<Import>();
        IScope scope = this.getVisibleScope(resource, type);
        scope.getAllElements().forEach(eObjDesc -> {
            if (eObjDesc.getName().getLastSegment().equalsIgnoreCase(issueString)) {
                Import imp = BaseFactory.eINSTANCE.createImport();
                imp.setImportedNamespace(wildcard ? eObjDesc.getQualifiedName().skipLast(1) + ".*" : eObjDesc.getQualifiedName().toString());
                result.add(imp);
            }
        });
        return result;
    }

    public List<Import> createURIImports(String issueString, EClass type, URI baseURI) {
        ArrayList<Import> result = new ArrayList<Import>();
        this.getWorkspaceDescriptions().getExportedObjectsByType(type).forEach(eObjDesc -> {
            if (eObjDesc.getName().getLastSegment().equalsIgnoreCase(issueString)) {
                Import imp = BaseFactory.eINSTANCE.createImport();
                imp.setImportedNamespace(eObjDesc.getQualifiedName().skipLast(1) + ".*");
                imp.setImportURI(this.computeImportURIString(baseURI, eObjDesc.getEObjectURI()));
                result.add(imp);
            }
        });
        return result;
    }

    private String computeImportURIString(URI base, URI toImport) {
        URI trimmedBase = base.trimQuery().trimFragment();
        URI trimmedImport = toImport.trimQuery().trimFragment();
        RelativeFileURIHandler fileHandler = new RelativeFileURIHandler();
        fileHandler.setBaseURI(trimmedBase);
        URI resolvedRelative = fileHandler.deresolve(trimmedImport);
        if (base.isPlatformResource() && toImport.isPlatformResource() && Objects.equals(base.segment(1), toImport.segment(1))) {
            String baseLocation = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(base.trimSegments(1).toPlatformString(false))).getLocation().toFile().getAbsolutePath();
            if (resolvedRelative.isRelative() && Files.exists(Paths.get(baseLocation, resolvedRelative.toString()), new LinkOption[0])) {
                return resolvedRelative.toString();
            }
            return trimmedImport.toString();
        }
        if (base.isPlatformResource() && toImport.isPlatformResource()) {
            return trimmedImport.toString();
        }
        return resolvedRelative.toString();
    }
}

