/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.validation;

import com.google.inject.Inject;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.AnnotationAttribute;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.common.base.BooleanLiteral;
import org.eclipse.etrice.core.common.base.Documentation;
import org.eclipse.etrice.core.common.base.EnumAnnotationAttribute;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.base.IntLiteral;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.common.base.RealLiteral;
import org.eclipse.etrice.core.common.base.SimpleAnnotationAttribute;
import org.eclipse.etrice.core.common.base.StringLiteral;
import org.eclipse.etrice.core.common.base.util.ImportHelpers;
import org.eclipse.etrice.core.common.validation.AbstractBaseValidator;
import org.eclipse.etrice.generator.base.io.IModelPathProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.validation.Check;

public class BaseValidator
extends AbstractBaseValidator {
    public static final String MANDATORY_ATTRIBUTE_MISSING = "BaseJavaValidator.MandatoryAttributeMissing";
    public static final String DUPLICATE_ANNOTATION_TARGETS = "BaseJavaValidator.DuplicateAnnotationTargets";
    public static final String UNDEFINED_ANNOTATION_ATTRIBUTE = "BaseJavaValidator.UndfinedAnnotationAttribute";
    public static final String UNDEFINED_ANNOTATION_ATTRIBUTE_VALUE = "BaseJavaValidator.UndfinedAnnotationAttributeValue";
    public static final String DUPLICATE_ANNOTATION_ATTRIBUTE = "BaseJavaValidator.DuplicateAnnotationAttribute";
    public static final String DEPRECATED_IMPORT_URI = "BaseJavaValidator.DeprecatedImportUri";
    public static final String MODELPATH_DESCRIPTION_MISSING = "BaseJavaValidator.ModelpathDescriptionMissing";
    public static final String IMPORTED_NAMESPACE_MISSING = "BaseJavaValidator.ImportedNamespaceMissing";
    public static final String DEPRECATED_DOCUMENTATION = "BaseJavaValidator.DeprecatedDocumentation";
    @Inject
    ImportUriResolver importUriResolver;
    @Inject
    ImportHelpers importHelpers;
    @Inject
    IModelPathProvider modelPathProvider;

    @Check
    public void checkDocumentation(Documentation doc) {
        this.warning("Explicit documentation strings are deprecated. Use javadoc/doxy style documentation strings instead.", doc, null, DEPRECATED_DOCUMENTATION, new String[0]);
        if (doc.getLines().isEmpty()) {
            this.error("documentation must not be empty", doc, (EStructuralFeature)BasePackage.Literals.DOCUMENTATION__LINES);
        }
    }

    @Check
    public void checkAnnotationTypeTargetsUnique(AnnotationType at) {
        HashSet<String> targets = new HashSet<String>();
        for (String tgt : at.getTargets()) {
            if (targets.add(tgt)) continue;
            this.error("The target " + tgt + " is defined more than once", at, (EStructuralFeature)BasePackage.Literals.ANNOTATION_TYPE__TARGETS, DUPLICATE_ANNOTATION_TARGETS, new String[]{tgt});
        }
    }

    @Check
    public void checkAnnotationAttributeMandatory(Annotation a) {
        if (a.getType().eIsProxy()) {
            return;
        }
        for (AnnotationAttribute att : a.getType().getAttributes()) {
            if (att.isOptional()) continue;
            boolean isDefined = false;
            for (KeyValue kv : a.getAttributes()) {
                if (!kv.getKey().equals(att.getName())) continue;
                isDefined = true;
                break;
            }
            if (isDefined) continue;
            this.error("Mandatory attribute " + att.getName() + " is missing", a, (EStructuralFeature)BasePackage.Literals.ANNOTATION__ATTRIBUTES, MANDATORY_ATTRIBUTE_MISSING, new String[]{att.getName()});
        }
    }

    @Check
    public void checkAnnotationAttributeType(Annotation a) {
        if (a.getType().eIsProxy()) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (KeyValue kv : a.getAttributes()) {
            int idx = a.getAttributes().indexOf((Object)kv);
            if (!names.add(kv.getKey())) {
                this.error("duplicate attribute " + kv.getKey(), a, (EStructuralFeature)BasePackage.Literals.ANNOTATION__ATTRIBUTES, idx, DUPLICATE_ANNOTATION_ATTRIBUTE, new String[]{kv.getKey()});
            }
            boolean isAllowed = false;
            block7: for (AnnotationAttribute att : a.getType().getAttributes()) {
                if (!att.getName().equals(kv.getKey())) continue;
                isAllowed = true;
                if (kv.getValue() == null) break;
                if (att instanceof EnumAnnotationAttribute) {
                    EList<String> values = ((EnumAnnotationAttribute)att).getValues();
                    if (kv.getValue() instanceof StringLiteral) {
                        boolean valueAllowed = false;
                        String value = ((StringLiteral)kv.getValue()).getValue();
                        for (String val : values) {
                            if (!val.equals(value)) continue;
                            valueAllowed = true;
                            break;
                        }
                        if (valueAllowed) break;
                        this.error("Choose one of the allowed enum values", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE, UNDEFINED_ANNOTATION_ATTRIBUTE_VALUE, (String[])values.toArray((Object[])new String[values.size()]));
                        break;
                    }
                    this.error("Choose one of the allowed enum values (values has to be a string)", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE, UNDEFINED_ANNOTATION_ATTRIBUTE_VALUE, (String[])values.toArray((Object[])new String[values.size()]));
                    break;
                }
                if (!(att instanceof SimpleAnnotationAttribute)) break;
                switch (((SimpleAnnotationAttribute)att).getType()) {
                    case BOOL: {
                        if (kv.getValue() instanceof BooleanLiteral) break block7;
                        this.error("boolean literal expected", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE);
                        break;
                    }
                    case CHAR: {
                        if (kv.getValue() instanceof StringLiteral) break block7;
                        this.error("char/string literal expected", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE);
                        break;
                    }
                    case INT: {
                        if (kv.getValue() instanceof IntLiteral) break block7;
                        this.error("integer literal expected", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE);
                        break;
                    }
                    case REAL: {
                        if (kv.getValue() instanceof RealLiteral) break block7;
                        this.error("real literal expected", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE);
                        break;
                    }
                }
                break;
            }
            if (isAllowed) continue;
            this.error("Attribute " + kv.getKey() + " is undefined", a, (EStructuralFeature)BasePackage.Literals.ANNOTATION__ATTRIBUTES, idx, UNDEFINED_ANNOTATION_ATTRIBUTE, new String[]{kv.getKey()});
        }
    }

    @Check
    public void checkImportedURI(Import imp) {
        ResourceSetImpl rs;
        String uriString;
        if (imp.getImportURI() == null) {
            return;
        }
        Resource resource = imp.eResource();
        if (!this.modelPathProvider.get(resource).isEmpty()) {
            this.warning("import statements using uris are deprecated", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI, DEPRECATED_IMPORT_URI, new String[0]);
        }
        if ((uriString = this.importUriResolver.resolve((EObject)imp)) == null) {
            this.warning("could not load referenced model", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
            return;
        }
        URI uri = URI.createURI((String)uriString);
        if (resource.getResourceSet() instanceof ResourceSetImpl && (rs = (ResourceSetImpl)resource.getResourceSet()).getURIResourceMap().containsKey(uri)) {
            return;
        }
        try {
            Resource importedResource = new ResourceSetImpl().getResource(uri, true);
            if (importedResource == null) {
                return;
            }
            if (importedResource.getContents().isEmpty()) {
                this.warning("could not load referenced model", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            this.warning("could not load referenced model", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
            return;
        }
    }

    @Check
    public void checkImportedNamespace(Import imp) {
        if (imp.getImportURI() != null || imp.getImportedNamespace() == null) {
            return;
        }
        QualifiedName fqn = this.importHelpers.toFQN(imp);
        Resource resource = imp.eResource();
        if (this.modelPathProvider.get(resource).isEmpty()) {
            this.error("no modelpath definition present", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORTED_NAMESPACE, MODELPATH_DESCRIPTION_MISSING, new String[0]);
            return;
        }
        IEObjectDescription eObjDesc = this.importHelpers.getVisibleScope(resource).getSingleElement(fqn);
        if (eObjDesc == null) {
            if (this.importHelpers.findInWorskpace(fqn, false).iterator().hasNext()) {
                this.error("could not find namespace on modelpath '" + fqn + "'", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORTED_NAMESPACE, IMPORTED_NAMESPACE_MISSING, new String[0]);
            } else {
                this.error("could not find imported namespace '" + fqn + "'", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORTED_NAMESPACE, IMPORTED_NAMESPACE_MISSING, new String[0]);
            }
        }
    }
}

