/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.scoping;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.SimpleState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;

public class FSMScopeProvider
extends AbstractDeclarativeScopeProvider {
    @Inject
    @Extension
    private FSMHelpers _fSMHelpers;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;

    public IScope scope_StateTerminal_state(StateTerminal st, EReference ref) {
        ArrayList scopes = CollectionLiterals.newArrayList();
        StateGraph parent = this.getStateGraph(st);
        this.getStateScopes(parent, scopes);
        return new SimpleScope(IScope.NULLSCOPE, (Iterable)scopes);
    }

    public IScope scope_TrPointTerminal_trPoint(TrPointTerminal ep, EReference ref) {
        ArrayList scopes = CollectionLiterals.newArrayList();
        StateGraph parent = this.getStateGraph(ep);
        List<TrPoint> tps = this._fSMHelpers.getAllTrPoints(parent);
        for (TrPoint tp : tps) {
            scopes.add(EObjectDescription.create((String)tp.getName(), (EObject)tp));
        }
        return new SimpleScope(IScope.NULLSCOPE, (Iterable)scopes);
    }

    public IScope scope_SubStateTrPointTerminal_trPoint(SubStateTrPointTerminal ep, EReference ref) {
        boolean bl;
        ArrayList scopes = CollectionLiterals.newArrayList();
        StateGraph parent = this.getStateGraph(ep);
        State state = ep.getState();
        boolean bl2 = bl = state != null;
        if (bl) {
            boolean bl3;
            State epState = ep.getState();
            StateGraph stateGraph = (epState = this._fSMHelpers.getRefinedStateFor(parent, epState)).getSubgraph();
            boolean bl4 = bl3 = stateGraph != null;
            if (bl3) {
                List<TrPoint> tps = this._fSMHelpers.getAllTrPoints(epState.getSubgraph());
                for (TrPoint tp : tps) {
                    scopes.add(EObjectDescription.create((String)tp.getName(), (EObject)tp));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, (Iterable)scopes);
    }

    public IScope scope_SubStateTrPointTerminal_state(SubStateTrPointTerminal st, EReference ref) {
        ArrayList scopes = CollectionLiterals.newArrayList();
        StateGraph parent = this.getStateGraph(st);
        this.getStateScopes(parent, scopes);
        return new SimpleScope(IScope.NULLSCOPE, (Iterable)scopes);
    }

    public IScope scope_ChoicepointTerminal_cp(ChoicepointTerminal ct, EReference ref) {
        ArrayList scopes = CollectionLiterals.newArrayList();
        StateGraph parent = this.getStateGraph(ct);
        List<ChoicePoint> choicePoints = this._fSMHelpers.getAllChoicePoints(parent);
        for (ChoicePoint cp : choicePoints) {
            scopes.add(EObjectDescription.create((String)cp.getName(), (EObject)cp));
        }
        return new SimpleScope(IScope.NULLSCOPE, (Iterable)scopes);
    }

    public IScope scope_RefinedState_target(RefinedState rs, EReference ref) {
        ArrayList scopes;
        block5: {
            EObject eObject;
            StateGraph sg;
            block4: {
                scopes = CollectionLiterals.newArrayList();
                sg = this.getStateGraph(rs);
                EObject eObject2 = sg.eContainer();
                if (!(eObject2 instanceof ModelComponent)) break block4;
                EObject eObject3 = sg.eContainer();
                ModelComponent comp = (ModelComponent)eObject3;
                if (comp.getBase() == null || this._fSMHelpers.isCircularClassHierarchy(comp)) break block5;
                comp = comp.getBase();
                HashSet covered = CollectionLiterals.newHashSet();
                ArrayList states = CollectionLiterals.newArrayList();
                while (comp != null) {
                    this.recursivelyAddStates(comp.getStateMachine(), covered, states);
                    comp = comp.getBase();
                }
                for (State s : states) {
                    scopes.add(EObjectDescription.create((QualifiedName)this.getStatePath(s), (EObject)s));
                }
                break block5;
            }
            EObject eObject4 = sg.eContainer();
            if (eObject4 instanceof RefinedState && (sg = ((RefinedState)(eObject = sg.eContainer())).getTarget().getSubgraph()) != null) {
                EList<State> eList = sg.getStates();
                for (State s_1 : eList) {
                    scopes.add(EObjectDescription.create((String)s_1.getName(), (EObject)s_1));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, (Iterable)scopes);
    }

    public IScope scope_RefinedTransition_target(RefinedTransition trans, EReference ref) {
        boolean bl;
        ArrayList scopes = CollectionLiterals.newArrayList();
        EObject eObject = trans.eContainer().eContainer();
        ModelComponent comp = (ModelComponent)eObject;
        boolean bl2 = this._fSMHelpers.isCircularClassHierarchy(comp);
        boolean bl3 = bl = !bl2;
        if (bl) {
            comp = comp.getBase();
            while (comp != null) {
                boolean bl4;
                StateGraph stateGraph = comp.getStateMachine();
                boolean bl5 = bl4 = stateGraph != null;
                if (bl4) {
                    int acNameSegments = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)comp).getSegmentCount();
                    TreeIterator iter = comp.getStateMachine().eAllContents();
                    while (iter.hasNext()) {
                        EObject obj = (EObject)iter.next();
                        if (!(obj instanceof Transition)) continue;
                        scopes.add(EObjectDescription.create((QualifiedName)this._iQualifiedNameProvider.getFullyQualifiedName(obj).skipFirst(acNameSegments + 1), (EObject)obj));
                    }
                }
                comp = comp.getBase();
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, (Iterable)scopes);
    }

    private void recursivelyAddStates(StateGraph sg, HashSet<State> covered, ArrayList<State> states) {
        EList<State> eList = sg.getStates();
        for (State s : eList) {
            if (s instanceof SimpleState && !covered.contains(s)) {
                states.add(s);
                continue;
            }
            if (!(s instanceof RefinedState) || covered.contains(s)) continue;
            states.add(s);
            covered.add(((RefinedState)s).getTarget());
        }
        EList<State> eList2 = sg.getStates();
        for (State s_1 : eList2) {
            boolean bl;
            StateGraph stateGraph = s_1.getSubgraph();
            boolean bl2 = bl = stateGraph != null;
            if (!bl) continue;
            this.recursivelyAddStates(s_1.getSubgraph(), covered, states);
        }
    }

    private StateGraph getStateGraph(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof StateGraph) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof StateGraph) {
            return (StateGraph)ctx;
        }
        return null;
    }

    private QualifiedName getStatePath(State bs) {
        State target;
        EObject parent = bs.eContainer().eContainer();
        if (parent instanceof SimpleState) {
            return this.getStatePath((State)parent).append(bs.getName());
        }
        if (parent instanceof RefinedState && (target = ((RefinedState)parent).getTarget()) != null) {
            return this.getStatePath(target).append(bs.getName());
        }
        return QualifiedName.create((String)bs.getName());
    }

    private void getStateScopes(StateGraph parent, List<IEObjectDescription> scopes) {
        List<State> states = this._fSMHelpers.getAllStates(parent);
        HashMap name2state = CollectionLiterals.newHashMap();
        for (State s : states) {
            name2state.put(s.getName(), this._fSMHelpers.getBaseState(s));
        }
        Set set = name2state.entrySet();
        for (Map.Entry entry : set) {
            scopes.add(EObjectDescription.create((String)((String)entry.getKey()), (EObject)((EObject)entry.getValue())));
        }
    }
}

