/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.util;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.genmodel.fsm.ExtendedFsmGenBuilder;
import org.eclipse.etrice.core.genmodel.fsm.ExtendedFsmGenBuilderFactory;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.expressions.detailcode.DetailExpressionAssistParser;
import org.eclipse.etrice.expressions.detailcode.DetailExpressionProvider;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class UIExpressionUtil {
    public static IDetailExpressionProvider getExpressionProvider(final EObject ctx, final EReference ref, ExpressionCache cache) {
        TransitionBase transition;
        if (ctx == null) {
            return new IDetailExpressionProvider.EmptyDetailExpressionProvider();
        }
        DetailExpressionProvider detailExpressionProvider = (DetailExpressionProvider)RoomUiModule.getInjector().getInstance(DetailExpressionProvider.class);
        Procedures.Procedure1<DetailExpressionProvider> procedure1 = new Procedures.Procedure1<DetailExpressionProvider>(){

            public void apply(DetailExpressionProvider prov) {
                if (ctx instanceof DetailCode) {
                    prov.setOwner(((DetailCode)ctx).eContainer());
                    prov.setReference(((DetailCode)ctx).eContainmentFeature());
                } else {
                    prov.setOwner(ctx);
                    prov.setReference(ref);
                }
            }
        };
        DetailExpressionProvider exprProvider = (DetailExpressionProvider)ObjectExtensions.operator_doubleArrow((Object)detailExpressionProvider, (Procedures.Procedure1)procedure1);
        RoomClass roomClass = (RoomClass)EcoreUtil2.getContainerOfType((EObject)ctx, RoomClass.class);
        if (roomClass != null) {
            boolean bl;
            exprProvider.setSharedCache((ImmutableList)cache.sharedCaches.get(roomClass));
            ImmutableList immutableList = exprProvider.getSharedCache();
            boolean bl2 = bl = immutableList == null;
            if (bl) {
                cache.sharedCaches.put(roomClass, exprProvider.createAndSetSharedCache());
            }
        }
        if ((transition = (TransitionBase)EcoreUtil2.getContainerOfType((EObject)ctx, TransitionBase.class)) != null && roomClass instanceof ActorClass) {
            EObject commonData;
            Link link = FsmGenExtensions.getLinkFor((GraphContainer)cache.genModelAccess.get((ModelComponent)roomClass), (TransitionBase)transition);
            EObject eObject = null;
            if (link != null) {
                eObject = link.getCommonData();
            }
            if ((commonData = eObject) instanceof MessageData) {
                exprProvider.setTransitionEventData((MessageData)commonData);
            }
        }
        return exprProvider;
    }

    public static IDetailExpressionProvider getExpressionProvider(DetailCode dc) {
        ExpressionCache expressionCache = new ExpressionCache();
        return UIExpressionUtil.getExpressionProvider((EObject)dc, null, expressionCache);
    }

    public static IDetailExpressionProvider getExpressionProvider(EObject dcOwner, EReference dcRole) {
        ExpressionCache expressionCache = new ExpressionCache();
        return UIExpressionUtil.getExpressionProvider(dcOwner, dcRole, expressionCache);
    }

    public static IDetailExpressionProvider.ExpressionFeature findAtOffset(ILeafNode leafNode, int offset) {
        try {
            Object object;
            IDetailExpressionProvider.ExpressionFeature expressionFeature;
            IDetailExpressionProvider.ExpressionFeature expressionFeature2 = null;
            IDetailExpressionProvider exprProvider = UIExpressionUtil.getExpressionProvider(leafNode.getSemanticElement(), null);
            String text = leafNode.getText();
            int n = 0;
            int n2 = leafNode.getOffset();
            int exprEndOfsset = offset - n2;
            while (text.length() > exprEndOfsset && Character.isJavaIdentifierPart(text.charAt(exprEndOfsset))) {
                int n3 = exprEndOfsset;
                exprEndOfsset = n3 + 1;
            }
            int completeExprOffset = n = exprEndOfsset;
            String string = leafNode.getText();
            Document document = new Document(string);
            DetailExpressionAssistParser parser = new DetailExpressionAssistParser((IDocument)document, completeExprOffset, exprProvider);
            final String word = parser.computeIdentifierPrefix(completeExprOffset);
            IDetailExpressionProvider.ExpressionFeature expressionFeature3 = null;
            IDetailExpressionProvider.ExpressionFeature contextFeature = expressionFeature = parser.resolveLatestCompleted();
            boolean bl = false;
            if (Objects.equal((Object)contextFeature, null)) {
                bl = true;
                object = new Functions.Function1<IDetailExpressionProvider.ExpressionFeature, Boolean>(){

                    public Boolean apply(IDetailExpressionProvider.ExpressionFeature it) {
                        String string = it.getId();
                        return Objects.equal((Object)string, (Object)word);
                    }
                };
                expressionFeature3 = (IDetailExpressionProvider.ExpressionFeature)IterableExtensions.findFirst((Iterable)exprProvider.getInitialFeatures(), (Functions.Function1)object);
            }
            if (!bl) {
                object = new Functions.Function1<IDetailExpressionProvider.ExpressionFeature, Boolean>(){

                    public Boolean apply(IDetailExpressionProvider.ExpressionFeature it) {
                        String string = it.getId();
                        return Objects.equal((Object)string, (Object)word);
                    }
                };
                expressionFeature3 = (IDetailExpressionProvider.ExpressionFeature)IterableExtensions.findFirst((Iterable)exprProvider.getContextFeatures(contextFeature), (Functions.Function1)object);
            }
            expressionFeature2 = expressionFeature3;
            return expressionFeature2;
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
    }

    public static class ExpressionCache {
        private final GenModelAccess genModelAccess = new GenModelAccess();
        private final Map<RoomClass, ImmutableList<IDetailExpressionProvider.ExpressionFeature>> sharedCaches = CollectionLiterals.newHashMap();
    }

    public static class GenModelAccess {
        private final ExtendedFsmGenBuilderFactory fsmGenBuilderFactory = (ExtendedFsmGenBuilderFactory)RoomUiModule.getInjector().getInstance(ExtendedFsmGenBuilderFactory.class);
        private Map<ModelComponent, GraphContainer> cache = CollectionLiterals.newHashMap();

        public GraphContainer get(ModelComponent mc) {
            boolean bl;
            boolean bl2 = this.cache.containsKey(mc);
            boolean bl3 = bl = !bl2;
            if (bl) {
                ExtendedFsmGenBuilder builder = this.fsmGenBuilderFactory.create();
                GraphContainer gc = builder.createTransformedModel(mc);
                builder.withCommonData(gc);
                this.cache.put(mc, gc);
            }
            return this.cache.get(mc);
        }
    }
}

