/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.scoping.ModelLocator;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.xtext.ui.resource.XtextResourceSetProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class GeneratorLaunchHelper {
    @Inject
    private XtextResourceSetProvider resourceSetProvider;
    @Inject
    private ModelLocator modelLocator;

    public static Iterable<String> getAllDependenciesWithinProject(final IProject project, final Iterable<String> models) {
        LinkedHashSet linkedHashSet = null;
        GeneratorLaunchHelper generatorLaunchHelper = new GeneratorLaunchHelper();
        Procedures.Procedure1<GeneratorLaunchHelper> procedure1 = new Procedures.Procedure1<GeneratorLaunchHelper>(){

            public void apply(GeneratorLaunchHelper it) {
                RoomUiModule.getInjector().injectMembers((Object)it);
            }
        };
        final GeneratorLaunchHelper helper = (GeneratorLaunchHelper)ObjectExtensions.operator_doubleArrow((Object)generatorLaunchHelper, (Procedures.Procedure1)procedure1);
        LinkedHashSet linkedHashSet2 = CollectionLiterals.newLinkedHashSet();
        Procedures.Procedure1<LinkedHashSet<String>> procedure12 = new Procedures.Procedure1<LinkedHashSet<String>>(){

            public void apply(LinkedHashSet<String> it) {
                Iterables.addAll(it, (Iterable)models);
                Iterables.addAll(it, helper.getAllDependencies(project, models));
            }
        };
        linkedHashSet = (LinkedHashSet)ObjectExtensions.operator_doubleArrow((Object)linkedHashSet2, (Procedures.Procedure1)procedure12);
        return linkedHashSet;
    }

    public Iterable<String> getAllDependencies(final IProject project, Iterable<String> models) {
        Iterable iterable = null;
        final IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        final ResourceSet rs = this.resourceSetProvider.get(project);
        Functions.Function1<String, URI> function1 = new Functions.Function1<String, URI>(){

            public URI apply(String filePath) {
                String string = null;
                String string2 = GeneratorLaunchHelper.this.modelLocator.resolve(filePath, null);
                string = string2 != null ? string2 : "";
                return URI.createURI((String)string);
            }
        };
        Consumer<URI> consumer = new Consumer<URI>(){

            @Override
            public void accept(URI uri) {
                block2: {
                    try {
                        rs.getResource(uri, true);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof RuntimeException) break block2;
                        throw Exceptions.sneakyThrow((Throwable)throwable);
                    }
                }
            }
        };
        IterableExtensions.map(models, (Functions.Function1)function1).forEach(consumer);
        EcoreUtil.resolveAll((ResourceSet)rs);
        Functions.Function1<Resource, IResource> function12 = new Functions.Function1<Resource, IResource>(){

            public IResource apply(Resource it) {
                boolean bl;
                Object object;
                URI uRI;
                IResource iResource = null;
                URI it_1 = uRI = it.getURI();
                boolean bl2 = false;
                boolean bl3 = it_1.isPlatformResource();
                if (bl3) {
                    bl2 = true;
                    String string = it_1.toPlatformString(false);
                    object = new Path(string);
                    iResource = ws.findMember((IPath)object);
                }
                if (!bl2 && (bl = it_1.isFile())) {
                    bl2 = true;
                    object = it_1.toFileString();
                    Path path = new Path((String)object);
                    iResource = ws.getFileForLocation((IPath)path);
                }
                return iResource;
            }
        };
        Functions.Function1<IResource, Boolean> function13 = new Functions.Function1<IResource, Boolean>(){

            public Boolean apply(IResource file) {
                return file.getProject().equals((Object)project);
            }
        };
        Functions.Function1<IResource, String> function14 = new Functions.Function1<IResource, String>(){

            public String apply(IResource it) {
                IPath iPath = it.getLocation();
                String string = null;
                if (iPath != null) {
                    string = iPath.toOSString();
                }
                return string;
            }
        };
        iterable = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)rs.getResources(), (Functions.Function1)function12)), (Functions.Function1)function13), (Functions.Function1)function14));
        return iterable;
    }

    public static Map<IProject, List<String>> groupByProject(Collection<String> files) {
        final IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        Functions.Function1<String, IProject> function1 = new Functions.Function1<String, IProject>(){

            public IProject apply(String it) {
                Path path = new Path(it);
                IFile iFile = ws.getFileForLocation((IPath)path);
                IProject iProject = null;
                if (iFile != null) {
                    iProject = iFile.getProject();
                }
                return iProject;
            }
        };
        Map m = IterableExtensions.groupBy(files, (Functions.Function1)function1);
        m.remove(null);
        return m;
    }
}

