/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.support;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.util.FSMSwitch;
import org.eclipse.etrice.core.fsm.naming.FSMFragmentProvider;
import org.eclipse.etrice.ui.behavior.fsm.editor.AbstractFSMDiagramTypeProvider;
import org.eclipse.etrice.ui.behavior.fsm.provider.IInjectorProvider;
import org.eclipse.etrice.ui.behavior.fsm.support.ChoicePointSupport;
import org.eclipse.etrice.ui.behavior.fsm.support.DiagramUpdateFeature;
import org.eclipse.etrice.ui.behavior.fsm.support.InitialPointSupport;
import org.eclipse.etrice.ui.behavior.fsm.support.StateGraphSupport;
import org.eclipse.etrice.ui.behavior.fsm.support.StateSupport;
import org.eclipse.etrice.ui.behavior.fsm.support.TrPointSupport;
import org.eclipse.etrice.ui.behavior.fsm.support.TransitionSupport;
import org.eclipse.etrice.ui.common.base.support.CantDeleteFeature;
import org.eclipse.etrice.ui.common.base.support.CantRemoveFeature;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveBendpointFeature;
import org.eclipse.graphiti.features.IMoveConnectionDecoratorFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveBendpointFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IBendpointContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IMoveConnectionDecoratorContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.IShapeSelectionInfo;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.tb.ShapeSelectionInfoImpl;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.IColorConstant;

public class AbstractFSMProviderDispatcher {
    private StateGraphSupport stateGraphSupport;
    private TrPointSupport trPointSupport;
    private InitialPointSupport initialPointSupport;
    private ChoicePointSupport choicePointSupport;
    private StateSupport stateSupport;
    private TransitionSupport transitionSupport;
    private FeatureProviderSwitch featureSwitch;
    private ToolBehaviorProviderSwitch behaviorSwitch;
    private DispatchingFeatureProvider dispatchingFP;
    private DispatchingToolBehaviorProvider dispatchingBP;

    public AbstractFSMProviderDispatcher(AbstractFSMDiagramTypeProvider dtp) {
        this.dispatchingFP = new DispatchingFeatureProvider(dtp);
        this.dispatchingBP = new DispatchingToolBehaviorProvider((IDiagramTypeProvider)dtp);
        this.stateGraphSupport = new StateGraphSupport((IDiagramTypeProvider)dtp, (IFeatureProvider)this.dispatchingFP);
        this.trPointSupport = new TrPointSupport((IDiagramTypeProvider)dtp, (IFeatureProvider)this.dispatchingFP);
        this.initialPointSupport = new InitialPointSupport((IDiagramTypeProvider)dtp, (IFeatureProvider)this.dispatchingFP);
        this.choicePointSupport = new ChoicePointSupport((IDiagramTypeProvider)dtp, (IFeatureProvider)this.dispatchingFP);
        this.stateSupport = new StateSupport((IDiagramTypeProvider)dtp, (IFeatureProvider)this.dispatchingFP);
        this.transitionSupport = new TransitionSupport((IDiagramTypeProvider)dtp, (IFeatureProvider)this.dispatchingFP);
        this.featureSwitch = new FeatureProviderSwitch();
        this.behaviorSwitch = new ToolBehaviorProviderSwitch();
    }

    public IFeatureProvider getFeatureProvider() {
        return this.dispatchingFP;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.dispatchingBP;
    }

    private ICreateFeature[] getAllCreateFeatures() {
        return this.featureSwitch.getCreateFeatures();
    }

    private ICreateConnectionFeature[] getAllCreateConnectionFeatures() {
        return this.featureSwitch.getCreateConnectionFeatures();
    }

    @SafeVarargs
    private static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        T[][] TArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            T[] array = TArray[n2];
            totalLength += array.length;
            ++n2;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        T[][] TArray2 = rest;
        int n3 = rest.length;
        int n4 = 0;
        while (n4 < n3) {
            T[] array = TArray2[n4];
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
            ++n4;
        }
        return result;
    }

    private class DispatchingFeatureProvider
    extends DefaultFeatureProvider
    implements IInjectorProvider {
        private IInjectorProvider injectorProvider;

        public DispatchingFeatureProvider(AbstractFSMDiagramTypeProvider dtp) {
            super((IDiagramTypeProvider)dtp);
            this.injectorProvider = dtp;
        }

        public ICreateFeature[] getCreateFeatures() {
            return AbstractFSMProviderDispatcher.this.getAllCreateFeatures();
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return AbstractFSMProviderDispatcher.this.getAllCreateConnectionFeatures();
        }

        public IAddFeature getAddFeature(IAddContext context) {
            AbstractFSMProviderDispatcher.this.featureSwitch.setParentContainer(context.getTargetContainer());
            IFeatureProvider fp = AbstractFSMProviderDispatcher.this.featureSwitch.doSwitch((EObject)context.getNewObject());
            if (fp == null) {
                return super.getAddFeature(context);
            }
            return fp.getAddFeature(context);
        }

        public ILayoutFeature getLayoutFeature(ILayoutContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getLayoutFeature(context);
            }
            return super.getLayoutFeature(context);
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getMoveShapeFeature(context);
            }
            return super.getMoveShapeFeature(context);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getResizeShapeFeature(context);
            }
            return super.getResizeShapeFeature(context);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            if (context.getPictogramElement() instanceof Diagram) {
                return new DiagramUpdateFeature((IFeatureProvider)this);
            }
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getUpdateFeature(context);
            }
            return super.getUpdateFeature(context);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            if (context.getPictogramElement() instanceof ConnectionDecorator) {
                return new CantDeleteFeature((IFeatureProvider)this);
            }
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getDeleteFeature(context);
            }
            return super.getDeleteFeature(context);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            if (context.getPictogramElement() instanceof ConnectionDecorator) {
                return new CantRemoveFeature((IFeatureProvider)this);
            }
            IFeatureProvider fp = this.getFeatureProvider((IPictogramElementContext)context);
            if (fp != null) {
                return fp.getRemoveFeature(context);
            }
            return super.getRemoveFeature(context);
        }

        public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
            IFeatureProvider fp = this.getFeatureProvider(context);
            if (fp != null) {
                return fp.getReconnectionFeature(context);
            }
            return super.getReconnectionFeature(context);
        }

        public IAddBendpointFeature getAddBendpointFeature(IAddBendpointContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IBendpointContext)context);
            if (fp != null) {
                return fp.getAddBendpointFeature(context);
            }
            return super.getAddBendpointFeature(context);
        }

        public IMoveBendpointFeature getMoveBendpointFeature(IMoveBendpointContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IBendpointContext)context);
            if (fp != null) {
                return fp.getMoveBendpointFeature(context);
            }
            return super.getMoveBendpointFeature(context);
        }

        public IRemoveBendpointFeature getRemoveBendpointFeature(IRemoveBendpointContext context) {
            IFeatureProvider fp = this.getFeatureProvider((IBendpointContext)context);
            if (fp != null) {
                return fp.getRemoveBendpointFeature(context);
            }
            return super.getRemoveBendpointFeature(context);
        }

        public IMoveConnectionDecoratorFeature getMoveConnectionDecoratorFeature(IMoveConnectionDecoratorContext context) {
            IFeatureProvider fp = this.getFeatureProvider(context);
            if (fp != null) {
                return fp.getMoveConnectionDecoratorFeature(context);
            }
            return super.getMoveConnectionDecoratorFeature(context);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            ArrayList<ICustomFeature> result = new ArrayList<ICustomFeature>();
            IFeatureProvider fp = AbstractFSMProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject(context));
            ICustomFeature[] custom = fp != null ? fp.getCustomFeatures(context) : super.getCustomFeatures(context);
            ICustomFeature[] iCustomFeatureArray = custom;
            int n = custom.length;
            int n2 = 0;
            while (n2 < n) {
                ICustomFeature cust = iCustomFeatureArray[n2];
                result.add(cust);
                ++n2;
            }
            ICustomFeature[] features = new ICustomFeature[result.size()];
            return result.toArray(features);
        }

        private EObject getBusinessObject(IPictogramElementContext context) {
            PictogramElement pictogramElement = context.getPictogramElement();
            EObject bo = (EObject)this.getBusinessObjectForPictogramElement(pictogramElement);
            return bo;
        }

        private EObject getBusinessObject(ICustomContext context) {
            PictogramElement[] pes = context.getPictogramElements();
            if (pes.length > 0) {
                PictogramElement pe = pes[0];
                if (pe instanceof ConnectionDecorator) {
                    pe = (PictogramElement)pe.eContainer();
                }
                EObject bo = (EObject)this.getBusinessObjectForPictogramElement(pe);
                return bo;
            }
            return null;
        }

        private IFeatureProvider getFeatureProvider(IPictogramElementContext context) {
            EObject eco = context.getPictogramElement().eContainer();
            if (eco instanceof ContainerShape) {
                AbstractFSMProviderDispatcher.this.featureSwitch.setParentContainer((ContainerShape)eco);
                IFeatureProvider fp = AbstractFSMProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject(context));
                if (fp != null) {
                    return fp;
                }
            }
            return null;
        }

        private IFeatureProvider getFeatureProvider(IReconnectionContext context) {
            return AbstractFSMProviderDispatcher.this.featureSwitch.doSwitch((EObject)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection()));
        }

        private IFeatureProvider getFeatureProvider(IBendpointContext context) {
            return AbstractFSMProviderDispatcher.this.featureSwitch.doSwitch((EObject)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection()));
        }

        private IFeatureProvider getFeatureProvider(IMoveConnectionDecoratorContext context) {
            return AbstractFSMProviderDispatcher.this.featureSwitch.doSwitch((EObject)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnectionDecorator().getConnection()));
        }

        @Override
        public Injector getInjector() {
            return this.injectorProvider.getInjector();
        }
    }

    private class DispatchingToolBehaviorProvider
    extends DefaultToolBehaviorProvider {
        public DispatchingToolBehaviorProvider(IDiagramTypeProvider diagramTypeProvider) {
            super(diagramTypeProvider);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(pe);
            if (bp == null) {
                return super.getClickArea(pe);
            }
            return bp.getClickArea(pe);
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(pe);
            if (bp == null) {
                return super.getSelectionBorder(pe);
            }
            return bp.getSelectionBorder(pe);
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(context.getPictogramElements()[0]);
            if (bp == null) {
                return super.getDoubleClickFeature(context);
            }
            return bp.getDoubleClickFeature(context);
        }

        protected IToolBehaviorProvider getToolBehaviorProvider(PictogramElement pe) {
            IToolBehaviorProvider bp;
            EObject bo;
            IFeatureProvider fp = this.getFeatureProvider();
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            if ((bo = (EObject)fp.getBusinessObjectForPictogramElement(pe)) == null) {
                return null;
            }
            EObject eco = pe.eContainer();
            if (eco instanceof ContainerShape) {
                AbstractFSMProviderDispatcher.this.behaviorSwitch.setParentContainer((ContainerShape)eco);
                bp = AbstractFSMProviderDispatcher.this.behaviorSwitch.doSwitch(bo);
                if (bp != null) {
                    return bp;
                }
            }
            bp = AbstractFSMProviderDispatcher.this.behaviorSwitch.doSwitch(bo);
            return bp;
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(context.getPictogramElement());
            if (bp == null) {
                return super.getContextButtonPad(context);
            }
            return bp.getContextButtonPad(context);
        }

        public IShapeSelectionInfo getSelectionInfoForShape(Shape shape) {
            ShapeSelectionInfoImpl ssi = new ShapeSelectionInfoImpl();
            ssi.setColor(IColorConstant.SHAPE_SELECTION_FG);
            ssi.setPrimarySelectionHandleForegroundColor(IColorConstant.HANDLE_FG);
            ssi.setPrimarySelectionHandleBackgroundColor(IColorConstant.HANDLE_BG);
            ssi.setLineStyle(LineStyle.DASH);
            ssi.setPrimarySelectionBackgroundColor(IColorConstant.LIGHT_ORANGE);
            ssi.setSecondarySelectionBackgroundColor(IColorConstant.LIGHT_ORANGE);
            return ssi;
        }

        public Object getToolTip(GraphicsAlgorithm ga) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(ga.getPictogramElement());
            if (bp == null) {
                return super.getToolTip(ga);
            }
            return bp.getToolTip(ga);
        }

        public IDecorator[] getDecorators(PictogramElement pe) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(pe);
            if (bp == null) {
                return super.getDecorators(pe);
            }
            return bp.getDecorators(pe);
        }
    }

    private class FeatureProviderSwitch
    extends FSMSwitch<IFeatureProvider> {
        private ContainerShape parent = null;

        private FeatureProviderSwitch() {
        }

        public IFeatureProvider doSwitch(EObject theEObject) {
            if (theEObject == null) {
                return null;
            }
            if (theEObject.eIsProxy()) {
                if (FSMFragmentProvider.isState((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.stateSupport.getFeatureProvider();
                }
                if (FSMFragmentProvider.isTrPoint((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.trPointSupport.getFeatureProvider();
                }
                if (FSMFragmentProvider.isChoicePoint((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.choicePointSupport.getFeatureProvider();
                }
                if (FSMFragmentProvider.isStateGraph((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.stateGraphSupport.getFeatureProvider();
                }
                if (FSMFragmentProvider.isTransition((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.transitionSupport.getFeatureProvider();
                }
                if (FSMFragmentProvider.isTransition((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.transitionSupport.getFeatureProvider();
                }
            }
            return (IFeatureProvider)super.doSwitch(theEObject);
        }

        public IFeatureProvider caseStateGraph(StateGraph object) {
            if (this.parent != null && this.parent.getLink() != null) {
                EObject bo;
                if (this.parent.getLink().getBusinessObjects().size() > 0 && (bo = (EObject)this.parent.getLink().getBusinessObjects().get(0)) instanceof StateGraph) {
                    return AbstractFSMProviderDispatcher.this.initialPointSupport.getFeatureProvider();
                }
                this.parent = null;
            }
            return AbstractFSMProviderDispatcher.this.stateGraphSupport.getFeatureProvider();
        }

        public IFeatureProvider caseTrPoint(TrPoint object) {
            return AbstractFSMProviderDispatcher.this.trPointSupport.getFeatureProvider();
        }

        public IFeatureProvider caseChoicePoint(ChoicePoint object) {
            return AbstractFSMProviderDispatcher.this.choicePointSupport.getFeatureProvider();
        }

        public IFeatureProvider caseState(State object) {
            return AbstractFSMProviderDispatcher.this.stateSupport.getFeatureProvider();
        }

        public IFeatureProvider caseTransition(Transition object) {
            return AbstractFSMProviderDispatcher.this.transitionSupport.getFeatureProvider();
        }

        public IFeatureProvider caseRefinedTransition(RefinedTransition object) {
            return AbstractFSMProviderDispatcher.this.transitionSupport.getFeatureProvider();
        }

        public IFeatureProvider defaultCase(EObject object) {
            return null;
        }

        public ICreateFeature[] getCreateFeatures() {
            return (ICreateFeature[])AbstractFSMProviderDispatcher.concatAll(AbstractFSMProviderDispatcher.this.stateSupport.getFeatureProvider().getCreateFeatures(), new ICreateFeature[][]{AbstractFSMProviderDispatcher.this.initialPointSupport.getFeatureProvider().getCreateFeatures(), AbstractFSMProviderDispatcher.this.trPointSupport.getFeatureProvider().getCreateFeatures(), AbstractFSMProviderDispatcher.this.choicePointSupport.getFeatureProvider().getCreateFeatures()});
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return AbstractFSMProviderDispatcher.this.transitionSupport.getFeatureProvider().getCreateConnectionFeatures();
        }

        public void setParentContainer(ContainerShape parent) {
            this.parent = parent;
        }
    }

    private class ToolBehaviorProviderSwitch
    extends FSMSwitch<IToolBehaviorProvider> {
        private ContainerShape parent = null;

        private ToolBehaviorProviderSwitch() {
        }

        public IToolBehaviorProvider doSwitch(EObject theEObject) {
            if (theEObject == null) {
                return null;
            }
            if (theEObject.eIsProxy()) {
                if (FSMFragmentProvider.isState((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.stateGraphSupport.getToolBehaviorProvider();
                }
                if (FSMFragmentProvider.isTrPoint((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.trPointSupport.getToolBehaviorProvider();
                }
                if (FSMFragmentProvider.isChoicePoint((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.choicePointSupport.getToolBehaviorProvider();
                }
                if (FSMFragmentProvider.isStateGraph((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.stateGraphSupport.getToolBehaviorProvider();
                }
                if (FSMFragmentProvider.isTransition((EObject)theEObject)) {
                    return AbstractFSMProviderDispatcher.this.transitionSupport.getToolBehaviorProvider();
                }
            }
            return (IToolBehaviorProvider)super.doSwitch(theEObject);
        }

        public IToolBehaviorProvider caseStateGraph(StateGraph object) {
            if (this.parent != null && this.parent.getLink() != null) {
                EObject bo;
                if (this.parent.getLink().getBusinessObjects().size() > 0 && (bo = (EObject)this.parent.getLink().getBusinessObjects().get(0)) instanceof StateGraph) {
                    return AbstractFSMProviderDispatcher.this.initialPointSupport.getToolBehaviorProvider();
                }
                this.parent = null;
            }
            return AbstractFSMProviderDispatcher.this.stateGraphSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseTrPoint(TrPoint object) {
            return AbstractFSMProviderDispatcher.this.trPointSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseChoicePoint(ChoicePoint object) {
            return AbstractFSMProviderDispatcher.this.choicePointSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseState(State object) {
            return AbstractFSMProviderDispatcher.this.stateSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseTransition(Transition object) {
            return AbstractFSMProviderDispatcher.this.transitionSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider defaultCase(EObject object) {
            return null;
        }

        public void setParentContainer(ContainerShape parent) {
            this.parent = parent;
        }
    }
}

