/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.common.base.support.BaseToolBehaviorProvider;
import org.eclipse.etrice.ui.common.base.support.CantRemoveFeature;
import org.eclipse.etrice.ui.common.base.support.ChangeAwareCreateConnectionFeature;
import org.eclipse.etrice.ui.common.base.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.etrice.ui.structure.support.context.ConnectionUpdateContext;
import org.eclipse.etrice.ui.structure.support.context.InitialAddConnectionContext;
import org.eclipse.etrice.ui.structure.support.feature.ConnectionUpdateFeature;
import org.eclipse.etrice.ui.structure.support.provider.ConnectionProvider;
import org.eclipse.etrice.ui.structure.support.provider.DecorationProvider;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class BindingSupport {
    public static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    public static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public BindingSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    class BehaviorProvider
    extends BaseToolBehaviorProvider {
        public Object getToolTip(GraphicsAlgorithm ga) {
            EObject bo;
            PictogramElement pe = ga.getPictogramElement();
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            if ((bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof Binding) {
                Binding bind = (Binding)bo;
                return SupportUtil.getInstance().getRoomNameProvider().getDisplayName(bind);
            }
            return super.getToolTip(ga);
        }

        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }
    }

    static class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        private boolean isInherited(Diagram diag, Binding b) {
            StructureClass ac = (StructureClass)Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diag.getChildren().get(0));
            return b.eContainer() != ac;
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return new ICreateConnectionFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
            return new ReconnectionFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new CantRemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                return context.getNewObject() instanceof Binding;
            }

            public PictogramElement add(IAddContext context) {
                Binding bind = (Binding)context.getNewObject();
                boolean inherited = FeatureProvider.this.isInherited(this.getDiagram(), bind);
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                FreeFormConnection connection = peCreateService.createFreeFormConnection(this.getDiagram());
                if (context instanceof InitialAddConnectionContext) {
                    ConnectionProvider cp = ((InitialAddConnectionContext)context).getConnectionProvider();
                    Anchor a1 = cp.getAnchor(bind.getEndpoint1());
                    Anchor a2 = cp.getAnchor(bind.getEndpoint2());
                    assert (a1 != null && a2 != null) : "start and end anchor must be present";
                    connection.setStart(a1);
                    connection.setEnd(a2);
                } else {
                    IAddConnectionContext addConContext = (IAddConnectionContext)context;
                    connection.setStart(addConContext.getSourceAnchor());
                    connection.setEnd(addConContext.getTargetAnchor());
                }
                Graphiti.getPeService().setPropertyValue((PropertyContainer)connection, "obj-type", "bind");
                IGaService gaService = Graphiti.getGaService();
                Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
                polyline.setForeground(this.manageColor(inherited ? INHERITED_COLOR : LINE_COLOR));
                this.link((PictogramElement)connection, bind);
                this.updatePictogramElement((PictogramElement)connection);
                return connection;
            }
        }

        private class CreateFeature
        extends ChangeAwareCreateConnectionFeature {
            public CreateFeature(IFeatureProvider fp) {
                super(fp, "Binding", "create Binding");
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.structure.binding";
            }

            public boolean canCreate(ICreateConnectionContext context) {
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getInstance().getPort(context.getSourceAnchor(), featureProvider);
                Port tgt = SupportUtil.getInstance().getPort(context.getTargetAnchor(), featureProvider);
                ActorContainerRef srcRef = SupportUtil.getInstance().getRef(context.getSourceAnchor(), featureProvider);
                if (src == null || tgt == null) {
                    return false;
                }
                StructureClass ac = SupportUtil.getInstance().getParent(context, featureProvider);
                if (ac == null) {
                    return false;
                }
                ActorContainerRef tgtRef = SupportUtil.getInstance().getRef(context.getTargetAnchor(), featureProvider);
                return SupportUtil.getInstance().getValidationUtil().isConnectable(src, srcRef, tgt, tgtRef, ac, null).isOk();
            }

            public boolean canStartConnection(ICreateConnectionContext context) {
                boolean canStart;
                if (context.getSourceAnchor() == null) {
                    return false;
                }
                Port src = SupportUtil.getInstance().getPort(context.getSourceAnchor(), this.getFeatureProvider());
                boolean bl = canStart = src != null;
                if (canStart) {
                    ActorContainerRef ref = SupportUtil.getInstance().getRef(context.getSourceAnchor(), this.getFeatureProvider());
                    if (ref == null) {
                        ActorContainerClass acc = (ActorContainerClass)src.eContainer();
                        if (!SupportUtil.getInstance().getValidationUtil().isConnectable(src, null, (StructureClass)acc).isOk()) {
                            canStart = false;
                        }
                    } else {
                        StructureClass acc = (StructureClass)ref.eContainer();
                        if (!SupportUtil.getInstance().getValidationUtil().isConnectable(src, ref, acc).isOk()) {
                            canStart = false;
                        }
                    }
                }
                return canStart;
            }

            public void attachedToSource(ICreateConnectionContext context) {
                Port src = SupportUtil.getInstance().getPort(context.getSourceAnchor(), this.getFeatureProvider());
                ActorContainerRef ref = SupportUtil.getInstance().getRef(context.getSourceAnchor(), this.getFeatureProvider());
                StructureClass sc = SupportUtil.getInstance().getParent(context, this.getFeatureProvider());
                this.beginHighLightMatches(sc, src, ref);
            }

            public void canceledAttaching(ICreateConnectionContext context) {
                this.endHighLightMatches();
            }

            public void endConnecting() {
                this.endHighLightMatches();
            }

            private void beginHighLightMatches(StructureClass sc, Port src, ActorContainerRef srcRef) {
                if (src == null) {
                    return;
                }
                ContainerShape scContainer = (ContainerShape)this.getDiagram().getChildren().get(0);
                for (Shape subShape : scContainer.getChildren()) {
                    Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)subShape);
                    if (bo instanceof Port) {
                        if (!SupportUtil.getInstance().getValidationUtil().isConnectable(src, srcRef, (Port)bo, null, sc, null).isOk()) continue;
                        DecorationProvider.addAllowedPortShape(subShape);
                        this.getDiagramBehavior().refreshRenderingDecorators((PictogramElement)subShape);
                        continue;
                    }
                    if (!(bo instanceof ActorContainerRef)) continue;
                    ActorContainerRef tgtRef = (ActorContainerRef)bo;
                    for (Shape subSubShape : ((ContainerShape)subShape).getChildren()) {
                        bo = this.getBusinessObjectForPictogramElement((PictogramElement)subSubShape);
                        if (!(bo instanceof Port) || !SupportUtil.getInstance().getValidationUtil().isConnectable(src, srcRef, (Port)bo, tgtRef, sc, null).isOk()) continue;
                        DecorationProvider.addAllowedPortShape(subSubShape);
                        this.getDiagramBehavior().refreshRenderingDecorators((PictogramElement)subSubShape);
                    }
                }
            }

            private void endHighLightMatches() {
                DecorationProvider.clearAllowedPortShapes();
                this.getDiagramBehavior().refresh();
            }

            protected Connection doCreate(ICreateConnectionContext context) {
                Connection newConnection = null;
                this.endHighLightMatches();
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getInstance().getPort(context.getSourceAnchor(), featureProvider);
                Port dst = SupportUtil.getInstance().getPort(context.getTargetAnchor(), featureProvider);
                StructureClass sc = SupportUtil.getInstance().getParent(context, featureProvider);
                if (src != null && dst != null && sc != null) {
                    Binding bind = RoomFactory.eINSTANCE.createBinding();
                    BindingEndPoint ep1 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar1 = SupportUtil.getInstance().getRef(context.getSourceAnchor(), featureProvider);
                    ep1.setPort(src);
                    ep1.setActorRef(ar1);
                    BindingEndPoint ep2 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar2 = SupportUtil.getInstance().getRef(context.getTargetAnchor(), featureProvider);
                    ep2.setPort(dst);
                    ep2.setActorRef(ar2);
                    bind.setEndpoint1(ep1);
                    bind.setEndpoint2(ep2);
                    sc.getBindings().add((Object)bind);
                    AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
                    addContext.setNewObject((Object)bind);
                    newConnection = (Connection)featureProvider.addIfPossible((IAddContext)addContext);
                }
                return newConnection;
            }
        }

        private class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(context.getPictogramElement());
                if (bo instanceof Binding) {
                    Binding b = (Binding)bo;
                    if (FeatureProvider.this.isInherited(this.getDiagram(), b)) {
                        return false;
                    }
                }
                return true;
            }
        }

        private class ReconnectionFeature
        extends DefaultReconnectionFeature {
            private boolean doneChanges;

            public ReconnectionFeature(IFeatureProvider fp) {
                super(fp);
                this.doneChanges = false;
            }

            public boolean canReconnect(IReconnectionContext context) {
                if (!super.canReconnect(context)) {
                    return false;
                }
                Binding bind = (Binding)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                if (FeatureProvider.this.isInherited(this.getDiagram(), bind)) {
                    return false;
                }
                Anchor asrc = context.getConnection().getStart();
                Anchor atgt = context.getConnection().getEnd();
                if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
                    asrc = context.getNewAnchor();
                } else {
                    atgt = context.getNewAnchor();
                }
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getInstance().getPort(asrc, featureProvider);
                Port tgt = SupportUtil.getInstance().getPort(atgt, featureProvider);
                ActorContainerRef srcRef = SupportUtil.getInstance().getRef(asrc, featureProvider);
                if (src == null || tgt == null) {
                    return false;
                }
                StructureClass ac = SupportUtil.getInstance().getParent((ContainerShape)this.getDiagram(), featureProvider);
                if (ac == null) {
                    return false;
                }
                ActorContainerRef tgtRef = SupportUtil.getInstance().getRef(atgt, featureProvider);
                return SupportUtil.getInstance().getValidationUtil().isConnectable(src, srcRef, tgt, tgtRef, ac, bind).isOk();
            }

            public void postReconnect(IReconnectionContext context) {
                super.postReconnect(context);
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getInstance().getPort(context.getConnection().getStart(), featureProvider);
                Port dst = SupportUtil.getInstance().getPort(context.getConnection().getEnd(), featureProvider);
                StructureClass sc = SupportUtil.getInstance().getParent((ContainerShape)this.getDiagram(), featureProvider);
                if (src != null && dst != null && sc != null) {
                    Binding bind = (Binding)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                    BindingEndPoint ep1 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar1 = SupportUtil.getInstance().getRef(context.getConnection().getStart(), featureProvider);
                    ep1.setPort(src);
                    ep1.setActorRef(ar1);
                    BindingEndPoint ep2 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar2 = SupportUtil.getInstance().getRef(context.getConnection().getEnd(), featureProvider);
                    ep2.setPort(dst);
                    ep2.setActorRef(ar2);
                    bind.setEndpoint1(ep1);
                    bind.setEndpoint2(ep2);
                    this.doneChanges = true;
                }
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class UpdateFeature
        extends ConnectionUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            @Override
            protected boolean canUpdate(EObject bo, PictogramElement pe) {
                return bo instanceof Binding;
            }

            @Override
            protected boolean update(EObject bo, IUpdateContext context) {
                boolean success = super.update(bo, context);
                Connection conn = (Connection)context.getPictogramElement();
                if (context instanceof ConnectionUpdateContext) {
                    ConnectionProvider cp = ((ConnectionUpdateContext)context).getConnectionProvider();
                    Binding bind = (Binding)bo;
                    Anchor newStart = cp.getAnchor(bind.getEndpoint1());
                    Anchor newEnd = cp.getAnchor(bind.getEndpoint2());
                    assert (newStart != null && newEnd != null) : "start and end anchor must be not null";
                    if (newStart != conn.getStart()) {
                        conn.setStart(newEnd);
                    }
                    if (newEnd != conn.getEnd()) {
                        conn.setEnd(newEnd);
                    }
                }
                return success;
            }
        }
    }
}

