/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.wizard.AbstractExampleInstallerWizard;
import org.eclipse.emf.common.ui.wizard.ExampleInstallerWizard;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NonDeletingWizardInstaller
extends ExampleInstallerWizard {
    protected boolean isPerformingFinish = false;

    protected Diagnostic deleteExistingProjects(IProgressMonitor monitor) {
        return Diagnostic.OK_INSTANCE;
    }

    public boolean performFinish() {
        this.isPerformingFinish = true;
        return super.performFinish();
    }

    protected void openFiles(IProgressMonitor progressMonitor) {
        super.openFiles(progressMonitor);
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.wizardConfigurationElement);
        if (this.getFilesToOpen().size() == 1) {
            BasicNewProjectResourceWizard.selectAndReveal((IResource)((AbstractExampleInstallerWizard.FileToOpen)this.getFilesToOpen().get(0)).getWorkspaceFile(), (IWorkbenchWindow)this.getWorkbench().getActiveWorkbenchWindow());
        }
    }

    protected List<AbstractExampleInstallerWizard.ProjectDescriptor> getProjectDescriptors() {
        if (!this.isPerformingFinish) {
            return super.getProjectDescriptors();
        }
        ArrayList<AbstractExampleInstallerWizard.ProjectDescriptor> newProjects = new ArrayList<AbstractExampleInstallerWizard.ProjectDescriptor>();
        for (AbstractExampleInstallerWizard.ProjectDescriptor desc : super.getProjectDescriptors()) {
            if (desc.getProject().exists()) continue;
            newProjects.add(desc);
        }
        return newProjects;
    }

    public void addPages() {
        this.projectPage = new CustomProjectPage("projectPage", "New Projects", null);
        this.projectPage.setDescription("Create example and required library projects listed below.");
        this.addPage((IWizardPage)this.projectPage);
    }

    class CustomProjectPage
    extends AbstractExampleInstallerWizard.ProjectPage {
        public CustomProjectPage(String pageName, String title, ImageDescriptor titleImage) {
            super((AbstractExampleInstallerWizard)NonDeletingWizardInstaller.this, pageName, title, titleImage);
        }

        protected void itemSelected() {
            this.renameButton.setEnabled(false);
            AbstractExampleInstallerWizard.ProjectDescriptor projectDescriptor = this.getSelectedProjectDescriptor();
            if (projectDescriptor != null) {
                String description;
                boolean exists = projectDescriptor.getProject().exists();
                String string = description = projectDescriptor.getDescription() != null ? projectDescriptor.getDescription() : "";
                if (exists) {
                    String renameMessage = "* A project with this name already exists in the workspace and will not be added.";
                    description = description == "" ? renameMessage : CommonUIPlugin.INSTANCE.getString("_UI_ProjectDescriptionAndRename_message", (Object[])new String[]{description, renameMessage});
                }
                this.descriptionText.setText(description);
            }
        }
    }
}

