/*******************************************************************************
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 
 *******************************************************************************/

package org.eclipse.etrice.generator.base;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

/**
 * a {@link JavaIoFileSystemAccess} which is recording the generated files
 * 
 * @author Henrik Rentz-Reichert
 *
 */
public class RecordingFileSystemAccess extends JavaIoFileSystemAccess {

	private ArrayList<String> files = new ArrayList<String>();
	
	@Override
	public void generateFile(String fileName, String slot, CharSequence contents) {
		String outlet = getPathes().get(slot);
		if (outlet!=null) {
			String pathName = toSystemFileName(outlet + "/" + fileName);
			files.add(pathName);
		}
		super.generateFile(fileName, slot, contents);
	}
	
	public ArrayList<String> getFiles() {
		return files;
	}
	
	public ArrayList<String> getFiles(String path, String extension) {
		ArrayList<String> result = new ArrayList<String>();
		
		path = toSystemFileName(path);
		getFilesRecursively(path, result, extension);
		
		return result;
	}

	private void getFilesRecursively(String path, ArrayList<String> result, String extension) {
		File file = new File(path);
		if (file.isDirectory()) {
			if (!file.getName().equals(".svn")) {
				String[] contents = file.list();
				for (String sub : contents) {
					getFilesRecursively(path+File.separator+sub, result, extension);
				}
			}
		}
		else {
			if (file.getName().endsWith(extension))
				result.add(file.getAbsolutePath());
		}
	}
}
