/*******************************************************************************
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 
 *******************************************************************************/

package org.eclipse.etrice.generator.java.gen

import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.IGenerator
import org.eclipse.xtext.generator.IFileSystemAccess
import com.google.inject.Inject

import org.eclipse.emf.ecore.*

import org.eclipse.etrice.core.room.*
import org.eclipse.etrice.generator.etricegen.*

class MainGen implements IGenerator {
	
	@Inject DataClassGen dataClassGen
	@Inject ProtocolClassGen protocolClassGen
	@Inject ActorClassGen actorClassGen
	@Inject SubSystemClassGen subsystemClassGen
	@Inject SubSystemRunnerGen subsystemRunnerGen
	@Inject PrepareFileSystem prepFS
	
	override void doGenerate(Resource resource, IFileSystemAccess fsa) {
		prepFS.prepare(resource)
		for (e: resource.contents){
			if (e instanceof Root) {
				doGenerate(e as Root)
			}
		}
	}
	
	def void doGenerate(Root e) {
		dataClassGen.doGenerate(e);
		protocolClassGen.doGenerate(e);
		actorClassGen.doGenerate(e);
		subsystemClassGen.doGenerate(e);
		
		if (!e.library) {
			subsystemRunnerGen.doGenerate(e);
		}
	}
}